/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Constant;
import com.sanpudo.formula.Delimiter;
import com.sanpudo.formula.DirectValue;
import com.sanpudo.formula.Environments;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.Function;
import com.sanpudo.formula.FunctionImplementation;
import com.sanpudo.formula.LPar;
import com.sanpudo.formula.Operator;
import com.sanpudo.formula.RPar;
import com.sanpudo.formula.Token;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Lex {
    static final char lPar = '(';
    static final char rPar = ')';
    static final char delim = ',';
    static Pattern figure = Pattern.compile("(-?\\d+(\\.\\d*)?)|(-?\\.\\d+)");
    static final String spaceRegex = "\\s+";
    static Pattern space = Pattern.compile("\\s+");
    static Pattern function = Pattern.compile("[a-zA-Z]\\w*\\(");
    Environments environments;
    private static final int REQUEST_VALUE = 0;
    private static final int REQUEST_OPERATOR = 1;

    Lex() {
        this.environments = new Environments();
    }

    Lex(Environments environments) {
        this.environments = environments;
    }

    Vector<Token> analyze(String formula) throws FormulaEvaluatorException {
        return this.analyze(formula, false);
    }

    Vector<Token> analyze(String formula, boolean allowParam) throws FormulaEvaluatorException {
        Pattern constant = allowParam ? Constant.patternParam : Constant.pattern;
        boolean status = false;
        Vector<Token> tokens = new Vector<Token>();
        String wk = new String(formula);
        while (!wk.equals("")) {
            int location = formula.length() - wk.length();
            Matcher spaceMatcher = space.matcher(wk);
            if (spaceMatcher.lookingAt()) {
                wk = wk.substring(spaceMatcher.end());
                continue;
            }
            if (!status) {
                if (wk.charAt(0) == '(') {
                    tokens.add(new LPar(formula, location));
                    wk = wk.substring(1);
                    status = false;
                    continue;
                }
                Matcher matcher = figure.matcher(wk);
                if (matcher.lookingAt()) {
                    tokens.add(new DirectValue(formula, location, wk.substring(0, matcher.end())));
                    wk = wk.substring(matcher.end());
                    status = true;
                    continue;
                }
                matcher = function.matcher(wk);
                if (matcher.lookingAt()) {
                    String name = wk.substring(0, matcher.end() - 1);
                    if (this.environments.isFunction(name)) {
                        FunctionImplementation fun = this.environments.functions(name);
                        tokens.add(new Function(formula, location, name, fun.numberOfArgs(name), this.environments));
                        wk = wk.substring(matcher.end());
                        status = false;
                        continue;
                    }
                    throw new FormulaEvaluatorException("Unknown Function", formula, location);
                }
                matcher = constant.matcher(wk);
                if (matcher.lookingAt()) {
                    String name = wk.substring(0, matcher.end());
                    if (this.environments.isConstant(name)) {
                        tokens.add(new Constant(formula, location, name, this.environments));
                        wk = wk.substring(matcher.end());
                        status = true;
                        continue;
                    }
                    throw new FormulaEvaluatorException("Unknown constant", formula, location);
                }
                if (wk.charAt(0) == ')') {
                    tokens.add(new RPar(formula, location));
                    wk = wk.substring(1);
                    status = true;
                    continue;
                }
                throw new FormulaEvaluatorException("Value expected", formula, location);
            }
            if (wk.charAt(0) == ')') {
                tokens.add(new RPar(formula, location));
                wk = wk.substring(1);
                status = true;
                continue;
            }
            if (wk.charAt(0) == ',') {
                tokens.add(new Delimiter(formula, location));
                wk = wk.substring(1);
                status = false;
                continue;
            }
            char o = wk.charAt(0);
            int i = 0;
            while (i < Operator.operators.length) {
                if (o == Operator.operators[i]) {
                    tokens.add(new Operator(formula, location, o));
                    wk = wk.substring(1);
                    status = false;
                    break;
                }
                ++i;
            }
            if (i < Operator.operators.length) continue;
            throw new FormulaEvaluatorException("Operator expected", formula, location);
        }
        return tokens;
    }

    static boolean isValidFuncName(String funcName) {
        return function.matcher(String.valueOf(funcName) + "(").matches();
    }
}

