package com.sanpudo.formula;

import java.math.BigDecimal;

/**
 * 区切り文字。
 * 
 * @author Sanpudo.
 */
class Delimiter extends Token {

	/** コンストラクタ。 */
	Delimiter(String formula, int location) {
		super(formula, location);
	}

	/** 親の関数を登録。 */
	void bindToParent(Token parent) {
		this.parent = parent;
	}

	/** ファクターの構造が完全でないとき、その理由メッセージを返す。 */
	String imcompleteMessage() {
		// 区切り文字は常に完全
		return null;
	}

	/** ファクターの構造が完全であるかチェックする。 */
	boolean isComplete() {
		// 区切り文字は常に完全
		return true;
	}

	/** 正規化した式を返す。 */
	String normalized() {
		return "";
	}

	/** token文字列を返す。 */
	String strToken() {
		return ",";
	}

	/** doubleの評価値を返す。 */
	double value() throws FormulaEvaluatorException {
		throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
				strToken(), location);
	}

	/** BigDecimalの評価値を返す。 */
	BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
		throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
				strToken(), location);
	}

}
