package com.sanpudo.formula;

import com.sanpudo.formula.Token;

/**
 * 数値(即値または定数)を現す中傷クラス。
 * 
 * @author sanpudo
 */
public abstract class Value extends Token {

	/** コンストラクタ。 */
	Value(String formula, int location) {
		super(formula, location);
	}

	/** ファクターの構造が完全であるかチェックする。 */
	boolean isComplete() {
		// 値は常に完全
		return true;
	}

	/** ファクターの構造が完全でないとき、その理由メッセージを返す。 */
	String imcompleteMessage() {
		// 値は常に完全
		return null;
	}

	/** 正規化した式を返す。 */
	String normalized() {
		return this.strToken();
	}

}
