/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.File;
import java.util.LinkedList;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.Application;
import writer2latex.latex.Context;
import writer2latex.latex.LaTeXDocument;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.content.BlockConverter;
import writer2latex.latex.content.DrawConverter;
import writer2latex.latex.content.FieldConverter;
import writer2latex.latex.content.IndexConverter;
import writer2latex.latex.content.Info;
import writer2latex.latex.content.InlineConverter;
import writer2latex.latex.content.MathmlConverter;
import writer2latex.latex.content.NoteConverter;
import writer2latex.latex.style.CharStyleConverter;
import writer2latex.latex.style.I18n;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.NoteConfigurationConverter;
import writer2latex.latex.style.PageStyleConverter;
import writer2latex.latex.style.ParStyleConverter;
import writer2latex.latex.style.SectionStyleConverter;
import writer2latex.latex.style.TableStyleConverter;
import writer2latex.office.ImageLoader;
import writer2latex.office.MetaData;
import writer2latex.office.ParStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public final class ConverterPalette {
    private Config config;
    private ConvertData convertData;
    private LaTeXDocument texDoc;
    private SxwDocument sxwDoc;
    private String sOutFileName;
    private I18n i18n;
    private WriterStyleCollection wsc = new WriterStyleCollection();
    private CharStyleConverter charSc;
    private ListStyleConverter listSc;
    private ParStyleConverter parSc;
    private PageStyleConverter pageSc;
    private SectionStyleConverter sectionSc;
    private TableStyleConverter tableSc;
    private NoteConfigurationConverter noteCc;
    private BlockConverter blockCv;
    private IndexConverter indexCv;
    private NoteConverter noteCv;
    private InlineConverter inlineCv;
    private FieldConverter fieldCv;
    private DrawConverter drawCv;
    private MathmlConverter mathmlCv;
    private Info info;
    private Context mainContext;
    private MetaData metaData;
    private ImageLoader imageLoader;

    public ConverterPalette(SxwDocument sxwDocument, String string) {
        this.sOutFileName = sxwDocument.getName();
        this.config = new Config();
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                this.config.read(string);
            } else {
                System.out.println("Oops - the configuration file " + string + " does not exist!");
            }
        }
        this.sxwDoc = sxwDocument;
        this.convertData = new ConvertData();
        this.metaData = new MetaData((OfficeDocument)sxwDocument);
        this.wsc.loadStylesFromDOM(sxwDocument.getStyleDOM(), sxwDocument.getContentDOM());
        this.i18n = new I18n(this.wsc, this.config, this);
        this.charSc = new CharStyleConverter(this.wsc, this.config, this);
        this.listSc = new ListStyleConverter(this.wsc, this.config, this);
        this.pageSc = new PageStyleConverter(this.wsc, this.config, this);
        this.parSc = new ParStyleConverter(this.wsc, this.config, this);
        this.sectionSc = new SectionStyleConverter(this.wsc, this.config, this);
        this.tableSc = new TableStyleConverter(this.wsc, this.config, this);
        this.noteCc = new NoteConfigurationConverter(this.wsc, this.config, this);
        this.blockCv = new BlockConverter(this.config, this);
        this.indexCv = new IndexConverter(this.config, this);
        this.noteCv = new NoteConverter(this.config, this);
        this.inlineCv = new InlineConverter(this.config, this);
        this.fieldCv = new FieldConverter(this.config, this);
        this.drawCv = new DrawConverter(this.config, this);
        this.mathmlCv = new MathmlConverter(this.config, this);
        this.info = new Info(this.config, this);
        if (this.config.debug()) {
            System.out.println();
            System.out.println("Loaded " + this.i18n.getCharCount() + " unicode symbols");
        }
    }

    public void setOutFileName(String string) {
        this.sOutFileName = Misc.trimDocumentName(string, ".tex");
    }

    public String getOutFileName() {
        return this.sOutFileName;
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public CharStyleConverter getCharSc() {
        return this.charSc;
    }

    public ParStyleConverter getParSc() {
        return this.parSc;
    }

    public ListStyleConverter getListSc() {
        return this.listSc;
    }

    public PageStyleConverter getPageSc() {
        return this.pageSc;
    }

    public SectionStyleConverter getSectionSc() {
        return this.sectionSc;
    }

    public TableStyleConverter getTableSc() {
        return this.tableSc;
    }

    public NoteConfigurationConverter getNoteCc() {
        return this.noteCc;
    }

    public BlockConverter getBlockCv() {
        return this.blockCv;
    }

    public IndexConverter getIndexCv() {
        return this.indexCv;
    }

    public NoteConverter getNoteCv() {
        return this.noteCv;
    }

    public InlineConverter getInlineCv() {
        return this.inlineCv;
    }

    public FieldConverter getFieldCv() {
        return this.fieldCv;
    }

    public DrawConverter getDrawCv() {
        return this.drawCv;
    }

    public MathmlConverter getMathmlCv() {
        return this.mathmlCv;
    }

    public Info getInfo() {
        return this.info;
    }

    public boolean isPackage() {
        return this.sxwDoc.getStyleDOM() == null;
    }

    public Context getMainContext() {
        return this.mainContext;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void addDocument(Document document) {
        this.convertData.addDocument(document);
    }

    public EmbeddedObject getEmbeddedObject(String string) {
        if (string.startsWith("#")) {
            if ((string = string.substring(1)).startsWith("./")) {
                string = string.substring(2);
            }
            return this.sxwDoc.getEmbeddedObject(string);
        }
        return null;
    }

    public ConvertData convert() {
        Object object;
        Object object2;
        this.imageLoader = new ImageLoader((OfficeDocument)this.sxwDoc, this.sOutFileName, true);
        this.texDoc = new LaTeXDocument(this.sOutFileName);
        this.texDoc.setEncoding(I18n.writeJavaEncoding(this.config.getInputencoding()));
        org.w3c.dom.Document document = this.sxwDoc.getStyleDOM();
        org.w3c.dom.Document document2 = this.sxwDoc.getContentDOM();
        this.i18n.setDefaultLanguage(this.i18n.getMajorityLanguage());
        this.mainContext = new Context();
        this.mainContext.resetFormattingFromStyle(this.wsc.getDefaultParStyle());
        LaTeXDocumentPortion laTeXDocumentPortion = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion laTeXDocumentPortion2 = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion laTeXDocumentPortion3 = new LaTeXDocumentPortion(true);
        NodeList nodeList = document2.getElementsByTagName("office:body");
        int n = nodeList.getLength();
        if (n > 0) {
            object2 = (Element)nodeList.item(0);
            this.prepass((Node)object2);
            this.blockCv.traverseBlockText((Element)object2, laTeXDocumentPortion3, this.mainContext);
            this.noteCv.insertEndnotes(laTeXDocumentPortion3);
        }
        this.i18n.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.charSc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.parSc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.listSc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.pageSc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.sectionSc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.tableSc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.noteCc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.blockCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.indexCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.noteCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.inlineCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.fieldCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.drawCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        this.mathmlCv.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        object2 = this.config.getCustomPreamble();
        int n2 = ((LinkedList)object2).size();
        for (int i = 0; i < n2; ++i) {
            laTeXDocumentPortion2.append((String)((LinkedList)object2).get(i)).nl();
        }
        this.createMeta("title", this.metaData.getTitle(), laTeXDocumentPortion2);
        CSVList cSVList = new CSVList(',');
        ParStyle parStyle = this.wsc.getDefaultParStyle();
        if (parStyle != null) {
            object = parStyle.getProperty("fo:font-size");
            if ("10pt".equals(object)) {
                cSVList.addValue("10pt");
            }
            if ("11pt".equals(object)) {
                cSVList.addValue("11pt");
            }
            if ("12pt".equals(object)) {
                cSVList.addValue("12pt");
            }
        }
        if (this.config.pageFormatting() != 0) {
            cSVList.addValue("twoside");
        }
        if (this.config.getGlobalOptions().length() > 0) {
            cSVList.addValue(this.config.getGlobalOptions());
        }
        object = this.texDoc.getContents();
        if (!this.config.noPreamble()) {
            ((LaTeXDocumentPortion)object).append("% This file was converted to LaTeX by Writer2LaTeX ver. " + Application.getVersion()).nl().append("% see http://www.hj-gym.dk/~hj/writer2latex for more info").nl();
            ((LaTeXDocumentPortion)object).append("\\documentclass");
            if (!cSVList.isEmpty()) {
                ((LaTeXDocumentPortion)object).append("[").append(cSVList.toString()).append("]");
            }
            ((LaTeXDocumentPortion)object).append("{").append(this.config.getDocumentclass()).append("}").nl();
            ((LaTeXDocumentPortion)object).append(laTeXDocumentPortion).append(laTeXDocumentPortion2).append("\\begin{document}").nl();
        }
        ((LaTeXDocumentPortion)object).append(laTeXDocumentPortion3);
        if (!this.config.noPreamble()) {
            ((LaTeXDocumentPortion)object).append("\\end{document}").nl();
        }
        this.convertData.addDocument((Document)this.texDoc);
        if (this.indexCv.getBibTeXDocument() != null) {
            this.convertData.addDocument((Document)this.indexCv.getBibTeXDocument());
        }
        return this.convertData;
    }

    private void createMeta(String string, String string2, LaTeXDocumentPortion laTeXDocumentPortion) {
        if (string2 == null) {
            return;
        }
        laTeXDocumentPortion.append("\\" + string + "{" + this.i18n.convert(string2, false, this.mainContext.getLang()) + "}").nl();
    }

    private void prepass(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string2 = node2.getNodeName();
                if (string2.equals("text:footnote-ref")) {
                    string = Misc.getAttribute(node2, "text:ref-name");
                    if (string != null) {
                        this.noteCv.addFootnoteName(string);
                    }
                } else if (string2.equals("text:endnote-ref")) {
                    string = Misc.getAttribute(node2, "text:ref-name");
                    if (string != null) {
                        this.noteCv.addEndnoteName(string);
                    }
                } else if (string2.equals("text:sequence-ref")) {
                    string = Misc.getAttribute(node2, "text:ref-name");
                    if (string != null) {
                        this.fieldCv.addSequenceName(string);
                    }
                } else if (string2.equals("text:bookmark-ref")) {
                    string = Misc.getAttribute(node2, "text:ref-name");
                    if (string != null) {
                        this.fieldCv.addBookmarkName(string);
                    }
                } else if (string2.equals("text:a") && (string = Misc.getAttribute(node2, "xlink:href")) != null && string.startsWith("#")) {
                    this.fieldCv.addTargetName(string.substring(1));
                }
                this.prepass(node2);
            }
        }
    }
}

