;; Loaded while creating/installing Mule.
;; Copyright (C) 1992 Free Software Foundation, Inc.
;; This file is part of Mule (MULtilingual Enhancement of GNU Emacs).

;; Mule is free software distributed in the form of patches to GNU Emacs.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; Mule is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; 92.3.16  created for Mule Ver.0.9.0 by K.Handa <handa@etl.go.jp>
;;; 92.4.6   modified for Mule Ver.0.9.3 by K.Handa <handa@etl.go.jp>
;;;	Files to be byte-compiled are supplied by command line args.
;;;	Load .el file instead of .elc file if it is patched.
;;; 92.7.27  modified for Mule Ver.0.9.5 by K.Handa <handa@etl.go.jp>
;;;	purify-flag is set to nil.
;;; 92.11.22 modified for Mule Ver.0.9.7 by K.Handa <handa@etl.go.jp>
;;;	Original mule-bytecomp.el and dump-charsets (in mult-util.el)
;;;	is merged into this file.
;;; 93.2.11  modified for Mule Ver.0.9.7.1 by S.Tatsukawa <tatsu_s@ch.hp.com>
;;;	version.el is loaded for bytecompe 2.05.

;; Byte compile all files which are patched or created for Mule

(defun load-necessary-files ()
  (message "Loading necessary files for byte-compile...")
  (load "byte-run")
  (load "subr")
  (load "version")
  (load "custom")
  (garbage-collect)
  (setq purify-flag nil)
  ;; deocde-format should be defined before relace `load'.  it uses
  ;; insert-file-contents.
  (load "international/mule")
  (load "international/mule-conf.el") ;Don't get confused if someone compiled this by mistake.
  (load "format")
  (load "emacs-lisp/backquote")
  (load "bindings")
  (load "emacs-lisp/cl")
  (load "simple")
  (load "help")
  (load "files")
  ;; minibuffer-local-isearch-map is needed to byte-compile x-win.el.
  ;(load "isearch")
  (garbage-collect)
  ;; Info-default-directory-list is needed to byte-compile informat.el
  (load "paths.el")  ;Don't get confused if someone compiled paths by mistake.
  ;; text-mode-map is needed to byte-compile informat.el
  (load "textmodes/text-mode")
  (load "derived")
  (load "replace.el")
  (load "emacs-lisp/lisp" nil)
  (load "textmodes/page" nil)
  (load "textmodes/paragraphs" nil)
  (load "emacs-lisp/lisp-mode" nil)
  (load "emacs-lisp/cl-macs" nil)
  (load "emacs-lisp/bytecomp.el" nil)
  (load "emacs-lisp/byte-opt" nil)
  (load "international/mule-cmds")
  (load "language/english")
  (load "language/european")
  (setq load-source-file-function 'load-with-code-conversion)
  (let ((coding-system-for-read 'iso-2022-7bit))
    (load "language/japanese.el")
    (load "language/japan-util.el"))
  (set-language-environment 'japanese)
  ;; the following 2 files are needed to byte-compile isearch-ext.el.
  (load "timer")
  (load "frame")
  (garbage-collect)
  )

;(setq purify-flag nil)

(let ((args command-line-args)
      (command-line-args-left nil))
  (while (and args (null (string-match "mule-inst" (car args))))
    (setq args (cdr args)))
  (setq args (cdr args))
  (while args
    (let ((el (car args)) elc)
      (if (string-match "\\.elc$" el)
	  (setq elc el el (substring el 0 -1))
	(if (string-match "quail/.*\\.el$" el)
	    (setq elc (concat el "c"))))
      (if (and elc (file-newer-than-file-p el elc))
	  (progn
	    ;;(if (and (file-exists-p elc) (file-writable-p elc))
	    ;; Removing this in advance is safer if ELC is a link.
	    ;;(delete-file elc))
	    (setq command-line-args-left
		  (cons el command-line-args-left)))))
    (setq args (cdr args)))
  (if (null command-line-args-left)
      (kill-emacs 0)
    (load-necessary-files)
    (setq command-line-args-left (nreverse command-line-args-left))
    (let ((byte-compile-warnings nil))
      (batch-byte-compile))))
