# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.06
#
# Package: 
#   jvim-2.1a-i386-1.tgz
#
# Files:
#   ftp://ftp.ring.gr.jp/pub/linux/Vine/Vine-2.5/SRPMS/SRPMS/jvim-3.0j2.1a-0vl4.src.rpm
#
# Patches:
#   ftp://ftp.ring.gr.jp/pub/linux/Vine/Vine-2.5/SRPMS/SRPMS/jvim-3.0j2.1a-0vl4.src.rpm
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
#!/bin/sh
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=jvim
VERSION=2.1a
PKGROOT=`pwd`

#
tar -zxvf vim-3.0.tar.gz
cd vim
tar -zxvf ../jvim.2.1a.tar.gz
patch -p0 < jvim.diff
patch -p1 < ../jvim-3.0j2.1.kanjifix.patch

#make
cd src
cp ../../makjunix.mak Makefile
make
make install

#makepkg
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/bin
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv /usr/local/bin/jvim              ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/bin
mv /usr/share/man/man1/vim.1        ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/man/man1
mv /usr/share/doc/jvim-2.1a/vim.hlp ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/.exrc             ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/README            ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/readme.1st        ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/readme3.0         ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/termcap           ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/todo              ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/vim/uganda.txt        ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp -R ${PKGROOT}/vim/tutor          ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp -R ${PKGROOT}/vim/tools          ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp -R ${PKGROOT}/vim/doc            ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp -R ${PKGROOT}/vim/doc.j          ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/doinst.sh             ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

