#!/bin/sh
#
# Slackware Add-on package Project
#
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.06
#
# Package: 
#   kterm-6.2.0-i386-1.tgz
#
# Files:
#   ftp://ftp.x.org/contrib/applications/kterm-6.2.0.tar.gz
#
# Patches:
#   Original.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=kterm
VERSION=6.2.0
PKGROOT=`pwd`
tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
cd ${PACKAGE}-${VERSION}
patch -p1 < ../kterm.patch

#make
xmkmf -a
make
make install

#makepkg
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/bin
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/app-defaults
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/man/man1
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/man/ja/man1x
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv /usr/X11R6/bin/kterm ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/bin
mv /usr/X11R6/lib/X11/app-defaults/KTerm ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/app-defaults
cp ./kterm.man  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/man/man1
cp ./kterm.jman ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/man/ja/man1x
cp ./README.kt  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/kterm-6.2.0
cp ./DEMO.kt.uu ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/kterm-6.2.0
cp ./DEMO.xbm   ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/kterm-6.2.0
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

