# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.09.16
#
# Package: 
#   tcltk-8.0.5jp.tgz
#
# Files:
#   ftp://ftp.sra.co.jp/pub/lang/tcl/tcl8.0.5.tar.gz
#   ftp://ftp.sra.co.jp/pub/lang/tcl/tk8.0.5.tar.gz
#   ftp://ftp.sra.co.jp/pub/lang/tcl/jp/tcl8.0.5jp1.7.patch.gz
#   ftp://ftp.sra.co.jp/pub/lang/tcl/jp/tk8.0.5jp1.7.patch.gz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
#!/bin/sh
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=tcltk
VERSION=8.0.5jp
PREFIX=/usr/local
PKGROOT=`pwd`
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}
tar -zxvf tcl8.0.5.tar.gz
tar -zxvf tk8.0.5.tar.gz
ln -s tcl8.0.5 tcl8.0.5jp
cd ${PKGROOT}/tcl8.0.5/unix
zcat ../../tcl8.0.5jp1.7.patch.gz | patch -p0
cd ${PKGROOT}/tk8.0.5/unix
zcat ../../tk8.0.5jp1.7.patch.gz | patch -p0

#make
cd ${PKGROOT}/tcl8.0.5/unix
./configure --prefix=${PREFIX} --enable-kanji-filename
make
make install -e prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX} exec_prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}
cd ${PKGROOT}/tk8.0.5/unix
./configure --prefix=${PREFIX} --enable-onTheSpot --with-x
make
make install -e prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX} exec_prefix=${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}

cd ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PREFIX}/bin
ln -s tclsh8.0jp tclsh
ln -s wish8.0jp wish

#makepkg
echo 'Creating package now ...'
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tcl8.0.5
mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tcl8.0.5/README ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tcl8.0.5
cp ${PKGROOT}/tcl8.0.5/unix/Incompat80jp ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tcl8.0.5
cp ${PKGROOT}/tcl8.0.5/unix/README ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tcl8.0.5
cp ${PKGROOT}/tcl8.0.5/unix/README.JP ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tcl8.0.5
cp ${PKGROOT}/tcl8.0.5/unix/changes.JP ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tcl8.0.5
cp ${PKGROOT}/tk8.0.5/README ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tk8.0.5/unix/Incompat80jp ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tk8.0.5/unix/README ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tk8.0.5/unix/README.JP ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tk8.0.5/unix/changes.JP ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tk8.0.5/unix/license.terms ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5
cp ${PKGROOT}/tk8.0.5/unix/porting.notes ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/tk8.0.5

cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

