# button.tcl --
#
# This demonstration script creates a toplevel window containing
# several button widgets.
#
# RCS: @(#) $Id: button.tcl,v 1.1 1999/03/31 15:08:26 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .button
catch {destroy $w}
toplevel $w
wm title $w "Button Demonstration"
wm iconname $w "button"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"If you click on any of the four buttons below, the background of the button area will change to the color indicated in the button.  You can press Tab to move among the buttons, then press Space to invoke the current button." \
"$B%\%?%s$r%/%j%C%/$9$k$H!"%\%?%s$NGX7J?'$,$=$N%\%?%s$K=q$+$l$F$$$k?'$K$J$j$^$9!#%\%?%s$+$i%\%?%s$X$N0\F0$O%?%V$r2!$9$3$H$G$b2DG=$G$9!#$^$?%9%Z!<%9$G<B9T$9$k$3$H$,$G$-$^$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

button $w.b1 -text "Peach Puff" -width 10 \
    -command "$w config -bg PeachPuff1; $w.buttons config -bg PeachPuff1"
button $w.b2 -text "Light Blue" -width 10 \
    -command "$w config -bg LightBlue1; $w.buttons config -bg LightBlue1"
button $w.b3 -text "Sea Green" -width 10 \
    -command "$w config -bg SeaGreen2;  $w.buttons config -bg SeaGreen2"
button $w.b4 -text "Yellow" -width 10 \
    -command "$w config -bg Yellow1;    $w.buttons config -bg Yellow1"
pack $w.b1 $w.b2 $w.b3 $w.b4 -side top -expand yes -pady 2
