# form.tcl --
#
# This demonstration script creates a simple form with a bunch
# of entry widgets.
#
# RCS: @(#) $Id: form.tcl,v 1.1 1999/03/31 15:08:31 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .form
catch {destroy $w}
toplevel $w
wm title $w "Form Demonstration"
wm iconname $w "form"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"This window contains a simple form where you can type in the various entries and use tabs to move circularly between the entries." \
"$B$3$N%&%#%s%I%&$O4JC1$J%U%)!<%`F~NOMQ$K$J$C$F$$$F!"$5$^$6$^$J%(%s%H%j$KF~NO$,$G$-$^$9!#%?%V$G%(%s%H%j$N@ZBX$($,$G$-$^$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

foreach i {f1 f2 f3 f4 f5} {
    frame $w.$i -bd 2
    entry $w.$i.entry -relief sunken -width 40
    label $w.$i.label
    pack $w.$i.entry -side right
    pack $w.$i.label -side left
}
$w.f1.label config -text [langSel Name: $BL>A0(B:]
$w.f2.label config -text [langSel Address: $B=;=j(B:]
$w.f5.label config -text [langSel Phone: $BEEOC(B:]
pack $w.msg $w.f1 $w.f2 $w.f3 $w.f4 $w.f5 -side top -fill x
bind $w <Return> "destroy $w"
focus $w.f1.entry
