
// saphireのソースはUTF8でラインフィールド\nに固定

#include "config.h"
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <glob.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#include <limits.h>

#if defined(__DARWIN__)
#include <sys/syslimits.h>
#endif

#include "saphire.h"
#include "saphire_inner.h"

static void skip_spaces(char** p, string_obj* not_evaled)
{
    while(**p == ' ' || **p == '\t') {
        string_push_back2(not_evaled, **p);
        (*p)++;
    }
}

static BOOL read_until_next_bracket_end(char** p, string_obj* not_evaled, int* read_end_of_statment);
static BOOL read_until_next_paren_end(char** p, string_obj* not_evaled, int* read_end_of_statment);
static BOOL expand_line_field(char* str, string_obj* out);

// {}内を丸ごと取りたい関数。ネストしていてもOK
// 中身はもう一度parseされる
// 環境変数も対応
BOOL read_until_next_cbrace_end(char** p, string_obj* not_evaled, int* read_end_of_statment)
{
    if(**p == '{') {
        string_push_back2(not_evaled, **p);
        (*p)++;

        int nest = 0;
        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        while(1) {
            /// クォート ///
            if(!squote && !dquote && **p == '\\') {
                if(*(*p+1) == 't') {
                    string_push_back(not_evaled, "\\t");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'n') {
                    string_push_back(not_evaled, "\\n");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'r') {
                    string_push_back(not_evaled, "\\r");

                    (*p)+=2;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p != 0) {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                }
            }
            /// シングルクォート ///
            else if(!dquote && **p == '\'') {
                squote = !squote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// ダブルクォート ///
            else if(!squote && **p == '"') {
                dquote = !dquote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// 環境変数かコマンドライン展開
            else if(!squote && **p == '$') {
                // 変数 $
                if(*(*p+1) == '$' 
                            && (*(*p+2) == '{' || is_env_name_char(*(*p+2)))
                         || (*(*p+1) == '{' 
                         || is_env_name_char(*(*p+1))))
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }

                    if(**p == 0) {
                        err_msg("parse: invalid env name");
                        return FALSE;
                    }

                    if(**p == '{') {
                        if(!read_until_next_cbrace_end(p, not_evaled, read_end_of_statment))
                        {
                            return FALSE;
                        }
                    }
                    else {
                        char name[1024];
                        char* p3 = name;
                        while(is_env_name_char(**p)) {
                            *p3++ = **p;
                            (*p)++;
                        }
                        *p3 = 0;

                        string_push_back(not_evaled, name);
                    }

                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }

                        if(**p == '[') {
                            if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment))
                            {
                                return FALSE;
                            }
                        }
                    }
                    if(**p == '<') {
                        if(!read_until_next_ltgt_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    }

                    *read_end_of_statment = 1;
                }

                // コマンド展開 $()
                else if(*(*p+1) == '$' && *(*p+2) == '('
                        || *(*p+1) == '(')
                {
                    if(*(*p+1) == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }
                    
                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    };

                    *read_end_of_statment = 1;
                }

                /// 算術演算 $(())
                else if(*(*p+1) == '(' && *(*p+2) == '(')
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }

                    if(**p != ')') {
                        err_msg("parse: need ) in $(())");

                        return FALSE;
                    }

                    string_push_back2(not_evaled, **p);  // )
                    (*p)++;

                    *read_end_of_statment = 1;
                }
                else {
                    err_msg("invalid env name");
                    return FALSE;
                }
            }
            else if(squote || dquote) {
                if(**p == 0) {
                    err_msg("require ' or \"");
                    return FALSE;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }
            }
            else if(**p == '{') {
                nest++;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            else if(**p == '}') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(nest == 0) {
                    break;
                }
                nest--;
            }
            else if(**p == 0) {
                err_msg("read_util_next_cbrace_end: unexpected end(0). need }");
                return FALSE;
            }
            else {
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
        }
    }
    
    return TRUE;
}

// <>内を丸ごと取りたい関数。ネストしていてもOK
// 中身はもう一度parseされる
// 環境変数も対応
BOOL read_until_next_ltgt_end(char** p, string_obj* not_evaled, int* read_end_of_statment)
{
    if(**p == '<') {
        string_push_back2(not_evaled, **p);
        (*p)++;

        int nest = 0;
        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        while(1) {
            /// クォート ///
            if(!squote && !dquote && **p == '\\') {
                if(*(*p+1) == 't') {
                    string_push_back(not_evaled, "\\t");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'n') {
                    string_push_back(not_evaled, "\\n");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'r') {
                    string_push_back(not_evaled, "\\r");

                    (*p)+=2;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p != 0) {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                }
            }
            /// シングルクォート ///
            else if(!dquote && **p == '\'') {
                squote = !squote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// ダブルクォート ///
            else if(!squote && **p == '"') {
                dquote = !dquote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// 環境変数かコマンドライン展開
            else if(!squote && **p == '$') {
                // 変数 $
                if(*(*p+1) == '$' 
                            && (*(*p+2) == '{' || is_env_name_char(*(*p+2)))
                         || (*(*p+1) == '{' 
                         || is_env_name_char(*(*p+1))))
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }

                    if(**p == 0) {
                        err_msg("parse: invalid env name");
                        return FALSE;
                    }

                    if(**p == '{') {
                        if(!read_until_next_cbrace_end(p, not_evaled, read_end_of_statment))
                        {
                            return FALSE;
                        }
                    }
                    else {
                        char name[1024];
                        char* p3 = name;
                        while(is_env_name_char(**p)) {
                            *p3++ = **p;
                            (*p)++;
                        }
                        *p3 = 0;

                        string_push_back(not_evaled, name);
                    }

                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }

                        if(**p == '[') {
                            if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment))
                            {
                                return FALSE;
                            }
                        }
                    }
                    if(**p == '<') {
                        if(!read_until_next_ltgt_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    }

                    *read_end_of_statment = 1;
                }

                // コマンド展開 $()
                else if(*(*p+1) == '$' && *(*p+2) == '('
                        || *(*p+1) == '(')
                {
                    if(*(*p+1) == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }
                    
                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    };

                    *read_end_of_statment = 1;
                }

                /// 算術演算 $(())
                else if(*(*p+1) == '(' && *(*p+2) == '(')
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }

                    if(**p != ')') {
                        err_msg("parse: need ) in $(())");

                        return FALSE;
                    }

                    string_push_back2(not_evaled, **p);  // )
                    (*p)++;

                    *read_end_of_statment = 1;
                }
                else {
                    err_msg("invalid env name");
                    return FALSE;
                }
            }
            else if(squote || dquote) {
                if(**p == 0) {
                    err_msg("require ' or \"");
                    return FALSE;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }
            }
            else if(**p == '<') {
                nest++;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            else if(**p == '>') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(nest == 0) {
                    break;
                }
                nest--;
            }
            else if(**p == 0) {
                err_msg("read_util_next_cbrace_end: unexpected end(0). need }");
                return FALSE;
            }
            else {
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
        }
    }
    
    return TRUE;
}

// []内を丸ごと取りたい関数。ネストしていて丸ごと取る
// 中身はもう一度parseされる
// 環境変数も対応
static BOOL read_until_next_bracket_end(char** p, string_obj* not_evaled, int* read_end_of_statment)
{
    if(**p == '[') {
        string_push_back2(not_evaled, **p);
        (*p)++;

        int nest = 0;
        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        while(1) {
            /// クォート ///
            if(!squote && !dquote && **p == '\\') {
                if(*(*p+1) == 't') {
                    string_push_back(not_evaled, "\\t");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'n') {
                    string_push_back(not_evaled, "\\n");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'r') {
                    string_push_back(not_evaled, "\\r");

                    (*p)+=2;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p != 0) {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                }
            }
            /// シングルクォート ///
            else if(!dquote && **p == '\'') {
                squote = !squote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// ダブルクォート ///
            else if(!squote && **p == '"') {
                dquote = !dquote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// 環境変数かコマンドライン展開
            else if(!squote && **p == '$') {
                // 変数 $
                if(*(*p+1) == '$' 
                            && (*(*p+2) == '{' || is_env_name_char(*(*p+2)))
                         || (*(*p+1) == '{' 
                         || is_env_name_char(*(*p+1))))
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }

                    if(**p == 0) {
                        err_msg("parse: invalid env name");
                        return FALSE;
                    }

                    if(**p == '{') {
                        if(!read_until_next_cbrace_end(p, not_evaled, read_end_of_statment))
                        {
                            return FALSE;
                        }
                    }
                    else {
                        char name[1024];
                        char* p3 = name;
                        while(is_env_name_char(**p)) {
                            *p3++ = **p;
                            (*p)++;
                        }
                        *p3 = 0;

                        string_push_back(not_evaled, name);
                    }

                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }

                        if(**p == '[') {
                            if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                                return FALSE;
                            }
                        }
                    }
                    if(**p == '<') {
                        if(!read_until_next_ltgt_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    }

                    *read_end_of_statment = 1;
                }

                // コマンド展開 $()
                else if(*(*p+1) == '$' && *(*p+2) == '('
                        || *(*p+1) == '(')
                {
                    if(*(*p+1) == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }
                    
                    if(**p == '[') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    };

                    *read_end_of_statment = 1;
                }

                /// 算術演算 $(())
                else if(*(*p+1) == '(' && *(*p+2) == '(')
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }

                    if(**p != ')') {
                        err_msg("parse: need ) in $(())");

                        return FALSE;
                    }

                    string_push_back2(not_evaled, **p);  // )
                    (*p)++;

                    *read_end_of_statment = 1;
                }
                else {
                    err_msg("invalid env name");
                    return FALSE;
                }
            }
            else if(squote || dquote) {
                if(**p == 0) {
                    err_msg("require ' or \"");
                    return FALSE;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }
            }
            else if(**p == '[') {
                nest++;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            else if(**p == ']') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(nest == 0) {
                    break;
                }
                nest--;
            }
            else if(**p == 0) {
                err_msg("parse skip next bracket: unexpected end(0). need ]");
                return FALSE;
            }
            else {
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
        }
    }
    
    return TRUE;
}

// ()内をまるごと取りたい関数。ネストしていても全部とる
// 読み込みだけ。中身はもう一度パースされる
// 環境変数も対応
static BOOL read_until_next_paren_end(char** p, string_obj* not_evaled, int* read_end_of_statment)
{
    if(**p == '(') {
        string_push_back2(not_evaled, **p);
        (*p)++;

        int nest = 0;
        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        while(1) {
            /// クォート ///
            if(!squote && !dquote && **p == '\\') {
                if(*(*p+1) == 't') {
                    string_push_back(not_evaled, "\\t");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'n') {
                    string_push_back(not_evaled, "\\n");

                    (*p)+=2;
                }
                else if(*(*p+1) == 'r') {
                    string_push_back(not_evaled, "\\r");

                    (*p)+=2;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p != 0) {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                }
            }
            /// シングルクォート ///
            else if(!dquote && **p == '\'') {
                squote = !squote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// ダブルクォート ///
            else if(!squote && **p == '"') {
                dquote = !dquote;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            /// 環境変数かコマンドライン展開
            else if(!squote && **p == '$') {
                // 変数 $
                if(*(*p+1) == '$' 
                            && (*(*p+2) == '{' || is_env_name_char(*(*p+2)))
                         || (*(*p+1) == '{' 
                         || is_env_name_char(*(*p+1))))
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    if(**p == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }

                    if(**p == 0) {
                        err_msg("parse: invalid env name");
                        return FALSE;
                    }

                    if(**p == '{') {
                        if(!read_until_next_cbrace_end(p, not_evaled, read_end_of_statment))
                        {
                            return FALSE;
                        }
                    }
                    else {
                        char name[1024];
                        char* p3 = name;
                        while(is_env_name_char(**p)) {
                            *p3++ = **p;
                            (*p)++;
                        }
                        *p3 = 0;

                        string_push_back(not_evaled, name);
                    }

                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }

                        if(**p == '[') {
                            if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                                return FALSE;
                            }
                        }
                    }
                    if(**p == '<') {
                        if(!read_until_next_ltgt_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    }

                    *read_end_of_statment = 1;
                }

                // コマンド展開 $()
                else if(*(*p+1) == '$' && *(*p+2) == '('
                        || *(*p+1) == '(')
                {
                    if(*(*p+1) == '$') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                    }
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }
                    
                    if(**p == '[') {
                        string_push_back2(not_evaled, **p);
                        (*p)++;
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    };

                    *read_end_of_statment = 1;
                }

                /// 算術演算 $(())
                else if(*(*p+1) == '(' && *(*p+2) == '(')
                {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                    string_push_back2(not_evaled, **p);
                    (*p)++;

                    if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }

                    if(**p != ')') {
                        err_msg("parse: need ) in $(())");

                        return FALSE;
                    }

                    string_push_back2(not_evaled, **p);  // )
                    (*p)++;

                    *read_end_of_statment = 1;
                }
                else {
                    err_msg("invalid env name");
                    return FALSE;
                }
            }
            /// シングルクォート、ダブルクォート中 ///
            else if(squote || dquote) {
                if(**p == 0) {
                    err_msg("require ' or \"");
                    return FALSE;
                }
                else {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }
            }
            else if(**p == '(') {
                nest++;
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
            else if(**p == ')') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(nest == 0) {
                    break;
                }
                nest--;
            }
            else if(**p == 0) {
                err_msg("PArse skip next paren: unexpected end(0). need )");
                return FALSE;
            }
            else {
                string_push_back2(not_evaled, **p);
                (*p)++;
            }
        }
    }
    
    return TRUE;
}

// ブロックを取りたい関数 contentsに入る。
// 中身はもう一回パースされる
// 環境変数は対応しない
static BOOL read_block(char** p, string_obj* contents, string_obj* not_evaled, BOOL line_inc)
{
    string_push_back2(not_evaled, **p);
    (*p)++;
    
    while(1) {
        if(**p == ' ') {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
        }
        else if(**p == '\t') {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
        }
        else if(**p == '\n') {
            line_inc && gLine++;
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
        }
        else {
            break;
        }
    }

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    int nest = 0;
    while(1) {
        /// クォート
        if(!squote && !dquote && **p == '\\') {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
            if(**p == '\n') {
                line_inc && gLine++;
                string_push_back2(not_evaled, **p);
                string_push_back2(contents, *((*p)++));
            }
            else if(*p != 0) {
                string_push_back2(not_evaled, **p);
                string_push_back2(contents, *((*p)++));
            }
        }
        /// シングルクォート
        else if(!dquote && **p == '\'') {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
            squote = !squote;
        }
        /// ダブルクォート
        else if(!squote && **p == '"') {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
            dquote = !dquote;
        }
        /// シングルクォート、ダブルクォート中 ///
        else if(squote || dquote) {
            if(**p == 0) {
                err_msg("get block: require \" or \'");
                return FALSE;
            }
            if(**p == '\n') {
                line_inc && gLine++;
                string_push_back2(not_evaled, **p);
                string_push_back2(contents, *((*p)++));
            }
            else {
                string_push_back2(not_evaled, **p);
                string_push_back2(contents, *((*p)++));
            }
        }
        else if(**p == '{') {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
            nest++;
        }
        else if(**p == '}') {
            string_push_back2(not_evaled, **p);
            (*p)++;
            nest--;

            if(nest == -1) {
                break;
            }
            else {
                string_push_back2(contents, '}');
            }
        }
        else if(**p == 0) {
            err_msg("get block: found 0. require }");
            return FALSE;
        }
        else if(**p == '\n') {
            line_inc && gLine++;
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, **p);
            (*p)++;
        }
        else {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, **p);
            (*p)++;
        }
    }

    return TRUE;
}

// ブロックを取りたい関数 contentsに入る。
// 中身はもう一回パースされる
static BOOL read_indent_block(char** p, string_obj* contents, string_obj* not_evaled)
{
    string_push_back(contents, "{");

    /// ブロック ///
    if(**p != '\n') {
        err_msg("get block: invalid block. require line field");
        return FALSE;
    }
    else {
        gLine++;
        string_push_back2(not_evaled, **p);
        //string_push_back2(contents, **p);
        (*p)++;
    }

    int indent_before = -1;
    while(1) {
        int indent = 0;
        while((**p == ' ' || **p == '\t') 
            && (indent_before == -1
                || (indent_before != -1 && indent < indent_before)))
        {
            string_push_back2(not_evaled, **p);
            (*p)++;
            indent++;
        }

        if(**p == ';' && *(*p+1) == ';') break;

        if(**p != '\n' && indent_before != -1 && indent < indent_before) 
        {
            break;
        }

        if(**p != '\n' && indent_before == -1) indent_before = indent;
        
        while(**p != '\n' && **p != 0) {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
        }

        if(**p == 0) {
            break;
        }

        if(**p == '\n') {
            gLine++;
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
        }
        else {
            string_push_back2(not_evaled, **p);
            string_push_back2(contents, *((*p)++));
        }
    }

    string_push_back(contents, "}");

    return TRUE;
}

// 変数の添え字を取りたい関数 [3]の3や[1..2]の1と2など
BOOL parse_number(char* p, vector_obj* numbers)
{
    char number[256];
    char* p2 = number;
    while(*p) {
        /// 数字 ///
        if(*p>='0' && *p<='9' || *p == '-') {
            *p2++ = *p++;
            while(*p>='0' && *p<='9') {
                *p2++ = *p++;
            }
            *p2 = 0;
            p2 = number;

            if(*p == '.' && *(p+1) == '.') {
                p+=2;

                int number1 = atoi(number);

                if(*p>='0' && *p<='9' || *p == '-') {
                    *p2++ = *p++;
                    while(*p>='0' && *p<='9') {
                        *p2++ = *p++;
                    }
                    *p2 = 0;
                    p2 = number;
                    
                    vector_add(numbers
                        , sIndex_new(number1, atoi(number), 2));
                }
                else {
                    err_msg("invalid range");
                    return FALSE;
                }
            }
            else {
                vector_add(numbers, sIndex_new(atoi(number), -1, 1));
            }
        }
        else if(*p == ',') {
            p++;
        }
        else if(*p == ' ' || *p == '\t') {
            p++;
        }
        else {
            err_msg("invalid range");
            return FALSE;
        }
    }

    return TRUE;
}

static BOOL read_one_argument(char** p, string_obj* buf, string_obj* not_evaled, int* read_end_of_statment, sCommand* command)
{
//puts("read one arguyment");
    /// 単語の区切り記号かどうかのテーブル 127以下なら
    static unsigned char table[] = { 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0 };

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(**p) {
        if(gKitutukiSigInt) {
            gKitutukiSigInt = FALSE;
            err_msg("signal interrupt");

            return FALSE;
        }
        /// 空文字
        if(!squote && !dquote && **p == '"' && *(*p+1) == '"') {
            break;
        }
        else if(!dquote && !squote && **p =='\'' && *(*p+1) == '\'') {
            break;
        }
        else if(**p == '\\' && *(*p+1) == 't') {
            string_push_back2(not_evaled, **p);
            string_push_back2(not_evaled, *(*p+1));

            string_push_back2(buf, '\t');

            (*p)+=2;
        }
        else if(**p == '\\' && *(*p+1) == 'n') {
            string_push_back2(not_evaled, **p);
            string_push_back2(not_evaled, *(*p+1));

            string_push_back2(buf, '\n');

            (*p)+=2;
        }
        else if(**p == '\\' && *(*p+1) == 'r') {
            string_push_back2(not_evaled, **p);
            string_push_back2(not_evaled, *(*p+1));

            string_push_back2(buf, '\r');

            (*p)+=2;
        }
        else if(!squote && !dquote && **p == '\\') {
            string_push_back2(not_evaled, **p);
            (*p)++;

            if(**p == 0) {
                err_msg("unexpected end. can't quote null.");
                return FALSE;
            }
            else if(**p == '\n') {
                gLine++;
            }

            string_push_back2(not_evaled, **p);
            string_push_back2(buf, **p);

            (*p)++;
        }
        else if(!dquote && **p == '\'') {
            string_push_back2(not_evaled, **p);
            (*p)++;
            squote = !squote;
        }
        else if(!squote && **p == '"') {
            dquote = !dquote;
            string_push_back2(not_evaled, **p);
            (*p)++;
        }
        /// 環境変数かコマンドライン展開
        else if(!squote && **p == '$') {
            // 変数 $
            if(*(*p+1) == '$' 
                        && (*(*p+2) == '{' || is_env_name_char(*(*p+2)))
                     || (*(*p+1) == '{' 
                     || is_env_name_char(*(*p+1))))
            {
                string_push_back2(not_evaled, **p);
                (*p)++;
                if(**p == '$') {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }

                if(**p == 0) {
                    err_msg("parse: invalid env name");
                    return FALSE;
                }

                if(**p == '{') {
                    if(!read_until_next_cbrace_end(p, not_evaled, read_end_of_statment))
                    {
                        return FALSE;
                    }
                }
                else {
                    char name[1024];
                    char* p3 = name;
                    while(is_env_name_char(**p)) {
                        *p3++ = **p;
                        (*p)++;
                    }
                    *p3 = 0;

                    string_push_back(not_evaled, name);
                }

                if(**p == '[') {
                    if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }

                    if(**p == '[') {
                        if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                            return FALSE;
                        }
                    }
                }
                if(**p == '<') {
                    if(!read_until_next_ltgt_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }
                }

                *read_end_of_statment = 1;
            }

            // コマンド展開 $()
            else if(*(*p+1) == '$' && *(*p+2) == '('
                    || *(*p+1) == '(')
            {
                if(*(*p+1) == '$') {
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                    return FALSE;
                }
                
                if(**p == '[') {
                    if(!read_until_next_bracket_end(p, not_evaled, read_end_of_statment)) {
                        return FALSE;
                    }
                };

                *read_end_of_statment = 1;
            }

            /// 算術演算 $(())
            else if(*(*p+1) == '(' && *(*p+2) == '(')
            {
                string_push_back2(not_evaled, **p);
                (*p)++;
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                    return FALSE;
                }

                if(**p != ')') {
                    err_msg("parse: need ) in $(())");

                    return FALSE;
                }

                string_push_back2(not_evaled, **p);  // )
                (*p)++;

                *read_end_of_statment = 1;
            }
            else {
                err_msg("invalid env name");
                return FALSE;
            }
        }
        else if(squote || dquote) {
            if(**p == 0) {
                err_msg("close single quote or double quote");
                return FALSE;
            }
            else {
                string_push_back2(not_evaled, **p);
                string_push_back2(buf, **p);

                (*p)++;
            }
        }
        /// グロブ ///
        else if(**p == '*' || command && vector_size(command->mArgTmps) > 0 && **p == '[' || **p == '?') {
            string_push_back2(not_evaled, **p);
            string_push_back2(buf, **p);
            (*p)++;

            if(command) {
                if(!read_one_argument(p, buf, not_evaled, read_end_of_statment, NULL))
                {
                    return FALSE;
                }

                glob_t result;
                int rc = glob(string_c_str(buf), 0, NULL, &result);
                if(rc == GLOB_NOSPACE) {
                    err_msg("read_one_argument: out of space during glob operation");
                    return FALSE;
                }
                else if(rc == GLOB_NOMATCH) {
                }
                else {
                    int i;
                    for(i=0; i<result.gl_pathc; i++) {
                        char* file = result.gl_pathv[i];
                        if(strcmp(file, ".") != 0 && strcmp(file, "..") != 0)
                        {
                            vector_add(command->mArgTmps, sArgTmp_new(0, STRING_NEW(file)));
                        }
                    }

                    string_put(buf, ""); // グロブのパターンはmArgTmpsに追加しない
                }
                break;
            }
        }
        else if(((unsigned char)**p) > 127) {
            string_push_back2(not_evaled, **p);
            string_push_back2(buf, **p);

            (*p)++;
        }
        else if(**p == '{') { // 一文字列目にハッシュの代入があるので例外
            if(command && vector_size(command->mArgTmps) > 0) {
                break;
            }
            else {
                string_push_back2(not_evaled, **p);
                string_push_back2(buf, **p);

                (*p)++;
            }
        }
        else if(**p == '}') { // 一文字列目にハッシュの代入があるので例外
            if(command && vector_size(command->mArgTmps) > 0) {
                break;
            }
            else {
                string_push_back2(not_evaled, **p);
                string_push_back2(buf, **p);

                (*p)++;
            }
        }
        else if(table[**p]) {
            break;
        }
        else {
            string_push_back2(not_evaled, **p);
            string_push_back2(buf, **p);

            (*p)++;
        }
    }

    return TRUE;
}

static BOOL read_command_parse_if_statment(char** p, sCommand* command, sStatment* statment, string_obj* not_evaled, int* read_end_of_statment, char* fname)
{
    skip_spaces(p, not_evaled);

    if(**p != '(') {
        err_msg("expected (");
        return FALSE;
    }

    /// 条件式読み込み ///
    string_obj* str = STRING_NEW("");
    int read_end_of_statment2 = -1;
    if(!read_until_next_paren_end(p, str, &read_end_of_statment2)) {
        string_delete(str);
        return FALSE;
    }
    string_push_back(not_evaled, string_c_str(str));

    string_erase(str, 0, 1);
    string_trunc(str, string_length(str)-1);

    sStatments* condition = STATMENTS_NEW();

    if(!parse(string_c_str(str), fname, condition))
    {
        string_delete(str);
        sStatments_delete(condition);

        return FALSE;
    }

    string_delete(str);

    skip_spaces(p, not_evaled);

    /// 実行文 ///
    sStatments* loop = STATMENTS_NEW();

    if(**p == '{') {
        string_obj* str = STRING_NEW("");
        if(!read_block(p, str, not_evaled, FALSE)) {
            sStatments_delete(condition);
            sStatments_delete(loop);
            string_delete(str);
            return FALSE;
        }


        if(!parse(string_c_str(str), fname, loop))
        {
            string_delete(str);
            sStatments_delete(condition);
            sStatments_delete(loop);
            return FALSE;
        }
        string_delete(str);
    }
    else {
        err_msg("expected block.");
        sStatments_delete(condition);
        sStatments_delete(loop);
        return FALSE;
    }

    

    skip_spaces(p, not_evaled);

    vector_obj* conditions = VECTOR_NEW(30);
    vector_obj* loops = VECTOR_NEW(30);
    
    vector_add(conditions, condition);
    vector_add(loops, loop);

    /// elif 開始 ///
    if(**p == 'e' && *(*p+1) == 'l' 
        && *(*p+2) == 'i' && *(*p+3) == 'f' 
        && (*(*p+4) == ' ' || *(*p+4) == '\t' || *(*p+4) == '('))
    {
        while(**p == 'e' && *(*p+1) == 'l' && *(*p+2) == 'i' 
            && *(*p+3) == 'f' 
            && (*(*p+4) == ' ' || *(*p+4) == '\t' || *(*p+4) == '('))
        {
            string_push_back2(not_evaled, **p);
            string_push_back2(not_evaled, **p);
            string_push_back2(not_evaled, **p);
            string_push_back2(not_evaled, **p);

            (*p)+=4;

            skip_spaces(p, not_evaled);

            if(**p != '(') {
                err_msg("expected (");
                int k;
                for(k=0; k<vector_size(conditions); k++)
                {
                    sStatments_delete(vector_item(conditions, k));
                }
                vector_delete(conditions);

                for(k=0; k<vector_size(loops); k++)
                {
                    sStatments_delete(vector_item(loops, k));
                }
                vector_delete(loops);

                return FALSE;
            }

            /// 条件式 ///
            string_obj* str = STRING_NEW("");
            int read_end_of_statment = -1;
            if(!read_until_next_paren_end(p, str, &read_end_of_statment)) {
                string_delete(str);
                int k;
                for(k=0; k<vector_size(conditions); k++)
                {
                    sStatments_delete(vector_item(conditions, k));
                }
                vector_delete(conditions);

                for(k=0; k<vector_size(loops); k++)
                {
                    sStatments_delete(vector_item(loops, k));
                }
                vector_delete(loops);

                return FALSE;
            }

            sStatments* condition = STATMENTS_NEW();
            if(!parse(string_c_str(str), fname, condition))
            {
                string_delete(str);
                sStatments_delete(condition);
                int k;
                for(k=0; k<vector_size(conditions); k++)
                {
                    sStatments_delete(vector_item(conditions, k));
                }
                vector_delete(conditions);

                for(k=0; k<vector_size(loops); k++)
                {
                    sStatments_delete(vector_item(loops, k));
                }
                vector_delete(loops);

                return FALSE;
            }

            string_delete(str);
            vector_add(conditions, condition);

            skip_spaces(p, not_evaled);

            /// 実行文 ///
            sStatments* loop = STATMENTS_NEW();

            if(**p == '{') {
                string_obj* str = STRING_NEW("");
                if(!read_block(p, str, not_evaled, FALSE)) {
                    string_delete(str);
                    sStatments_delete(loop);
                    int k;
                    for(k=0; k<vector_size(conditions); k++)
                    {
                        sStatments_delete(vector_item(conditions, k));
                    }
                    vector_delete(conditions);

                    for(k=0; k<vector_size(loops); k++)
                    {
                        sStatments_delete(vector_item(loops, k));
                    }
                    vector_delete(loops);

                    return FALSE;
                }

                if(!parse(string_c_str(str), fname, loop))
                {
                    string_delete(str);
                    sStatments_delete(loop);
                    int k;
                    for(k=0; k<vector_size(conditions); k++)
                    {
                        sStatments_delete(vector_item(conditions, k));
                    }
                    vector_delete(conditions);

                    for(k=0; k<vector_size(loops); k++)
                    {
                        sStatments_delete(vector_item(loops, k));
                    }
                    vector_delete(loops);

                    return FALSE;
                }
                string_delete(str);
            }
            else {
                err_msg("expected block.");
                sStatments_delete(loop);
                int k;
                for(k=0; k<vector_size(conditions); k++)
                {
                    sStatments_delete(vector_item(conditions, k));
                }
                vector_delete(conditions);

                for(k=0; k<vector_size(loops); k++)
                {
                    sStatments_delete(vector_item(loops, k));
                }
                vector_delete(loops);

                return FALSE;
            }

            skip_spaces(p, not_evaled);

            vector_add(loops, loop);
        }
    }

    /// else 開始 ///
    if(**p == 'e' && *(*p+1) == 'l' && *(*p+2) == 's' && *(*p+3) == 'e' && (*(*p+4) == ' ' || *(*p+4) == '\t' || *(*p+4) == '('))
    {
        string_push_back2(not_evaled, **p);
        string_push_back2(not_evaled, **p);
        string_push_back2(not_evaled, **p);
        string_push_back2(not_evaled, **p);
        (*p)+=4;

        skip_spaces(p, not_evaled);
        
        /// 実行文 ///
        sStatments* loop = STATMENTS_NEW();

        if(**p == '{') {
            string_obj* str = STRING_NEW("");
            if(!read_block(p, str, not_evaled, FALSE)) {
                string_delete(str);
                sStatments_delete(loop);
                int k;
                for(k=0; k<vector_size(conditions); k++)
                {
                    sStatments_delete(vector_item(conditions, k));
                }
                vector_delete(conditions);

                for(k=0; k<vector_size(loops); k++)
                {
                    sStatments_delete(vector_item(loops, k));
                }
                vector_delete(loops);

                return FALSE;
            }

            if(!parse(string_c_str(str), fname, loop))
            {
                string_delete(str);
                sStatments_delete(loop);
                int k;
                for(k=0; k<vector_size(conditions); k++)
                {
                    sStatments_delete(vector_item(conditions, k));
                }
                vector_delete(conditions);

                for(k=0; k<vector_size(loops); k++)
                {
                    sStatments_delete(vector_item(loops, k));
                }
                vector_delete(loops);

                return FALSE;
            }
            string_delete(str);
        }
        else {
            err_msg("expected block.");
            sStatments_delete(loop);
            int k;
            for(k=0; k<vector_size(conditions); k++)
            {
                sStatments_delete(vector_item(conditions, k));
            }
            vector_delete(conditions);

            for(k=0; k<vector_size(loops); k++)
            {
                sStatments_delete(vector_item(loops, k));
            }
            vector_delete(loops);

            return FALSE;
        }

        skip_spaces(p, not_evaled);

        vector_add(loops, loop);
    }
    
    command->mKind = kIf;
    command->mExtra = sIf_new(conditions, loops);

    return TRUE;
}

static BOOL read_command_parse_while_statment(char** p, sCommand* command, sStatment* statment, string_obj* not_evaled, int* read_end_of_statment, char* fname)
{
    skip_spaces(p, not_evaled);

    if(**p != '(') {
        err_msg("expected (");
        return FALSE;
    }

    /// 条件式読み込み ///
    string_obj* str = STRING_NEW("");
    int read_end_of_statment2 = -1;
    if(!read_until_next_paren_end(p, str, &read_end_of_statment2)) {
        string_delete(str);
        return FALSE;
    }
    string_push_back(not_evaled, string_c_str(str));

    string_erase(str, 0, 1);
    string_trunc(str, string_length(str)-1);

    sStatments* conditions = STATMENTS_NEW();
    if(!parse(string_c_str(str), fname, conditions))
    {
        string_delete(str);
        sStatments_delete(conditions);
        return FALSE;
    }
    string_delete(str);

    while(**p) {
        if(**p == '\n') {
            gLine++;
            string_push_back2(not_evaled, **p);
            (*p)++;
        }
        else if(**p == ' ' || **p == '\t') {
            string_push_back2(not_evaled, **p);
            (*p)++;
        }
        else {
            break;
        }
    }

    /// ループ文読み込み ///
    sStatments* loops = STATMENTS_NEW();

    if(**p == '{') {
        string_obj* str = STRING_NEW("");
        if(!read_block(p, str, not_evaled, FALSE)) {
            sStatments_delete(conditions);
            sStatments_delete(loops);
            string_delete(str);
            return FALSE;
        }

        if(!parse(string_c_str(str), fname, loops))
        {
            string_delete(str);
            sStatments_delete(conditions);
            sStatments_delete(loops);
            return FALSE;
        }
        string_delete(str);
    }
    else {
        err_msg("expected block.");
        sStatments_delete(conditions);
        sStatments_delete(loops);
        return FALSE;
    }

    command->mKind = kWhile;
        // これが無いとmNotEvaledの場合（変数がある場合）
        // 正しくcommandが消されない
    command->mExtra = sWhile_new(conditions, loops);

    return TRUE;
}

static BOOL read_command_parse_def_statment(char** p, sCommand* command, sStatment* statment, string_obj* not_evaled, int* read_end_of_statment, char* fname)
{
    skip_spaces(p, not_evaled);

    /// 関数名を得る ///
    string_obj* name = STRING_NEW("");
    while(**p >= 'a' && **p <= 'z' 
            || **p >= 'A' && **p <= 'Z'
            || **p == '_' 
            || **p >= '0' && **p <= '9')
    {
        string_push_back2(not_evaled, **p);
        string_push_back2(name, **p);
        (*p)++;
    }

    /// 引数名指定 ///
    string_obj* arg_name = STRING_NEW("");
    if(**p == '(') {
        string_push_back2(not_evaled, **p);
        (*p)++;

        skip_spaces(p, not_evaled);

        while(**p >= 'a' && **p <= 'z' 
            || **p >= 'A' && **p <= 'Z'
            || **p == '_' 
            || **p >= '0' && **p <= '9')
        {
            string_push_back2(not_evaled, **p);
            string_push_back2(arg_name, **p);
            (*p)++;
        }

        skip_spaces(p, not_evaled);

        if(**p != ')') {
            err_msg("require )");

            string_delete(name);
            string_delete(arg_name);

            return FALSE;
        }

        string_push_back2(not_evaled, **p);
        (*p)++;
    }

    while(**p) {
        if(**p == '\n') {
            gLine++;
            string_push_back2(not_evaled, **p);
            (*p)++;
        }
        else if(**p == ' ' || **p == '\t') {
            string_push_back2(not_evaled, **p);
            (*p)++;
        }
        else {
            break;
        }
    }

    string_obj* contents = STRING_NEW("");
    if(**p == '{') {
        if(!read_block(p, contents, not_evaled, FALSE)) {
            string_delete(name);
            string_delete(arg_name);
            string_delete(contents);
            return FALSE;
        }
    }
    else {
        err_msg("unexpected token at def statment");
        string_delete(name);
        string_delete(arg_name);
        string_delete(contents);
        return FALSE;
    }

    sStatments* statments = STATMENTS_NEW();

    if(!parse(string_c_str(contents)
            , fname, statments)) 
    {
        string_delete(name);
        string_delete(arg_name);
        string_delete(contents);
        sStatments_delete(statments);

        return FALSE;
    }

    string_delete(contents);

    command->mKind = kDef;
        // これが無いとmNotEvaledの場合（変数がある場合）
        // 正しくcommandが消されない
    command->mExtra = sFunction_new(string_c_str(name), statments, string_c_str(arg_name));

    string_delete(name);
    string_delete(arg_name);

    return TRUE;
}

static BOOL read_command(char** p, sCommand* command, sStatment* statment, string_obj* not_evaled, int* read_end_of_statment, BOOL block_termination, char* fname)
{
    while(**p) {
        string_obj* buf = STRING_NEW("");

        if(!read_one_argument(p, buf, not_evaled, read_end_of_statment, command)) {
            string_delete(buf);
            return FALSE;
        }

        /// コマンドに追加 ///
        if(strcmp(string_c_str(buf), "") != 0) {
            vector_add(command->mArgTmps, sArgTmp_new(0, buf));
            string_push_back(statment->mTitle, string_c_str(buf));
            string_push_back(statment->mTitle, " ");

            if(vector_size(command->mArgTmps) == 1) {
                if(strcmp(string_c_str(buf), "if") == 0) {
                    if(!read_command_parse_if_statment(p, command, statment, not_evaled, read_end_of_statment, fname))
                    {
                        return FALSE;
                    }
                }
                else if(strcmp(string_c_str(buf), "while") == 0) {
                    if(!read_command_parse_while_statment(p, command, statment, not_evaled, read_end_of_statment, fname))
                    {
                        return FALSE;
                    }
                }
                else if(strcmp(string_c_str(buf), "def") == 0) {
                    if(!read_command_parse_def_statment(p, command, statment, not_evaled, read_end_of_statment, fname))
                    {
                        return FALSE;
                    }
                }
            }
        }
        else {
            /// 空文字なら
            if(**p == '\'') {
                string_push_back(not_evaled, "''");
                (*p)+=2;
                vector_add(command->mArgTmps, sArgTmp_new(0, buf));
                string_push_back(statment->mTitle, "'");
                string_push_back(statment->mTitle, " ");

                continue;
            }
            else if(**p == '"') {
                string_push_back(not_evaled, "\"\"");
                (*p)+=2;
                vector_add(command->mArgTmps, sArgTmp_new(0, buf));
                string_push_back(statment->mTitle, "\"\"");
                string_push_back(statment->mTitle, " ");

                continue;
            }
            else {
                string_delete(buf);
            }
        }
        
        /// クィック変数 ///
        if(**p == '@') {
            /// クィックコマンド展開 ///
            if(*(*p+1) == '(') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                string_obj* str = STRING_NEW("");
                if(!read_until_next_paren_end(p, str, read_end_of_statment)) {
                    string_delete(str);
                    return FALSE;
                }
                string_push_back(not_evaled, string_c_str(str));
                string_push_back(statment->mTitle, string_c_str(str));

                string_erase(str, 0, 1);
                string_trunc(str, string_length(str)-1);

                sStatments* statments = STATMENTS_NEW();
                if(!parse(string_c_str(str), "quick command expansion", statments))
                {
                    string_delete(str);
                    sStatments_delete(statments);
                    return FALSE;
                }

                vector_add(command->mArgTmps, sArgTmp_new(3, statments));

                string_delete(str);
            }

            /// クィック変数 ///
            else {
                string_push_back2(not_evaled, **p);
                (*p)++;

                string_obj* var_name = STRING_NEW("");
                while(**p >= 'a' && **p <= 'z' 
                        || **p >= 'A' && **p <= 'Z'
                        || **p == '_' 
                        || **p >= '0' && **p <= '9')
                {
                    string_push_back2(var_name, **p);
                    string_push_back2(not_evaled, **p);
                    (*p)++;
                }

                if(string_c_str(var_name)[0] == 0) {
                    err_msg("invalid quick var");
                    string_delete(var_name);
                    return FALSE;
                }

                string_obj* index = STRING_NEW("");
                if(**p == '[') {
                    if(!read_until_next_bracket_end(p, index, read_end_of_statment))
                    {
                        string_delete(index);
                        string_delete(var_name);
                        return FALSE;
                    }
                    string_push_back(not_evaled, string_c_str(index));

                    string_erase(index, 0, 1);
                    string_trunc(index, string_length(index)-1);
                }

                string_obj* index2 = STRING_NEW("");
                if(**p == '[') {
                    if(!read_until_next_bracket_end(p, index2, read_end_of_statment))
                    {
                        string_delete(index);
                        string_delete(index2);
                        string_delete(var_name);
                        return FALSE;
                    }
                    string_push_back(not_evaled, string_c_str(index2));

                    string_erase(index2, 0, 1);
                    string_trunc(index2, string_length(index2)-1);
                }

                string_obj* delimiter = STRING_NEW("");
                if(**p == '<') {
                    if(!read_until_next_ltgt_end(p, delimiter, read_end_of_statment))
                    {
                        string_delete(var_name);
                        string_delete(delimiter);
                        string_delete(index);
                        string_delete(index2);

                        return FALSE;
                    }

                    string_push_back(not_evaled, string_c_str(delimiter));
                    string_erase(delimiter, 0, 1);
                    string_trunc(delimiter, string_length(delimiter)-1);

                    string_obj* delimiter_ = STRING_NEW("");
                    if(!expand_line_field(string_c_str(delimiter), delimiter_)) {
                        string_delete(var_name);
                        string_delete(delimiter);
                        string_delete(delimiter_);
                        string_delete(index);
                        string_delete(index2);

                        return FALSE;
                    }

                    string_delete(delimiter);
                    delimiter = delimiter_;
                }

                vector_add(command->mArgTmps, sArgTmp_new(1
                    , sVar_new(var_name, index, index2, delimiter)));
            }
        }
        /// リダイレクト・プロセス置換
        else if(**p == '>') {
            /// プロセス置換 ///
            if(*(*p+1) == '(') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                    return FALSE;
                }
                
                *read_end_of_statment = 1;
            }
            else if(*(*p+1) == '>') {
                string_push_back(not_evaled, ">>");
                (*p)+=2;
                int fd = 1;
                enum eRedirect type = kRedirectAppend;
                vector_add(command->mArgTmps
                        , sArgTmp_new(2, sRedirectTmp_new(type, fd)));

                skip_spaces(p, not_evaled);
            }
            else {
                string_push_back(not_evaled, ">");
                (*p)++;
                int fd = 1;
                enum eRedirect type = kRedirectOverwrite;
                vector_add(command->mArgTmps
                        , sArgTmp_new(2, sRedirectTmp_new(type, fd)));

                skip_spaces(p, not_evaled);
            }
        }
        /// リダイレクト・プロセス置換 ///
        else if(**p == '<') {
            /// プロセス置換 ///
            if(*(*p+1) == '(') {
                string_push_back2(not_evaled, **p);
                (*p)++;

                if(!read_until_next_paren_end(p, not_evaled, read_end_of_statment)) {
                    return FALSE;
                }
                
                *read_end_of_statment = 1;
            }
            else if(*(*p+1) == '>') {
                (*p)+=2;

                string_push_back(not_evaled, "read");
                string_push_back(statment->mTitle, "read");

                vector_add(command->mArgTmps, sArgTmp_new(0, STRING_NEW("read")));
            }
            else {
                (*p)++;
                string_push_back(not_evaled, "<");
                int fd = 0;
                enum eRedirect type = kRedirectInput;
                vector_add(command->mArgTmps
                        , sArgTmp_new(2, sRedirectTmp_new(type, fd)));

                skip_spaces(p, not_evaled);
            }
        }
        /// リダイレクト ///
        else if(**p == '%') {
            if(*(*p+1) == '>' && *(*p+2) == '>') {
                string_push_back(not_evaled, "%>>");
                break;
            }
            else if(*(*p+1) == '2' && *(*p+2) == '>' && *(*p+3) == '>') 
            {
                string_push_back(not_evaled, "%2>>");
                (*p)+=4;
                int fd = 2;
                enum eRedirect type = kRedirectAppend;
                vector_add(command->mArgTmps
                        , sArgTmp_new(2, sRedirectTmp_new(type, fd)));

                skip_spaces(p, not_evaled);
            }
            else if(*(*p+1) == '2' && *(*p+2) == '>') {
                string_push_back(not_evaled, "%2>");
                (*p)+=3;
                int fd = 2;
                enum eRedirect type = kRedirectOverwrite;
                vector_add(command->mArgTmps
                        , sArgTmp_new(2, sRedirectTmp_new(type, fd)));

                skip_spaces(p, not_evaled);
            }
            else if(*(*p+1) == '>') {
                string_push_back(not_evaled, "%>");
                (*p)+=2;

                int fd = 0;
                enum eRedirect type = kRedirectErrAndOutput;
                vector_add(command->mArgTmps
                        , sArgTmp_new(2, sRedirectTmp_new(type, fd)));

                skip_spaces(p, not_evaled);
            }
            else {
                err_msg("unexpected token1");
                return FALSE;
            }
        }
        /// 空白 ///
        else if(**p == ' ' || **p == '\t') {
            skip_spaces(p, not_evaled);
        }
        /// サブシェル ///
        else if(**p == '(') {
            if(vector_size(command->mArgTmps) == 0) {
                string_obj* str = STRING_NEW("");
                int read_end_of_statment = -1;
                if(!read_until_next_paren_end(p, str, &read_end_of_statment)) {
                    string_delete(str);
                    return FALSE;
                }
                string_push_back(not_evaled, string_c_str(str));
                string_push_back(statment->mTitle, string_c_str(str));

                string_erase(str, 0, 1);
                string_trunc(str, string_length(str)-1);

                sStatments* statments = STATMENTS_NEW();
                if(!parse(string_c_str(str), "subshell", statments))
                {
                    string_delete(str);
                    sStatments_delete(statments);
                    return FALSE;
                }

                command->mKind= kSubshell;
                vector_add(command->mArgTmps, sArgTmp_new(0, STRING_NEW("subshell")));
                command->mExtra = sSubshell_new(statments);

                string_delete(str);
            }
            else {
                err_msg("unexpected token2");
                return FALSE;
            }
        }
        /// ブロック ///
        else if(**p == '{') {
            if(vector_size(command->mArgTmps) == 0) {
                string_obj* str = STRING_NEW("");
                if(!read_block(p, str, not_evaled, FALSE)) {
                    string_delete(str);
                    return FALSE;
                }

                string_push_back(statment->mTitle, string_c_str(str));

                command->mKind= kSubshell;
                vector_add(command->mArgTmps, sArgTmp_new(0, STRING_NEW("subshell")));

                sStatments* statments = STATMENTS_NEW();
                if(!parse(string_c_str(str), "subshell", statments))
                {
                    sStatments_delete(statments);
                    string_delete(str);
                    return FALSE;
                }
                command->mExtra = sSubshell_new(statments);

                string_delete(str);

                if(block_termination) {
                    (*p)--;  // バックトレース! }に戻す
                    break;
                }
            }
            else {
                string_obj* str = STRING_NEW("{");
                if(!read_block(p, str, not_evaled, TRUE)) {
                    string_delete(str);
                    return FALSE;
                }
                string_push_back(str, "}");

                vector_add(command->mArgTmps, sArgTmp_new(0, str));

                string_push_back(statment->mTitle, string_c_str(str));
                string_push_back(statment->mTitle, " ");

                skip_spaces(p, not_evaled);
            }
        }
        else {
            break;
        }
    }

    return TRUE;
}

static BOOL read_statment(char**p, sStatment* statment, string_obj* not_evaled, int* read_end_of_statment, BOOL block_termination, char* fname)
{
//puts("read_statment");
    while(**p == ' ' || **p == '\t' || **p == '\n' && gLine++) 
    {
        string_push_back2(not_evaled, *((*p)++));
    }

    /// 反転 ///
    if(**p == '!') {
        string_push_back2(not_evaled, '!');
        (*p)++;
        statment->mRCodeReverse = TRUE;

        skip_spaces(p, not_evaled);
    }

    /// グローバルパイプ ///
    if(**p == '|' && *(*p+1) != '|') {
        string_push_back2(not_evaled, **p);
        (*p)++;

        statment->mGlobalPipeIn = TRUE;

        skip_spaces(p, not_evaled);
    }

    while(**p) {
        sCommand* command = COMMAND_NEW();

        if(!read_command(p, command, statment, not_evaled, read_end_of_statment, block_termination, fname)) 
        {
            sCommand_delete(command);
            return FALSE;
        }

        /// 文に追加 ///
        if(*read_end_of_statment == -1 
            && vector_size((command)->mArgTmps) > 0) 
        {
            /// mArgTmps --> mArgsの変換とリダイレクトをmRedirectsに展開 ///
            /// コマンド名が!かチェック
            int k;
            for(k=0; k<vector_size(command->mArgTmps); k++) {
                sArgTmp* arg = vector_item(command->mArgTmps, k);

                // 普通の文字列の引数
                if(arg->mKind == 0) {
                    if(vector_size(statment->mCommands) == 0 && strcmp(string_c_str(arg->mBody), "!") == 0 && k==0) 
                    {
                        statment->mRCodeReverse = TRUE;
                    }
                    else {
                        vector_add(command->mArgs
                            , sArg_new(0, STRING_NEW(string_c_str(arg->mBody))));
                    }
                }
                /// 変数
                else if(arg->mKind == 1) {
                    vector_add(command->mArgs, sArg_new(1, arg->mBody));
                    arg->mBody = NULL; // FREEされないように
                }
                // リダイレクトの引数
                else if(arg->mKind == 2) {
                    sRedirectTmp* redirect2 = arg->mBody;

                    if(redirect2->mType == kRedirectErrAndOutput) {
                        vector_add(command->mRedirects
                            , sRedirect_new(kRedirectErrAndOutput, 0, ""));
                    }
                    else {
                        if(k+1 >= vector_size(command->mArgTmps)) {
                            err_msg("invalid redirect file name");
                            sCommand_delete(command);
                            return FALSE;
                        }
                        sArgTmp* next_arg = vector_item(command->mArgTmps, k+1);
                        if(next_arg->mKind != 0) {
                            err_msg("invalid redirect file name");
                            sCommand_delete(command);
                            return FALSE;
                        }
                        vector_add(command->mRedirects
                            , sRedirect_new(redirect2->mType
                                , redirect2->mFd
                                        , string_c_str(next_arg->mBody)));
                        k++;
                    }
                }
                else {
                    vector_add(command->mArgs, sArg_new(2, arg->mBody));
                    arg->mBody = NULL; // FREEされないように
                }
            }

            /// コマンド名からコマンド種別を得る ///
            sArg* arg = vector_item(command->mArgs, 0);
            if(arg->mKind == 0) {
                command->mKind = get_command_kind(string_c_str(arg->mBody));
            }
            else {
err_msg("invalid command name");
sCommand_delete(command);
return FALSE;
            }

            vector_add(statment->mCommands, command);
        }
        else {
            sCommand_delete(command);
        }

        if(**p == '|' && *(*p+1) != '|') {
            string_push_back(not_evaled, "|");
            (*p)++;

            skip_spaces(p, not_evaled);

            /// 次が文の区切りならグローバルパイプ
            if(**p == '&' && *(*p+1) == '&' 
                || **p == '|' && *(*p+1) == '|'
                || **p == '&'
                || **p == '\n'
                || **p == ';'
                || **p == ':'
                || **p == 0)
            {
                statment->mGlobalPipeOut = TRUE;
                break;
            }
        }
        else {
            break;
        }
    }

    return TRUE;
}

BOOL parse(char* cmdline, char* fname, sStatments* statments)
{
//printf("fname %s\n", fname);
//printf("cmdline (%s)\n", cmdline);
    char* p = cmdline;

    while(*p) {
        sStatment* statment = STATMENT_NEW();
        string_obj* not_evaled = STRING_NEW("");
        int read_end_of_statment = -1;
            // このフラグに行番号が入っていたら環境変数
            // かコマンドライン展開があったので行末まで読み込む

        if(!read_statment(&p, statment, not_evaled
            , &read_end_of_statment, FALSE, fname))
        {
            sStatment_delete(statment);
            string_delete(not_evaled);
            return FALSE;
        }
        else if(*p == '&' && *(p+1) == '&') {
            string_push_back(not_evaled, "&&");
            p+=2;
            statment->mTerminated = kTAndAnd;
            statment->mLine = gLine;
            string_put(statment->mFName, fname);

            skip_spaces(&p, not_evaled);
        }
        else if(*p == '|' && *(p+1) == '|') {
            string_push_back(not_evaled, "||");
            p+=2;

            statment->mTerminated = kTOrOr;
            statment->mLine = gLine;
            string_put(statment->mFName, fname);

            skip_spaces(&p, not_evaled);
        }
        else if(*p == '&')
        {
            string_push_back2(not_evaled, '&');
            p++;

            statment->mBackground = TRUE;
            statment->mTerminated = kTNormal;
            statment->mLine = gLine;
            string_put(statment->mFName, fname);

            skip_spaces(&p, not_evaled);
        }
        else if(*p == '\n') {
            statment->mTerminated = kTNormal;
            statment->mLine = gLine;
            string_put(statment->mFName, fname);

            gLine++;

            string_push_back2(not_evaled, '\n');
            p++;
            skip_spaces(&p, not_evaled);
        }
        else if(*p == ';') {
            statment->mTerminated = kTNormal;
            statment->mLine = gLine;
            string_put(statment->mFName, fname);

            string_push_back2(not_evaled, ';');
            p++;
            skip_spaces(&p, not_evaled);
        }
        else if(*p == 0) {
            statment->mTerminated = kTNormal;
            statment->mLine = gLine;
            string_put(statment->mFName, fname);
        }
        else {
            printf("(%c)\n", *p);
            err_msg("unexpected token3");
            sStatment_delete(statment);
            string_delete(not_evaled);
            return FALSE;
        }

        if(read_end_of_statment != -1) {
            statment->mNotEvaled = not_evaled;
        }
        else {
            string_delete(not_evaled);
        }

        if(vector_size(statment->mCommands) > 0 
            || statment->mNotEvaled != NULL) 
        {
            vector_add(statments->mStatments, statment);
        }
        else {
            sStatment_delete(statment);
        }
    }

    return TRUE;
}

sIndex* sIndex_new(int num, int num2, int num_num)
{
    sIndex* self = MALLOC(sizeof(sIndex));

    self->number = num;
    self->number2 = num2;
    self->number_num = num_num;

    return self;
}

void sIndex_delete(sIndex* self)
{
    FREE(self);
}

static BOOL expand_line_field(char* str, string_obj* out)
{
    char* p = str;
    while(*p) {
        if(gKitutukiSigInt) {
            gKitutukiSigInt = FALSE;
            err_msg("signal interrupt");
            return FALSE;
        }
        if(*p == '\\') {
            p++;
            if(*p == 'n') {
                string_push_back2(out, '\n');
            }
            else if(*p == 'r') {
                string_push_back2(out, '\r');
            }
            else if(*p == 't') {
                string_push_back2(out, '\t');
            }
            else {
                string_push_back2(out, *p++);
            }
        }
        else {
            string_push_back2(out, *p++);
        }
    }

    return TRUE;
}

// 文字列をクォートして返す
BOOL expand_env_get_quoted_str(char* fname, string_obj* quoted_fname)
{
    char* p = fname;
    while(*p) {
        if(gKitutukiSigInt) {
            gKitutukiSigInt = FALSE;
            err_msg("signal interrupt");
            return FALSE;
        }
        if(*p == '\n') {
            string_push_back(quoted_fname, "\\n");
            p++;
        }
        else if(*p == '\r') {
            string_push_back(quoted_fname, "\\r");
            p++;
        }
        else if(*p == '\t') {
            string_push_back(quoted_fname, "\\t");
            p++;
        }
        else if(*p==' ' || *p=='*' || *p=='>' || *p=='&' || *p=='~'
                || *p=='#' || *p =='$' || *p=='(' || *p==')'
                || *p=='\\' || *p=='|' || *p=='[' || *p==']' || *p=='{' 
                || *p=='}' || *p==';'
                || *p=='\'' || *p=='"' || *p=='<' || *p=='>' || *p=='?' 
                || *p=='%' || *p=='@')
        {
            string_push_back2(quoted_fname, '\\');
            string_push_back2(quoted_fname, *p++);
        }
        else {
            string_push_back2(quoted_fname, *p++);
        }
    }

    return TRUE;
}

// 添え字を元にコマンドラインに実際に変数を展開したい関数(クォートする)
static BOOL expand_env_expand_env_quoted(string_obj* cmdline2, char* env, vector_obj* numbers)
{
    /// 添え字なし ///
    if(vector_size(numbers) == 0)
    {
        string_obj* env2 = STRING_NEW("");
        if(!expand_env_get_quoted_str(env, env2)) {
            string_delete(env2);
            return FALSE;
        }
        string_push_back(cmdline2, string_c_str(env2));
        string_delete(env2);
    }
    /// 添え字あり ///
    else {
        int i;
        for(i=0; i<vector_size(numbers); i++) {
            sIndex* index = vector_item(numbers, i);

            /// 添え字がふたつ ///
            if(index->number_num == 2) {
                int n = index->number;
                int n2 = index->number2;

                if(n < 0) {
                    n = str_kanjilen(gKanjiCode, env) + n;
                }

                if(n2 < 0) {
                    n2 = str_kanjilen(gKanjiCode, env) + n2;
                }

                if(n< 0) { n = 0; }
                if(n>=str_kanjilen(gKanjiCode, env)) {
                    n = str_kanjilen(gKanjiCode, env) -1;
                }

                if(n2< 0) { n2 = 0; }
                if(n2>=str_kanjilen(gKanjiCode, env)) {
                    n2 = str_kanjilen(gKanjiCode, env) -1;
                }

                if(n <= n2)
                {
                    char* p1 = str_kanjipos2pointer(gKanjiCode, env, n);
                    char* p2 = str_kanjipos2pointer(gKanjiCode, env, n2+1);

                    char* buf = MALLOC(p2-p1+1);
                    memcpy(buf, p1, p2-p1);
                    buf[p2-p1] = 0;
           
                    string_obj* str2 = STRING_NEW("");
                    if(!expand_env_get_quoted_str(buf, str2)) {
                        string_delete(str2);
                        return FALSE;
                    }
                    string_push_back(cmdline2, string_c_str(str2));
                    string_delete(str2);

                    FREE(buf);
                }
                else {
                    err_msg("expand env: invalid [] range");
                    return FALSE;
                }
            }
            /// 添え字が一つ ///
            else {
                int n = index->number;

                if(n < 0) {
                    n = str_kanjilen(gKanjiCode, env) + n;
                }

                if(n< 0) { n = 0; }
                if(n>=str_kanjilen(gKanjiCode, env)) {
                    n = str_kanjilen(gKanjiCode, env) -1;
                }

                char str[MB_CUR_MAX+1];
                char* p1 = str_kanjipos2pointer(gKanjiCode, env, n);
                char* p2 = str_kanjipos2pointer(gKanjiCode, env, n + 1);

                memcpy(str, p1, p2-p1);
                str[p2-p1] = 0;

                string_obj* str2 = STRING_NEW("");
                if(!expand_env_get_quoted_str(str, str2))  {
                    string_delete(str2);
                    return FALSE;
                }
                string_push_back(cmdline2, string_c_str(str2));
                string_delete(str2);
            }
        }
    }

    return TRUE;
}

// 添え字を元に変数をコマンドラインに展開したい関数(クォートしない)
static BOOL expand_env_expand_env(string_obj* cmdline2, char* env, vector_obj* numbers)
{
    if(vector_size(numbers) == 0)
    {
        string_obj* env3 = STRING_NEW("");
        get_quoted_linefield(env, env3);
        string_push_back(cmdline2, string_c_str(env3));
        string_delete(env3);
    }
    else {
        int i;
        for(i=0; i<vector_size(numbers); i++) {
            sIndex* index = vector_item(numbers, i);

            if(index->number_num == 2) {
                int n = index->number;
                int n2 = index->number2;

                if(n < 0) {
                    n = str_kanjilen(gKanjiCode, env) + n;
                }

                if(n2 < 0) {
                    n2 = str_kanjilen(gKanjiCode, env) + n2;
                }

                if(n< 0) { n = 0; }
                if(n>=str_kanjilen(gKanjiCode, env)) {
                    n = str_kanjilen(gKanjiCode, env) -1;
                }
                if(n2< 0) { n2 = 0; }
                if(n2>=str_kanjilen(gKanjiCode, env)) {
                    n2 = str_kanjilen(gKanjiCode, env) -1;
                }

                if(n <= n2) {
                    char* p1 = str_kanjipos2pointer(gKanjiCode, env, n);
                    char* p2 = str_kanjipos2pointer(gKanjiCode, env, n2+1);

                    char* buf = MALLOC(p2-p1+1);
                    memcpy(buf, p1, p2-p1);
                    buf[p2-p1] = 0;
            
                    string_obj* env3 = STRING_NEW("");
                    get_quoted_linefield(buf, env3);
                    string_push_back(cmdline2, string_c_str(env3));
                    string_delete(env3);

                    FREE(buf);
                }
                else {
                    err_msg("expand_env: invalid [] range");
                    return FALSE;
                }
            }
            else {
                int n = index->number;

                if(n < 0) {
                    n = str_kanjilen(gKanjiCode, env) + n;
                }

                if(n< 0) { n = 0; }
                if(n>=str_kanjilen(gKanjiCode, env)) {
                    n = str_kanjilen(gKanjiCode, env) -1;
                }

                char str[MB_CUR_MAX+1];
                char* p1 = str_kanjipos2pointer(gKanjiCode, env, n);
                char* p2 = str_kanjipos2pointer(gKanjiCode, env, n + 1);

                memcpy(str, p1, p2-p1);
                str[p2-p1] = 0;

                string_obj* env3 = STRING_NEW("");
                get_quoted_linefield(str, env3);
                string_push_back(cmdline2, string_c_str(env3));
                string_delete(env3);
            }
        }
    }

    return TRUE;
}

BOOL expand_env_main(char** p, string_obj* out)
{
    BOOL quote;

    if(*(*p+1) == '$') {
        (*p)+=2;
        quote = FALSE;
    }
    else {
        (*p)++;
        quote = TRUE;
    }

    string_obj* name = STRING_NEW("");
    if(**p == '{') {
        int read_end_of_statment = -1;
        if(!read_until_next_cbrace_end(p, name, &read_end_of_statment)) {
            string_delete(name);
            return FALSE;
        }

        string_erase(name, 0, 1);
        string_trunc(name, string_length(name)-1);

        if(read_end_of_statment != -1) {
            string_obj* name2 = STRING_NEW("");
            if(!expand_env(string_c_str(name), name2)) {
                string_delete(name);
                string_delete(name2);
                return FALSE;
            }

            string_delete(name);
            name = name2;
        }
    }
    else {
        while(is_env_name_char(**p)) {
            string_push_back2(name, **p);
            (*p)++;
        }
    }

    string_obj* index = STRING_NEW("");
    if(**p == '[') {
        int read_end_of_statment = -1;
        if(!read_until_next_bracket_end(p, index, &read_end_of_statment))
        {
            string_delete(name);
            string_delete(index);
            return FALSE;
        }

        string_erase(index, 0, 1);
        string_trunc(index, string_length(index)-1);
        
        if(read_end_of_statment != -1) {
            string_obj* index_ = STRING_NEW("");
            if(!expand_env(string_c_str(index), index_)) {
                string_delete(index);
                string_delete(index_);
                string_delete(name);
                return FALSE;
            }

            string_delete(index);
            index = index_;
        }
    }

    string_obj* index2 = STRING_NEW("");
    if(**p == '[') {
        int read_end_of_statment = -1;
        if(!read_until_next_bracket_end(p, index2, &read_end_of_statment))
        {
            string_delete(name);
            string_delete(index);
            string_delete(index2);
            return FALSE;
        }

        string_erase(index2, 0, 1);
        string_trunc(index2, string_length(index2)-1);
        
        if(read_end_of_statment != -1) {
            string_obj* index2_ = STRING_NEW("");
            if(!expand_env(string_c_str(index2), index2_)) {
                string_delete(index);
                string_delete(index2);
                string_delete(index2_);
                string_delete(name);
                return FALSE;
            }

            string_delete(index2);
            index2 = index2_;
        }
    }

    string_obj* delimiter = STRING_NEW("");
    if(**p == '<') {
        int read_end_of_statment = -1;
        if(!read_until_next_ltgt_end(p, delimiter, &read_end_of_statment))
        {
            string_delete(name);
            string_delete(delimiter);
            string_delete(index);
            string_delete(index2);
            return FALSE;
        }

        string_erase(delimiter, 0, 1);
        string_trunc(delimiter, string_length(delimiter)-1);

        if(read_end_of_statment != -1) {
            string_obj* delimiter2 = STRING_NEW("");
            if(!expand_env(string_c_str(delimiter), delimiter2)) {
                string_delete(name);
                string_delete(delimiter);
                string_delete(delimiter2);
                string_delete(index);
                string_delete(index2);
                return FALSE;
            }

            string_delete(delimiter);
            delimiter = delimiter2;
        }
    }

    if(strcmp(string_c_str(delimiter), "") == 0) {
        string_put(delimiter, "\\n");
    }

    /// ローカル変数を参照
    string_obj* var;
    if(vector_size(gStackFrame) == 0) {
        /// グローバル変数を参照 ///
        var = hash_item(gGlobals, string_c_str(name));
    }
    else {
        /// ローカル変数を参照 ///
        hash_obj* top_stack
             = vector_item(gStackFrame, vector_size(gStackFrame)-1);
        var = hash_item(top_stack, string_c_str(name));
        /// グローバル変数を参照 ///
        if(var == NULL) {
            var = hash_item(gGlobals, string_c_str(name));
        }
    }

    /// グローバル変数かローカル変数 //
    if(var) {
        vector_obj* numbers = VECTOR_NEW(10);
        if(!parse_number(string_c_str(index), numbers)) {
            string_delete(name);
            string_delete(delimiter);
            string_delete(index);
            string_delete(index2);
            int k;
            for(k=0; k<vector_size(numbers); k++) {
                sIndex_delete(vector_item(numbers, k));
            }
            vector_delete(numbers);
            return FALSE;
        }

        if(quote) {
            if(!expand_env_expand_env_quoted(out, string_c_str(var), numbers))
            {
                string_delete(name);
                string_delete(delimiter);
                string_delete(index);
                string_delete(index2);
                int k;
                for(k=0; k<vector_size(numbers); k++) {
                    sIndex_delete(vector_item(numbers, k));
                }
                vector_delete(numbers);
                return FALSE;
            }
        }
        else {
            if(!expand_env_expand_env(out, string_c_str(var) , numbers)) {
                string_delete(name);
                string_delete(delimiter);
                string_delete(index);
                string_delete(index2);
                int k;
                for(k=0; k<vector_size(numbers); k++) {
                    sIndex_delete(vector_item(numbers, k));
                }
                vector_delete(numbers);
                return FALSE;
            }
        }

        int k;
        for(k=0; k<vector_size(numbers); k++) {
            sIndex_delete(vector_item(numbers, k));
        }
        vector_delete(numbers);
    }
    else {
        /// 環境変数を参照 ///
        char* env = getenv(string_c_str(name));

        if(env) {
            vector_obj* numbers = VECTOR_NEW(10);
            if(!parse_number(string_c_str(index), numbers)) {
                string_delete(name);
                string_delete(delimiter);
                string_delete(index);
                string_delete(index2);
                int k;
                for(k=0; k<vector_size(numbers); k++) {
                    sIndex_delete(vector_item(numbers, k));
                }
                vector_delete(numbers);
                return FALSE;
            }

            if(quote) {
                if(!expand_env_expand_env_quoted(out, env, numbers)) {
                    string_delete(name);
                    string_delete(delimiter);
                    string_delete(index);
                    string_delete(index2);
                    int k;
                    for(k=0; k<vector_size(numbers); k++) {
                        sIndex_delete(vector_item(numbers, k));
                    }
                    vector_delete(numbers);
                    return FALSE;
                }
            }
            else {
                if(!expand_env_expand_env(out, env, numbers))
                {
                    string_delete(name);
                    string_delete(delimiter);
                    string_delete(index);
                    string_delete(index2);
                    int k;
                    for(k=0; k<vector_size(numbers); k++) {
                        sIndex_delete(vector_item(numbers, k));
                    }
                    vector_delete(numbers);
                    return FALSE;
                }
            }

            int k;
            for(k=0; k<vector_size(numbers); k++) {
                sIndex_delete(vector_item(numbers, k));
            }
            vector_delete(numbers);
        }
        else {
            vector_obj* array = hash_item(gArrays, string_c_str(name));

            /// 配列 ///
            if(array) {
                vector_obj* numbers = VECTOR_NEW(10);
                if(!parse_number(string_c_str(index), numbers)) {
                    string_delete(name);
                    string_delete(delimiter);
                    string_delete(index);
                    string_delete(index2);
                    int k;
                    for(k=0; k<vector_size(numbers); k++) {
                        sIndex_delete(vector_item(numbers, k));
                    }
                    vector_delete(numbers);
                    return FALSE;
                }

                vector_obj* numbers2 = VECTOR_NEW(10);
                if(!parse_number(string_c_str(index2), numbers2)) {
                    string_delete(name);
                    string_delete(delimiter);
                    string_delete(index);
                    string_delete(index2);
                    int k;
                    for(k=0; k<vector_size(numbers); k++) {
                        sIndex_delete(vector_item(numbers, k));
                    }
                    vector_delete(numbers);
                    for(k=0; k<vector_size(numbers2); k++) {
                        sIndex_delete(vector_item(numbers2, k));
                    }
                    vector_delete(numbers2);
                    return FALSE;
                }

                /// 添え字なし ///
                if(vector_size(numbers) == 0) {
                    if(quote) {
                        int k;
                        for(k=0; k<vector_size(array); k++) {
                            string_obj* str = vector_item(array, k);
                            string_obj* str2 = STRING_NEW("");
                            if(!expand_env_get_quoted_str(string_c_str(str), str2)) {
                                string_delete(str2);
                                string_delete(name);
                                string_delete(delimiter);
                                string_delete(index);
                                string_delete(index2);
                                int k;
                                for(k=0; k<vector_size(numbers); k++) {
                                    sIndex_delete(vector_item(numbers, k));
                                }
                                vector_delete(numbers);
                                for(k=0; k<vector_size(numbers2); k++) {
                                    sIndex_delete(vector_item(numbers2, k));
                                }
                                vector_delete(numbers2);
                                return FALSE;
                            }
                            string_push_back(out, string_c_str(str2));
                            if(k<vector_size(array)-1)
                                string_push_back(out
                                    , string_c_str(delimiter));

                            string_delete(str2);
                        }
                    }
                    else {
                        int k;
                        for(k=0; k<vector_size(array); k++) {
                            string_obj* str = vector_item(array, k);
                            if(str == NULL) {
                                err_msg("expand_env: invalid array range");
                                string_delete(name);
                                string_delete(delimiter);
                                string_delete(index);
                                string_delete(index2);
                                int k;
                                for(k=0; k<vector_size(numbers); k++) {
                                    sIndex_delete(vector_item(numbers, k));
                                }
                                vector_delete(numbers);
                                for(k=0; k<vector_size(numbers2); k++) {
                                    sIndex_delete(vector_item(numbers2, k));
                                }
                                vector_delete(numbers2);
                                return FALSE;
                            }

                            string_obj* str2 = STRING_NEW("");
                            get_quoted_linefield(string_c_str(str)
                                    , str2);
                            string_push_back(out, string_c_str(str2));
                            string_delete(str2);

                            if(k<vector_size(array)-1)
                                string_push_back(out
                                        , string_c_str(delimiter));
                        }
                    }
                }
                /// 添え字あり ///
                else {
                    int i;
                    for(i=0; i<vector_size(numbers); i++) {
                        sIndex* index_ = vector_item(numbers, i);

                        if(index_->number_num == 1) { // 添え字が一つ
                            int n = index_->number;

                            if(n < 0) {
                                n = vector_size(array) + n;
                            }

                            if(n >= 0 && n < vector_size(array)) {
                                string_obj* str 
                                    = vector_item(array, n);
                                BOOL ret;
                                if(quote) {
                                    ret = !expand_env_expand_env_quoted
                                        (out, string_c_str(str)
                                            , numbers2);
                                }
                                else {
                                    ret = !expand_env_expand_env
                                        (out, string_c_str(str)
                                            , numbers2);
                                }


                                if(ret) {
                                    string_delete(name);
                                    string_delete(delimiter);
                                    string_delete(index);
                                    string_delete(index2);
                                    int k;
                                    for(k=0; k<vector_size(numbers); k++) {
                                        sIndex_delete(vector_item(numbers, k));
                                    }
                                    vector_delete(numbers);
                                    for(k=0; k<vector_size(numbers2); k++) {
                                        sIndex_delete(vector_item(numbers2, k));
                                    }
                                    vector_delete(numbers2);
                                    return FALSE;
                                }
                            }
                        }
                        else { // 添え字が範囲
                            int n = index_->number;
                            int m = index_->number2;

                            if(n < 0) n = vector_size(array) + n;
                            if(m < 0) m = vector_size(array) + m;

                            if(n >= vector_size(array)) n = vector_size(array)-1;
                            if(m >= vector_size(array)) m = vector_size(array)-1;

                            if(n < 0) n = 0;
                            if(m < 0) m = 0;

                            if(quote) {
                                if(n < m) {
                                    int k;
                                    for(k=n; k<=m; k++) {
                                        string_obj* str = vector_item(array, k);

                                        if(!expand_env_expand_env_quoted
                                            (out, string_c_str(str), numbers2))
                                        {
                                            string_delete(name);
                                            string_delete(delimiter);
                                            string_delete(index);
                                            string_delete(index2);
                                            int k;
                                            for(k=0; k<vector_size(numbers); k++) {
                                                sIndex_delete(vector_item(numbers, k));
                                            }
                                            vector_delete(numbers);
                                            for(k=0; k<vector_size(numbers2); k++) {
                                                sIndex_delete(vector_item(numbers2, k));
                                            }
                                            vector_delete(numbers2);

                                            return FALSE;
                                        }

                                        if(k<=m-1) 
                                            string_push_back(out
                                               , string_c_str(delimiter));

                                    }
                                }
                                else {
                                    int k;
                                    for(k=n; k>=m; k--) {
                                        string_obj* str = vector_item(array, k);

                                        if(!expand_env_expand_env_quoted
                                            (out, string_c_str(str), numbers2))
                                        {
                                            string_delete(name);
                                            string_delete(delimiter);
                                            string_delete(index);
                                            string_delete(index2);
                                            int k;
                                            for(k=0; k<vector_size(numbers); k++) {
                                                sIndex_delete(vector_item(numbers, k));
                                            }
                                            vector_delete(numbers);
                                            for(k=0; k<vector_size(numbers2); k++) {
                                                sIndex_delete(vector_item(numbers2, k));
                                            }
                                            vector_delete(numbers2);

                                            return FALSE;
                                        }

                                        if(k>m) 
                                            string_push_back(out
                                               , string_c_str(delimiter));

                                    }
                                }
                            }
                            else {
                                if(n < m) {
                                    int k;
                                    for(k=n; k<=m; k++) {
                                        string_obj* str = vector_item(array, k);

                                        if(!expand_env_expand_env
                                            (out, string_c_str(str), numbers2))
                                        {
                                            string_delete(name);
                                            string_delete(delimiter);
                                            string_delete(index);
                                            string_delete(index2);
                                            int k;
                                            for(k=0; k<vector_size(numbers); k++) {
                                                sIndex_delete(vector_item(numbers, k));
                                            }
                                            vector_delete(numbers);
                                            for(k=0; k<vector_size(numbers2); k++) {
                                                sIndex_delete(vector_item(numbers2, k));
                                            }
                                            vector_delete(numbers2);
                                            return FALSE;
                                        }

                                        if(k<=m-1) 
                                          string_push_back(out
                                                        , string_c_str(delimiter));
                                    }
                                }
                                else {
                                    int k;
                                    for(k=n; k>=m; k--) {
                                        string_obj* str = vector_item(array, k);

                                        if(!expand_env_expand_env
                                            (out, string_c_str(str), numbers2))
                                        {
                                            string_delete(name);
                                            string_delete(delimiter);
                                            string_delete(index);
                                            string_delete(index2);
                                            int k;
                                            for(k=0; k<vector_size(numbers); k++) {
                                                sIndex_delete(vector_item(numbers, k));
                                            }
                                            vector_delete(numbers);
                                            for(k=0; k<vector_size(numbers2); k++) {
                                                sIndex_delete(vector_item(numbers2, k));
                                            }
                                            vector_delete(numbers2);
                                            return FALSE;
                                        }

                                        if(k>m)
                                          string_push_back(out
                                                        , string_c_str(delimiter));
                                    }
                                }
                            }
                        }

                        if(i!=vector_size(numbers)-1)
                            string_push_back(out
                                , string_c_str(delimiter));
                    }
                }

                int k;
                for(k=0; k<vector_size(numbers); k++) {
                    sIndex_delete(vector_item(numbers, k));
                }
                vector_delete(numbers);

                for(k=0; k<vector_size(numbers2); k++) {
                    sIndex_delete(vector_item(numbers2, k));
                }
                vector_delete(numbers2);
            }
            else {
                /// [ 演算子 ///
                hash_obj* hash = hash_item(gHashs, string_c_str(name));

                /// ハッシュ ///
                if(hash) {
                    if(strcmp(string_c_str(index), "") == 0) {
                        if(quote) {
                            hash_it* it = hash_loop_begin(hash);
                            int k = 0;
                            while(it != NULL) {
                                string_obj* str = hash_loop_item(it);
                                char* key = hash_loop_key(it);

                                string_obj* str2 = STRING_NEW("");
                                if(!expand_env_get_quoted_str(key, str2)) {
                                    string_delete(str2);
                                    string_delete(name);
                                    string_delete(delimiter);
                                    string_delete(index);
                                    string_delete(index2);
                                    return FALSE;
                                }
                                string_push_back(out, string_c_str(str2));
                                string_delete(str2);

                                string_push_back(out, string_c_str(delimiter));

                                string_obj* str3 = STRING_NEW("");
                                if(!expand_env_get_quoted_str(string_c_str(str), str3)) {
                                    string_delete(str3);
                                    string_delete(name);
                                    string_delete(delimiter);
                                    string_delete(index);
                                    string_delete(index2);
                                    return FALSE;
                                }
                                string_push_back(out, string_c_str(str3));
                                string_delete(str3);

                                if(k < hash_count(hash)-1)
                                    string_push_back
                                        (out, string_c_str(delimiter));

                                it = hash_loop_next(it);
                                k++;
                            }
                        }
                        else {
                            hash_it* it = hash_loop_begin(hash);
                            int k = 0;
                            while(it != NULL) {
                                string_obj* str = hash_loop_item(it);
                                string_obj* str2 = STRING_NEW("");
                                get_quoted_linefield(string_c_str(str), str2);
                                string_push_back(out, string_c_str(str2));
                                if(k < hash_count(hash)-1)
                                    string_push_back
                                        (out, string_c_str(delimiter));

                                string_delete(str2);

                                it = hash_loop_next(it);
                                k++;
                            }
                        }
                    }
                    else {
                        vector_obj* numbers = VECTOR_NEW(10);
                        if(!parse_number(string_c_str(index2), numbers)) {
                            string_delete(name);
                            string_delete(delimiter);
                            string_delete(index);
                            string_delete(index2);
                            int k;
                            for(k=0; k<vector_size(numbers); k++) {
                                sIndex_delete(vector_item(numbers, k));
                            }
                            vector_delete(numbers);
                            return FALSE;
                        }

                        string_obj* str = hash_item(hash, string_c_str(index));

                        if(str) {
                            if(quote) {
                                if(!expand_env_expand_env_quoted(out
                                            , string_c_str(str)
                                            , numbers))
                                {
                                    string_delete(name);
                                    string_delete(delimiter);
                                    string_delete(index);
                                    string_delete(index2);
                                    int k;
                                    for(k=0; k<vector_size(numbers); k++) {
                                        sIndex_delete(vector_item(numbers, k));
                                    }
                                    vector_delete(numbers);
                                    return FALSE;
                                }
                            }
                            else {
                                if(!expand_env_expand_env(out
                                    , string_c_str(str)
                                    , numbers))
                                {
                                    string_delete(name);
                                    string_delete(delimiter);
                                    string_delete(index);
                                    string_delete(index2);
                                    int k;
                                    for(k=0; k<vector_size(numbers); k++) {
                                        sIndex_delete(vector_item(numbers, k));
                                    }
                                    vector_delete(numbers);
                                    return FALSE;
                                }
                            }
                        }

                        int k;
                        for(k=0; k<vector_size(numbers); k++) {
                            sIndex_delete(vector_item(numbers, k));
                        }
                        vector_delete(numbers);
                    }
                }
            }
        }
    }

    string_delete(name);
    string_delete(delimiter);
    string_delete(index);
    string_delete(index2);

    return TRUE;
}

BOOL expand_env(char* p, string_obj* out)
{
    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    vector_obj* psub_statments = VECTOR_NEW(10);

    while(*p) {
        if(gKitutukiSigInt) {
            err_msg("signal interrupt");
            gKitutukiSigInt = FALSE;
            int i;
            for(i=0; i<vector_size(psub_statments); i++) {
                string_delete(vector_item(psub_statments, i));
            }
            vector_delete(psub_statments);
            return FALSE;
        }

        /// クォート ///
        if(!squote && !dquote && *p == '\\') {
            string_push_back2(out, *p++);
            if(*p != 0) {
                string_push_back2(out, *p++);
            }
        }
        /// シングルクォート ///
        else if(!dquote && *p == '\'') {
            squote = !squote;
            string_push_back2(out, *p++);
        }
        /// ダブルクォート ///
        else if(!squote && *p == '"') {
            dquote = !dquote;
            string_push_back2(out, *p++);
        }
        /// 変数
        else if(!squote && *p == '$') {
            if((*(p+1) == '$' 
                    && (*(p+2) == '{' || is_env_name_char(*(p+2)))
                    || (*(p+1) == '{' || is_env_name_char(*(p+1)))
                ))
            {
                if(!expand_env_main(&p, out)) {
                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);

                    return FALSE;
                }
            }
            /// 算術演算
            else if(*(p+1) == '(' && *(p+2) == '(') {
                p+=2;

                string_obj* str = STRING_NEW("");
                int read_end_of_statment = -1;
                if(!read_until_next_paren_end(&p, str, &read_end_of_statment)) 
                {
                    string_delete(str);
                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);
                    return FALSE;
                }

                if(*p != ')') {
                    err_msg("expand_env: need ) in $(())");
                    string_delete(str);
                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);
                    return FALSE;
                }

                p++;

                string_erase(str, 0,1);
                string_trunc(str, string_length(str)-1);
                
                string_insert(str, 0, " calc \"");
                string_push_back(str, "\"");

                string_obj* ret = STRING_NEW("");
                char fname[128];
                snprintf(fname, 128, "%s %d: expand command", string_c_str(gFName), gLine);
                if(saphire_shell3(ret, string_c_str(str), fname) == -1) {
                    string_delete(ret);
                    string_delete(str);
                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);
                    return FALSE;
                }

                string_push_back(out, string_c_str(ret));

                string_delete(ret);
                string_delete(str);
            }
            /// コマンド置換 $( ///
            else if(*(p+1) == '$' && *(p+2) == '(' || *(p+1) == '(')
            {
                BOOL quote;
                if(*(p+1) == '$') {
                    p+=2;
                    quote = FALSE;
                }
                else {
                    p++;
                    quote = TRUE;
                }

                string_obj* str = STRING_NEW("");
                int read_end_of_statment = -1;
                if(!read_until_next_paren_end(&p, str
                    , &read_end_of_statment)) 
                {
                    string_delete(str);
                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);
                    return FALSE;
                }

                string_erase(str, 0, 1); // (をとる
                string_trunc(str, string_length(str)-1); // )をとる

                string_obj* ret = STRING_NEW("");
                char* fname = MALLOC(string_length(gFName) + 256);
                snprintf(fname, string_length(gFName) + 256, "%s %d: expand command", string_c_str(gFName), gLine);
                int rcode = saphire_shell3(ret, string_c_str(str), fname);
                FREE(fname);

                if(rcode < 0) {
                    string_delete(str);
                    string_delete(ret);

                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);
                    return FALSE;
                }

                /// [ 演算子 ///
                string_obj* index = STRING_NEW("");
                if(*p == '[') {
                    int read_end_of_statment = -1;
                    if(!read_until_next_bracket_end(&p, index, &read_end_of_statment))
                    {
                        string_delete(str);
                        string_delete(ret);

                        int i;
                        for(i=0; i<vector_size(psub_statments); i++) {
                            string_delete(vector_item(psub_statments, i));
                        }
                        vector_delete(psub_statments);
                        string_delete(index);
                        return FALSE;
                    }

                    string_erase(index, 0, 1);
                    string_trunc(index, string_length(index)-1);

                    if(read_end_of_statment != -1) {
                        string_obj* index_ = STRING_NEW("");
                        if(!expand_env(string_c_str(index), index_)) {
                            string_delete(str);
                            string_delete(ret);

                            int i;
                            for(i=0; i<vector_size(psub_statments); i++) {
                                string_delete(vector_item(psub_statments, i));
                            }
                            vector_delete(psub_statments);
                            string_delete(index);
                            string_delete(index_);
                            return FALSE;
                        }

                        string_delete(index);
                        index = index_;
                    }
                }

                vector_obj* numbers = VECTOR_NEW(10);

                if(!parse_number(string_c_str(index), numbers)) {
                    string_delete(str);
                    string_delete(ret);
                    string_delete(index);

                    int k;
                    for(k=0; k<vector_size(numbers); k++) {
                        sIndex_delete(vector_item(numbers, k));
                    }
                    vector_delete(numbers);
                    int i;
                    for(i=0; i<vector_size(psub_statments); i++) {
                        string_delete(vector_item(psub_statments, i));
                    }
                    vector_delete(psub_statments);
                    return FALSE;
                }

                if(quote) {
                    if(!expand_env_expand_env_quoted(out
                                , string_c_str(ret)
                                , numbers))
                    {
                        string_delete(ret);
                        string_delete(str);
                        string_delete(index);

                        int k;
                        for(k=0; k<vector_size(numbers); k++) {
                            sIndex_delete(vector_item(numbers, k));
                        }
                        vector_delete(numbers);

                        int i;
                        for(i=0; i<vector_size(psub_statments); i++) {
                            string_delete(vector_item(psub_statments, i));
                        }
                        vector_delete(psub_statments);
                        return FALSE;
                    }
                }
                else {
                    if(!expand_env_expand_env(out, string_c_str(ret)
                                , numbers))
                    {
                        string_delete(ret);
                        string_delete(str);
                        string_delete(index);

                        int k;
                        for(k=0; k<vector_size(numbers); k++) {
                            sIndex_delete(vector_item(numbers, k));
                        }
                        vector_delete(numbers);
                        int i;
                        for(i=0; i<vector_size(psub_statments); i++) {
                            string_delete(vector_item(psub_statments, i));
                        }
                        vector_delete(psub_statments);
                        return FALSE;
                    }
                }

                string_delete(str);
                string_delete(ret);
                int k;
                for(k=0; k<vector_size(numbers); k++) {
                    sIndex_delete(vector_item(numbers, k));
                }
                vector_delete(numbers);

                string_delete(index);

//printf("p (%s)\n", p);
            }
            else {
                err_msg("unexpected token after $");
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
        }
        else if(squote || dquote) {
            if(*p == 0) {
                err_msg("require ' or \"");
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
            else {
                string_push_back2(out, *p++);
            }
        }

        /// プロセス置換 ///
        else if(*p == '<' && *(p+1) == '(') {
            p++;

            string_obj* cmd = STRING_NEW("");
            int read_end_of_statment = -1;
            if(!read_until_next_paren_end(&p, cmd, &read_end_of_statment)) {
                string_delete(cmd);
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
            string_erase(cmd, 0, 1); // (を取る
            string_trunc(cmd, string_length(cmd)-1); // )をとる

            /// 一時ファイルを作る ///
            char fname[PATH_MAX];
            snprintf(fname, PATH_MAX, "%s/kifile%d", gTmpDir, vector_size(gPSubTmpFiles));

            string_push_back(out, fname);
            vector_add(gPSubTmpFiles, STRING_NEW(fname));

            int fd = open(fname, O_WRONLY|O_CREAT, 0600);

            if(fd < 0) { perror("open"); exit(1); }

            /// 実行 ///
            sWFd* pipeout = sWFd_new(fd);
            sRFd* pipein = sRFd_new(STDIN_FILENO);
            char* title = MALLOC(string_length(gFName) + 256);
            snprintf(title, string_length(gFName) + 256, "%s %d: process substitution"
                    , string_c_str(gFName), gLine);
            int rcode = saphire_shell(string_c_str(cmd)
                            , title, pipeout
                            , pipein, STDERR_FILENO);
            FREE(title);
            string_delete(cmd);
            if(!sWFd_close(pipeout)) {
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
            sWFd_delete(pipeout);
            sRFd_delete(pipein);

            if(rcode < 0) {
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
        }

        /// プロセス置換２ ///
        else if(*p == '>' && *(p+1) == '(') {
            p++;

            string_obj* cmd = STRING_NEW("");
            int read_end_of_statment = -1;
            if(!read_until_next_paren_end(&p, cmd, &read_end_of_statment)) {
                string_delete(cmd);
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
            string_erase(cmd, 0, 1);
            string_trunc(cmd, string_length(cmd)-1); // )をとる

            /// 一時ファイルを作る ///
            char fname[PATH_MAX];
            snprintf(fname, PATH_MAX, "%s/kifile%d", gTmpDir, vector_size(gPSubTmpFiles));

            string_push_back(out, fname);
            vector_add(gPSubTmpFiles, STRING_NEW(fname));

            /// 実行 ///
            char buf[PATH_MAX*2];
            snprintf(buf, PATH_MAX*2, "; var __a=$RCODE; cat %s |", fname);
            string_insert(cmd, 0, buf);
            string_push_back(cmd, "; if([ $__a = 0 ]){ true } else { false };");

            vector_add(psub_statments, cmd);
        }
        /// ブロックは飛ばす
        else if(*p == '{') {
            string_obj* dummy = STRING_NEW("");
            if(!read_block(&p, dummy, out, FALSE)) {
                string_delete(dummy);
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
            string_delete(dummy);
        }
        /// サブシェル、条件式は飛ばす
        else if(*p == '(') {
            int read_end_of_statment = -1;
            if(!read_until_next_paren_end(&p, out, &read_end_of_statment))
            {
                int i;
                for(i=0; i<vector_size(psub_statments); i++) {
                    string_delete(vector_item(psub_statments, i));
                }
                vector_delete(psub_statments);
                return FALSE;
            }
        }
        else {
            string_push_back2(out, *p++);
        }
    }

    int i;
    for(i=0; i<vector_size(psub_statments); i++) {
        string_obj* psub_statment = vector_item(psub_statments, i);
        string_push_back(out, string_c_str(psub_statment));
        string_delete(psub_statment);
    }
    vector_delete(psub_statments);

    return TRUE;
}

// コメントも除去する
// 読み込みだけ。この後パースする
BOOL read_expand_brace_expansion(char* p, string_obj* cmdline2, char* separator)
{
    BOOL squote = FALSE;
    BOOL dquote = FALSE;

    while(*p) {
        if(!dquote && !squote && *p == '\\') {
            string_push_back2(cmdline2, *p++);
            string_push_back2(cmdline2, *p++);
        }
        else if(!dquote && *p == '\'') {
            string_push_back2(cmdline2, *p++);
            squote = !squote;
        }
        else if(!squote && *p == '"') {
            string_push_back2(cmdline2, *p++);
            dquote = !dquote;
        }
        else if(squote || dquote) {
            if(*p == 0) {
                err_msg("require \" or \'");
                return FALSE;
            }
            else {
                string_push_back2(cmdline2, *p++);
            }
        }
        /// コメント ///
        else if(*p == '#') {
            p++;

            while(*p) {
                if(*p == '\n') {
                    string_push_back2(cmdline2, '\n');
                    p++;

                    break;
                }
                else {
                    p++; 
                }
            }
        }
        else {
            string_push_back2(cmdline2, *p++);
        }
    }

    return TRUE;
}

// スクリプトファイルを読み込んでコンパイルして
// ファイルとして書き込む関数。
BOOL saphire_compile(char* fname, char* out_fname)
{
    /// 読み込み ///
    string_obj* str = STRING_NEW("");

    int f = open(fname, O_RDONLY);
    if(f < 0) {
        string_delete(str);
        return FALSE;
    }

    char buf[BUFSIZ];
    while(1) {
        int size = read(f, buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            string_delete(str);
            close(f);
            return FALSE;
        }

        buf[size] = 0;

        string_push_back(str, buf);
    }
    close(f);
    
    /// パース ///
    sStatments* statments = STATMENTS_NEW();

    string_put(gFName, fname);
    gLine = 1;

    string_obj* str2 = STRING_NEW("");
    if(!read_expand_brace_expansion(string_c_str(str), str2, " ")) {
        sStatments_delete(statments);
        string_delete(str2);
        string_delete(str);
        return FALSE;
    }

    if(!parse(string_c_str(str2), string_c_str(gFName), statments)) {
        sStatments_delete(statments);
        
        string_delete(str);
        string_delete(str2);
        return FALSE;
    }
    
    string_delete(str);
    string_delete(str2);

    /// コンパイル結果を保存 ///
    int fd = open(out_fname, O_WRONLY|O_TRUNC|O_CREAT, 0644);
    if(write(fd, gMagicNumber, strlen(gMagicNumber)) < 0) {
        perror("write");
        exit(1);
    }

    sStatments_save(statments, fd);

    close(fd);

    sStatments_delete(statments);
    
    return TRUE;
}

// オブジェクトファイル(コンパイルされたファイル)を読み込む関数。
// 実行もする。
// 戻り値が-1ならエラーメッセージがgErrMsgに入っているので出力してください
int saphire_load_obj(char* fname, sWFd* pipeout, sRFd* pipein, int pipeerr)
{
    gKitutukiSigInt = FALSE;
    int fd = open(fname, O_RDONLY);
    if(fd < 0) {
        return -1;
    }
    
    char magic_number[64];
    if(read(fd, magic_number, strlen(gMagicNumber)) < 0) {
        perror("read");
        exit(1);
    }
    magic_number[strlen(gMagicNumber)] = 0;
    
    if(strcmp(magic_number, gMagicNumber) != 0) {
        return -1;
    }
    
    /// オブジェクトファイルをロード ///
    sStatments* statments = sStatments_load(fd);

//sStatments_view(statments);
    
    /// 実行 ///
    string_put(gFName, fname);
    gLine = 1;

    int rcode = run(statments, string_c_str(gFName)
                , pipeout, pipein, pipeerr
                , gAppType == kATOptC, FALSE);

    /// 解放 ///
    close(fd);

    sStatments_delete(statments);

    return rcode;
}

