/*
 * nbVe[uReiCu
 */

#ifndef MINATO_HASH_H
#define MINATO_HASH_H

#include "saphire_extra.h"

#define HASH_KEYSIZE_PER_ONE_IT 5

/* nbVIuWFNg */
typedef struct _hash_it {
   char* mKey;
   
   void* mItem;
   struct _hash_it* mCollisionIt;

   struct _hash_it* mNextIt;
} hash_it;

typedef struct {
   hash_it** mTable;
   int mTableSize;

   hash_it* mEntryIt;

   int mCounter;                // Sp
   int mRefCount;
} hash_obj;

///////////////////////////////////////////////////////////////////////
// ֐錾
///////////////////////////////////////////////////////////////////////

// 
#if defined(MDEBUG)
hash_obj* hash_new_debug(int size, const char* fname, int line, const char* func_name);
#define HASH_NEW(size) hash_new_debug(size, __FILE__, __LINE__, __FUNCTION__)
#else
hash_obj* hash_new(int size);
#define HASH_NEW(size) hash_new(size)
#endif

void hash_delete(hash_obj* self);
void hash_put(hash_obj* self, char* key, void* item);       // 
void hash_erase(hash_obj* self, char* key);                 // 폜
void hash_clear(hash_obj* self);                            // NA
void hash_replace(hash_obj* self, char* key, void* item);   // u

void hash_show(hash_obj* self, char* fname);                // fobOpnbVe[u\

void* hash_item(hash_obj* self, char* key);                 // ̃L[̃ACeԂ
void* hash_item_addr(hash_obj* self, char* key);            // ̃L[̃ACẽAhXԂ
char* hash_key(hash_obj* self, void* item);                 // ̃ACẽL[Ԃ
int hash_count(hash_obj* self);                             // ACe̐Ԃ


// Sp
hash_it* hash_loop_begin(hash_obj* self);
void* hash_loop_item(hash_it* it);
char* hash_loop_key(hash_it* it);
hash_it* hash_loop_next(hash_it* it);

/*
 * S()
 *
 * hash_it* i = hash_loop_begin(hash);
 * while(it) {
 *     void* obj = hash_loop_item(it);
 *
 *     obj̏
 *
 *     it = hash_loop_next(it);
 * }
 *
 */

#endif
