npp("pendulum");         #$B%b%G%k%U%!%$%k$NEPO?$H%W%j%W%m%;%C%5$N5/F0(B
nlink();                                   #$B<B9T%U%!%$%k$N:n@.(B

ntime( 10.0, 0.01, 0.01, 0.01 );           # $B;~4V>r7o$N@_Dj(B
time = ( 0 ~ ( 10.0 / 0.01 )) * 0.01;      # $B;~4V<4%G!<%?(B

series theta;
nout( theta , "PENDULUM" , 0,1 );          # $B30It=PNO>r7o$N@_Dj(B

theta0 = PI/180*10.0;                      # $B=i4|3QEY(B 10$BEY$K@_Dj(B
npara( "PENDULUM" , "theta0" , theta0  );  # $B%Q%i%a!<%?$NJQ99(B

ncal();                                    # $B%7%_%e%l!<%7%g%s$N<B9T(B

phi = PI/180*90;                           # $B2r@O2r$N7W;;(B
m=1.0
l=1.0
gra=9.8
true_theta = theta0 * sin( sqrt( gra / l ) * time + phi ); 
theta = theta / ( PI / 180.0 );            # [rad]$B$+$i(B[deg]$B$KJQ49(B
true_theta = true_theta / ( PI / 180.0 );

wopen( 1 , "A4" , 0 , 1 );                 # $B%0%i%UI=<((B
title( 1 , "time [s]" , " angle [deg]" );
scale( "N" , "F" , "N" , "F" , 0 , 10 , -30 , 30 );
axis( 1 , 1 , "XY" , "XY" , 5 , 0 , 3 , 2 , 15 , 0 );
frame(); 
graph( theta , time , 0 , 1 , 10 , 0 , 2 );
graph( true_theta , time , 0 , 0 , 0 , 0 , 0 );

