#!/bin/sh

SRC_REFERENCE_BASE="SATELLITECommand-j"
DST_REFERENCE_BASE="reference-jp"
FIGS_DIR="BPS DCM GPM ISPP NCS NPE SATELLITE SHELL SYSTEM"

SRC_DVIFILE="${SRC_REFERENCE_BASE}.dvi"
SRC_IDXFILE="${SRC_REFERENCE_BASE}.idx"
DST_DVIFILE="${DST_REFERENCE_BASE}.dvi"
DST_IDXFILE="${DST_REFERENCE_BASE}.idx"

DEBUG=no

if [ `id -u` -ne 0 ]; then
  echo 'error : must be run as root';
  exit 1;
fi

if [ ! -f ${SRC_DVIFILE} ]; then
  echo "error : ${SRC_DVIFILE} not found";
  exit 1;
fi

if [ ! -f ${SRC_IDXFILE} ]; then
  echo "error : ${SRC_IDXFILE} not found";
  exit 1;
fi

if [ $# -ne 1 ]; then
  echo 'error : satellite prefix is not setted'
  exit 1;
fi

if [ ! -d $1 ]; then
  echo 'error : $1 is not directory'
  exit 1;
fi

if [ x"${DEBUG}" = x"yes" ]; then
  ECHO="echo"
else
  ECHO=""
fi

${ECHO} mkdir -p $1/share
${ECHO} mkdir -p $1/share/doc
DOCDIR="$1/share/doc/satellite"
${ECHO} mkdir -p ${DOCDIR}

${ECHO} cp ${SRC_DVIFILE} ${DOCDIR}/${SRC_DVIFILE}
${ECHO} cp ${SRC_IDXFILE} ${DOCDIR}/${SRC_IDXFILE}
${ECHO} ln -s ${DOCDIR}/${SRC_DVIFILE} ${DOCDIR}/${DST_DVIFILE}
${ECHO} ln -s ${DOCDIR}/${SRC_IDXFILE} ${DOCDIR}/${DST_IDXFILE}

for i in ${FIGS_DIR}; do
  SRC_FIGDIR="Fig_${i}"
  DST_FIGDIR="${DOCDIR}/Fig_${i}"

  SRC_CMDIMGDIR="${SRC_FIGDIR}/Command"
  DST_CMDIMGDIR="${DST_FIGDIR}/Command"
  ${ECHO} mkdir -p ${DST_FIGDIR}
  if [ -d ${SRC_CMDIMGDIR} ]; then
    ${ECHO} mkdir -p ${DST_CMDIMGDIR}
    ${ECHO} cp -p ${SRC_CMDIMGDIR}/*.eps ${DST_CMDIMGDIR}/
  fi

#  SRC_MANIMGDIR="${SRC_FIGDIR}/Manual"
#  DST_MANIMGDIR="${DST_FIGDIR}/Manual"
#  if [ -d ${SRC_MANIMGDIR} ]; then
#    ${ECHO} mkdir -p ${DST_MANIMGDIR}
#    ${ECHO} cp -p ${SRC_MANIMGDIR}/* ${DST_MANIMGDIR}/
#  fi
done
