#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <signal.h>
#include <math.h>

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

#define AXIS_Y_WIDTH    70
#define RIGHT_SPACE     10

#include "bmon.h"
#include "bm_resource.h"

data_type Data;
Widget   toplevel, bm_main, frame, button_form, title_form, work_form;
Widget   title, series_name, dec_button, inc_button, buffer_number, set_button;
Widget   pause_button, scale_button, amp_button, power_button, quit_button;
Widget   graph, x_min, x_max, y_min, y_max, y_dummy;
Widget   scale_dialog, scale_form, ok_button, scale_form1, scale_form2;

Widget   label_x, radio_x1, radio_x2, max_x, min_x;
Widget   linear_x, log_x, auto_x, fixed_x;

Widget   label_y, radio_y1, radio_y2, max_y, min_y;
Widget   linear_y, log_y, auto_y, fixed_y;

Widget   textlabel_xmin, textlabel_xmax, textlabel_ymin, textlabel_ymax;
Widget   x_xmin, x_xmax, x_ymin, x_ymax;

Display        *display;
XtAppContext    app_context;



static void scale_button_activate _ANSI_ARGS_((Widget widget,
					       XtPointer client_data,
					       XButtonEvent *event));

static void  first_draw_graph      _ANSI_ARGS_((Widget widget,
						XtPointer client_data,
						XtPointer call_data));
static void  set_on_off_callback   _ANSI_ARGS_((Widget w,
					        XtPointer client_data,
					        XtPointer call_data));
static void  create_scale_dialog   _ANSI_ARGS_((Widget *w, data_type *data));
static void  bm_quit               _ANSI_ARGS_((Widget widget, XtPointer *tag,
						XtPointer *callback_data));
static void  count                 _ANSI_ARGS_((void));
static void  destroy               _ANSI_ARGS_((void));

int
main(argc, argv)
     int    argc;
     char **argv;
{
  Arg       arglist[10];
  int       n;
  char      title_bar[2*NAMELEN];
  char      hostname[NAMELEN];
  char      username[NAMELEN];
  char     *var_name;
  char	   *VarName;
  XmString  value;
  int       pid;

  /* setting for SATELLITE */

  signal(SIGUSR1, (RETSIGTYPE (*)()) destroy);
  signal(SIGUSR2, SIG_IGN);
  signal(SIGINT,  SIG_IGN);

  read_syscom();

  Data.buff_no = GetBufferID(0);
  VarName      = GetString(0);

  if (Data.buff_no < 1)
    exit(2);

  /* Data Store Area Create & Read Buffer Data */

  Data.point = syscom.buff_leng;
  Data.x = NULL;
  Data.y = NULL;
  Data.rec_num = 0;
  Data.rec_max = 1;
  Data.width = 370;
  Data.height = 270;

  gethostname(hostname, NAMELEN );
  getusername(username, NAMELEN );

  strcpy( title_bar, argv[0] );
  strcat( title_bar, "-" );
  strcat( title_bar, username );
  strcat( title_bar, "@" );
  strcat( title_bar, hostname );

  /* X Window Setting */

  XtSetLanguageProc(NULL,NULL,NULL);

  n = 0;
  XtSetArg( arglist[n], XmNallowShellResize, False); n++;
  XtSetArg( arglist[n], XmNtitle, title_bar ); n++; 
  XtSetArg( arglist[n], XmNiconName, title_bar ); n++; 
  toplevel = (Widget)XtAppInitialize(&app_context, "BMON",
				     NULL, 0, 
				     &argc, argv, resources, arglist, n);

  bm_main = XmCreateForm( toplevel, "bm_main", NULL, 0 );
  frame   = XmCreateForm( bm_main,  "frame",   NULL, 0 );

  XtManageChild(frame);

  var_name = strtok( VarName, "),; " );
  value = XmStringCreateLtoR( var_name, XmFONTLIST_DEFAULT_TAG );

  /* children of frame */
  button_form = XmCreateForm( frame, "button_form", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNtopWidget, button_form); n++;
  title_form  = XmCreateForm(frame , "title_form", arglist, n );
  n = 0;
  XtSetArg( arglist[n], XmNtopWidget, title_form); n++;
  work_form   = XmCreateForm(frame , "work_form", arglist, n );
  XtManageChild(button_form);
  XtManageChild(title_form);
  XtManageChild(work_form);

  /* children of button_form */ 
  pause_button = XmCreateToggleButton( button_form, "pause_button", NULL, 0 );
  scale_button = XmCreatePushButton  ( button_form, "scale_button", NULL, 0 );
  amp_button   = XmCreateToggleButton( button_form, "amp_button",   NULL, 0 );
  power_button = XmCreateToggleButton( button_form, "power_button", NULL, 0 );
  quit_button  = XmCreatePushButton  ( button_form, "quit_button",  NULL, 0 );
  XtManageChild(pause_button);
  XtManageChild(scale_button);
  XtManageChild(amp_button);
  XtManageChild(power_button);
  XtManageChild(quit_button);

  /* children of title_form */
  title         = XmCreateLabel( title_form, "title", NULL, 0 );
  set_button    = XmCreateToggleButton( title_form, "set_button", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNrightWidget, set_button ); n++;
  inc_button    = XmCreateArrowButton( title_form, "inc_button", arglist, n );
  n = 0;
  XtSetArg( arglist[n], XmNrightWidget, inc_button ); n++;
  buffer_number = XmCreateLabel( title_form, "buffer_number", arglist, n );
  n = 0;
  XtSetArg( arglist[n], XmNrightWidget, buffer_number ); n++;
  dec_button    = XmCreateArrowButton( title_form, "dec_button", arglist, n );
  n = 0;
  XtSetArg( arglist[n], XmNlabelString, value ); n++;
  XtSetArg( arglist[n], XmNleftWidget, title ); n++;
  XtSetArg( arglist[n], XmNrightWidget, dec_button ); n++;
  series_name   = XmCreateLabel( title_form, "series_name", arglist, n );
  XmStringFree( value );
  XtManageChild(title);	
  XtManageChild(series_name);
  XtManageChild(inc_button);
  XtManageChild(buffer_number);
  XtManageChild(dec_button);
  XtManageChild(set_button);

  /* children of work_form */
  y_dummy = XmCreateLabel( work_form, "y_dummy", NULL, 0 );
  y_max   = XmCreateLabel( work_form, "y_max", NULL, 0 );
  x_max   = XmCreateLabel( work_form, "x_max", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, y_dummy ); n++;
  x_min   = XmCreateLabel( work_form, "x_min", arglist, n );
  n = 0;
  XtSetArg( arglist[n], XmNbottomWidget, x_min ); n++;
  graph   = XmCreateDrawingArea( work_form, "graph", arglist, n );
  n = 0;
  XtSetArg( arglist[n], XmNbottomWidget, y_dummy ); n++;
  y_min   = XmCreateLabel( work_form, "y_min", arglist, n );
  XtManageChild(graph);
  XtManageChild(y_dummy);
  XtManageChild(x_min);
  XtManageChild(x_max);
  XtManageChild(y_min);
  XtManageChild(y_max);

  /* Realize toplevel */

  XtManageChild(bm_main);
  XtRealizeWidget(toplevel);

  /* Initialize Data Structure */

  init_data(&Data);
  read_data(&Data);


  /* Initialize Window Parameter */
  set_no(buffer_number, Data.rec_num);
  init_gc(graph, &Data);

  draw_proc(&Data);

  ResizeCallback(graph, &Data, NULL);

  XFlush(XtDisplay(graph));

  XtAddCallback(scale_button, XmNactivateCallback,
		(XtCallbackProc)scale_button_activate, &Data);
  XtAddCallback(quit_button,  XmNactivateCallback,
		(XtCallbackProc)bm_quit, NULL);

  XtAddCallback(inc_button, XmNactivateCallback,
		(XtCallbackProc)PushUpArrowCallback, &Data);
  XtAddCallback(inc_button, XmNactivateCallback,
		(XtCallbackProc)NumberRedrawCallback, buffer_number);
  XtAddCallback(inc_button, XmNactivateCallback,
		(XtCallbackProc)SetNumberCallback, &Data);

  XtAddCallback(dec_button, XmNactivateCallback,
		(XtCallbackProc)PushDownArrowCallback, &Data);
  XtAddCallback(dec_button, XmNactivateCallback,
		(XtCallbackProc)NumberRedrawCallback, buffer_number);
  XtAddCallback(dec_button, XmNactivateCallback,
		(XtCallbackProc)SetNumberCallback, &Data);

  XtAddCallback(graph, XmNresizeCallback,
		(XtCallbackProc)ResizeCallback, &Data);
  XtAddCallback(graph, XmNexposeCallback,
		(XtCallbackProc)first_draw_graph, NULL);

  XtAddCallback(pause_button, XmNvalueChangedCallback,
		(XtCallbackProc)PauseCallback, &Data);
  XtAddCallback(set_button, XmNvalueChangedCallback,
		(XtCallbackProc)set_on_off_callback, &Data);
  XtAddCallback(set_button, XmNvalueChangedCallback,
		(XtCallbackProc)SetNumberCallback, &Data);

  XtAddCallback(amp_button, XmNvalueChangedCallback,
		(XtCallbackProc)SetAMP, &Data);
  XtAddCallback(amp_button, XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, power_button);
  XtAddCallback(power_button, XmNvalueChangedCallback,
		(XtCallbackProc)SetPOWER, &Data);
  XtAddCallback(power_button, XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, amp_button);

  create_scale_dialog( &scale_dialog, &Data );

  /* Send Signal Handler */
  XtAppAddTimeOut(app_context, INTERVAL,
		  (XtTimerCallbackProc)interval_proc, &Data);
  signal(SIGUSR2, (RETSIGTYPE (*)()) count);

  switch (pid = fork()) {

  case -1:
    perror("Can't create new process.\n");
    exit(0);

  case 0:
    signal(SIGQUIT, (RETSIGTYPE (*)()) destroy);
    signal(SIGKILL, (RETSIGTYPE (*)()) destroy);
    signal(SIGBUS,  (RETSIGTYPE (*)()) destroy);
    signal(SIGHUP,  (RETSIGTYPE (*)()) destroy);
    signal(SIGUSR1, (RETSIGTYPE (*)()) destroy);
    signal(SIGINT, SIG_IGN);
    break;
  default:
    exit(0);
  }

  /* Add Monitor Process PID */

  add_list(Data.buff_no);

  XtAppMainLoop(app_context);
  return 0;
}

static void
scale_button_activate(widget, client_data, event)
     Widget          widget;
     XtPointer       client_data;
     XButtonEvent   *event;
{
  data_type      *data = (data_type *) client_data;

  if (scale_dialog == NULL) {
    create_scale_dialog( &scale_dialog, data );
    XtManageChild(scale_dialog);
  } else {
    if (XtIsManaged(scale_dialog))
      XtUnmanageChild(scale_dialog);
    else
      XtManageChild(scale_dialog);
  }
}

static void
create_scale_dialog( w, data )
     Widget *w;
     data_type *data;
{
  Arg arglist[5];
  int n;

  scale_dialog = XmCreateFormDialog( toplevel, "scale_dialog", NULL, 0 );
  ok_button    = XmCreatePushButton( scale_dialog, "ok_button", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNtopWidget, ok_button ); n++;
  scale_form   = XmCreateForm( scale_dialog, "scale_form", arglist, n );

  /* children of scale_form */
  scale_form1  = XmCreateForm( scale_form, "scale_form1", NULL, 0 );
  scale_form2  = XmCreateForm( scale_form, "scale_form2", NULL, 0 );

  /* children of scale_form1 */
  label_x  = XmCreateLabel( scale_form1, "label_x", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, label_x ); n++;
  radio_x1 = XmCreateForm( scale_form1, "radio_x1", arglist, n );
  radio_x2 = XmCreateForm( scale_form1, "radio_x2", arglist, n );
  max_x    = XmCreateForm( scale_form1, "max_x", arglist, n );
  min_x    = XmCreateForm( scale_form1, "min_x", arglist, n );

  /* children of radio_x1 */
  linear_x = XmCreateToggleButton( radio_x1, "linear_x", NULL, 0 );
  log_x    = XmCreateToggleButton( radio_x1, "log_x", NULL, 0 );

  /* children of radio_x2 */
  auto_x  = XmCreateToggleButton( radio_x2, "auto_x", NULL, 0 );
  fixed_x = XmCreateToggleButton( radio_x2, "fixed_x", NULL, 0 );

  /* children of max_x */
  textlabel_xmax  = XmCreateLabel( max_x, "textlabel_xmax", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, textlabel_xmax ); n++;
  x_xmax = XmCreateTextField( max_x, "x_xmax", arglist, n );
  
  /* children of min_x */
  textlabel_xmin  = XmCreateLabel( min_x, "textlabel_xmin", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, textlabel_xmin ); n++;
  x_xmin = XmCreateTextField( min_x, "x_xmin", arglist, n );

  
  /* children of scale_form2 */
  label_y  = XmCreateLabel( scale_form2, "label_y", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, label_y ); n++;
  radio_y1 = XmCreateForm( scale_form2, "radio_x1", arglist, n );
  radio_y2 = XmCreateForm( scale_form2, "radio_x2", arglist, n );
  max_y    = XmCreateForm( scale_form2, "max_x", arglist, n );
  min_y    = XmCreateForm( scale_form2, "min_x", arglist, n );

  /* children of radio_y1 */
  linear_y = XmCreateToggleButton( radio_y1, "linear_x", NULL, 0 );
  log_y    = XmCreateToggleButton( radio_y1, "log_x", NULL, 0 );

  /* children of radio_y2 */
  auto_y  = XmCreateToggleButton( radio_y2, "auto_x", NULL, 0 );
  fixed_y = XmCreateToggleButton( radio_y2, "fixed_x", NULL, 0 );

  /* children of max_y */
  textlabel_ymax  = XmCreateLabel( max_y, "textlabel_xmax", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, textlabel_ymax ); n++;
  x_ymax = XmCreateTextField( max_y, "x_xmax", arglist, n );
  
  /* children of min_y */
  textlabel_ymin  = XmCreateLabel( min_y, "textlabel_xmin", NULL, 0 );
  n = 0;
  XtSetArg( arglist[n], XmNleftWidget, textlabel_ymin ); n++;
  x_ymin = XmCreateTextField( min_y, "x_xmin", arglist, n );

  XtManageChild(ok_button);
  XtManageChild(scale_form);
  XtManageChild(scale_form1);
  XtManageChild(scale_form2);
  XtManageChild(radio_x1);
  XtManageChild(radio_x2);
  XtManageChild(max_x);
  XtManageChild(min_x);
  XtManageChild(label_x);
  XtManageChild(linear_x);
  XtManageChild(log_x);
  XtManageChild(auto_x);
  XtManageChild(fixed_x);
  XtManageChild(textlabel_xmax);
  XtManageChild(x_xmax);
  XtManageChild(textlabel_xmin);
  XtManageChild(x_xmin);
  XtManageChild(radio_y1);
  XtManageChild(radio_y2);
  XtManageChild(max_y);
  XtManageChild(min_y);
  XtManageChild(label_y);
  XtManageChild(linear_y);
  XtManageChild(log_y);
  XtManageChild(auto_y);
  XtManageChild(fixed_y);
  XtManageChild(textlabel_ymax);
  XtManageChild(x_ymax);
  XtManageChild(textlabel_ymin);
  XtManageChild(x_ymin);

  XtAddCallback(linear_x, XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, log_x);
  XtAddCallback(log_x   , XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, linear_x);
  XtAddCallback(auto_x  , XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, fixed_x);
  XtAddCallback(fixed_x , XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, auto_x);
  
  XtAddCallback(linear_x, XmNvalueChangedCallback,
		(XtCallbackProc)SetLinerCallback, &(data->x_type));
  XtAddCallback(log_x   , XmNvalueChangedCallback,
		(XtCallbackProc)SetLogCallback, &(data->x_type));
  XtAddCallback(auto_x  , XmNvalueChangedCallback,
		(XtCallbackProc)SetAutoCallback, &(data->x_scale));
  XtAddCallback(fixed_x , XmNvalueChangedCallback,
		(XtCallbackProc)SetFixedCallback, &(data->x_scale));
  
  XtAddCallback(linear_y, XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, log_y);
  XtAddCallback(log_y   , XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, linear_y);
  XtAddCallback(auto_y  , XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, fixed_y);
  XtAddCallback(fixed_y , XmNvalueChangedCallback,
		(XtCallbackProc)ChangeDisplayCallback, auto_y);
  
  XtAddCallback(linear_y, XmNvalueChangedCallback,
		(XtCallbackProc)SetLinerCallback, &(data->y_type));
  XtAddCallback(log_y   , XmNvalueChangedCallback,
		(XtCallbackProc)SetLogCallback, &(data->y_type));
  XtAddCallback(auto_y  , XmNvalueChangedCallback,
		(XtCallbackProc)SetAutoCallback, &(data->y_scale));
  XtAddCallback(fixed_y , XmNvalueChangedCallback,
		(XtCallbackProc)SetFixedCallback, &(data->y_scale));
  
  XtAddCallback(ok_button, XmNactivateCallback,
		(XtCallbackProc)PopupQuit, data);
}


static void
bm_quit(widget, tag, callback_data)
     Widget          widget;
     XtPointer       *tag, *callback_data;
{
  destroy();
}

static void
destroy()
{
  del_list(Data.buff_no);
  exit(0);
}

static void
count()
{
  signal(SIGUSR2, SIG_IGN);
  Data.count++;
  signal(SIGUSR2, (RETSIGTYPE (*)()) count);
}

static void
first_draw_graph(widget, client_data, call_data)
     Widget          widget;
     XtPointer       client_data, call_data;
{
  static int      first_flag = 0;
  XSetWindowAttributes atr;

  draw_proc(&Data);

  if (first_flag == 0) {

    atr.backing_store = Always;

    XChangeWindowAttributes(XtDisplay(graph), XtWindow(graph),
			    CWBackingStore, &atr);

    first_flag = 1;
  }
}

static void
set_on_off_callback(w, client_data, call_data)
     Widget          w;
     XtPointer       client_data, call_data;
{
  data_type      *data = (data_type *) client_data;

  int             n;
  Arg             args[10];
  Boolean         flag;

  n = 0;
  XtSetArg(args[n], XmNset, &flag);
  n++;
  XtGetValues(w, args, n);

  if (flag)
    data->set = ON;
  else
    data->set = OFF;
}



void
interval_proc(data, id)
     data_type      *data;
     XtIntervalId    id;
{
  if (data->count != 0 && data->pause == OFF) {
    data->count = 0;
    XtAppAddTimeOut(app_context, INTERVAL,
		    (XtTimerCallbackProc)interval_proc, data);
    read_data(data);
    if (data->real_point > 0) {
      clear_win();
      draw_proc(data);
    } else {
      clear_win();
    }
  } else {
    XtAppAddTimeOut(app_context, INTERVAL,
		    (XtTimerCallbackProc)interval_proc, data);
  }
}

void
draw_proc(data)
     data_type      *data;
{
  if (data->emulation == AMP)
    xgraph(XtDisplay(graph), XtWindow(graph), data->gc, 0, 0,
	   data->width, data->height, data->gc_scale,
	   data->x_type, data->y_type, data->x_scale, data->y_scale,
	   data->xmin, data->xmax, scaling(data->ymin), scaling(data->ymax),
	   data->real_point, data->x, data->y);
  else
    xgraph(XtDisplay(graph), XtWindow(graph), data->gc, 0, 0,
	   data->width, data->height, data->gc_scale,
	   data->x_type, data->y_type, data->x_scale, data->y_scale,
	   data->xmin, data->xmax, scaling(data->ymin), scaling(data->ymax),
	   data->real_point - 1, &(data->x[1]), &(data->y[1]));
}


void
set_info_scale(data)
     data_type      *data;
{
  /*
   * set_scale(info_x, data->x_type, data->x_scale); set_scale(info_y,
   * data->y_type, data->y_scale); 
   */
}


void
set_info_num(data)
     data_type      *data;
{
}


void
set_info_data(data)
     data_type      *data;
{
}


void
set_x_scale(data)
     data_type      *data;
{
  if (data->emulation == AMP) {
    if (data->x_type == SCALE_LINEAR) {
      wprintf(x_min, "%g", data->xmin);
      wprintf(x_max, "%g", data->xmax);
    } else {
      wprintf(x_min, "%.5g", log10(data->xmin));
      wprintf(x_max, "%.5g", log10(data->xmax));
    }
  } else {
    wprintf(x_min, "%g", pow(10.0, data->xmin));
    wprintf(x_max, "%g", pow(10.0, data->xmax));
  }
}


void
set_y_scale(data)
     data_type      *data;
{
  double  min = 0.0, max = 1.0;

  if (data->y_type == SCALE_LINEAR) {
    min = data->ymin;
    max = data->ymax;
  } else {
    if (data->ymin > 0.0)
      min = (float) log10(data->ymin);
    else
      min = 0;
    if (data->ymax > 0.0)
      max = log10(data->ymax);
    else
      min = 0;
  }

  if (data->y_scale == AUTO_SCALE) {
    min = scaling(min);
    max = scaling(max);
  }
  wprintf(y_min, "%.5g", min);
  wprintf(y_max, "%.5g", max);
}


void
clear_win()
{
  XClearWindow(XtDisplay(graph), XtWindow(graph));
}


