#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>


#ifdef HAVE_XM_MWMUTIL_H
#include <Xm/MwmUtil.h>
#endif
#include <Xm/Xm.h>

#include <Xm/ArrowB.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/ToggleB.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>

/* Common Data Structure */
typedef struct {
	int	count;
	int	pause;
	int	set;
	int	buff_no;
	int     rec_num;
	int     rec_max;
	int	emulation;
	int	scale;
	int	width;
	int	height;
	int	point;
	int	real_point;
	int	x_scale;
	int	y_scale;
	int	x_type;
	int	y_type;
	double	max_val;
	double	min_val;
	double	mean;
	double	xmin;
	double	xmax;
	double	ymin;
	double	ymax;
	double	*x;
	double	*y;
	GC	gc;
	GC	gc_scale;
}	data_type;



#undef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#else
#   define _ANSI_ARGS_(x)       ()
#endif

/* in bm.c */
extern void	interval_proc         _ANSI_ARGS_((data_type *data,
						   XtIntervalId id));
extern void     draw_proc             _ANSI_ARGS_((data_type *data));
extern void     clear_win             _ANSI_ARGS_((void));
extern void     set_info_scale        _ANSI_ARGS_((data_type *data));
extern void     set_info_num          _ANSI_ARGS_((data_type *data));
extern void     set_info_data         _ANSI_ARGS_((data_type *data));
extern void     set_x_scale           _ANSI_ARGS_((data_type *data));
extern void     set_y_scale           _ANSI_ARGS_((data_type *data));
extern void     init_send_event       _ANSI_ARGS_(());


/* in cb_button.c */
extern void	SetAMP                _ANSI_ARGS_((Widget w,
						   data_type *data,
						   caddr_t call_data));
extern void	SetPOWER              _ANSI_ARGS_((Widget w,
						   data_type *data,
						   caddr_t call_data));
extern void     ChangeDisplayCallback _ANSI_ARGS_((Widget w1, Widget w2,
						   XtPointer call_data));
extern void	SetAutoCallback       _ANSI_ARGS_((Widget w, int *scale,
						   caddr_t call_data));
extern void	SetFixedCallback      _ANSI_ARGS_((Widget w, int *scale,
						   caddr_t call_data));
extern void	SetLinerCallback      _ANSI_ARGS_((Widget w, int *scale,
						   caddr_t call_data));
extern void	SetLogCallback        _ANSI_ARGS_((Widget w, int *scale,
						   caddr_t call_data));
extern void     PauseCallback         _ANSI_ARGS_((Widget w,
						   XtPointer client_data,
						   XtPointer call_data));

/* in cb_graph.c */
extern void     ResizeCallback        _ANSI_ARGS_((Widget hw, data_type *data,
						   caddr_t call_data));
extern void     ExposeCallback        _ANSI_ARGS_((Widget hw, data_type *data,
						   Region *region));

/* in cb_no.c */
extern void	PushUpArrowCallback   _ANSI_ARGS_((Widget w, data_type *data,
						   caddr_t call_data));
extern void	PushDownArrowCallback _ANSI_ARGS_((Widget w, data_type *data,
						   caddr_t call_data));
extern void	NumberRedrawCallback  _ANSI_ARGS_((Widget w1, Widget w2,
						   caddr_t call_data));
extern void	SetNumberCallback     _ANSI_ARGS_((Widget w, data_type *data,
						   caddr_t call_data));
extern void     set_no                _ANSI_ARGS_((Widget w, int no));

/* in cb_popup.c */
extern void     PopupQuit             _ANSI_ARGS_((Widget w, data_type *data,
						   XtPointer call_data));

/* in draw.c */
extern void xgraph _ANSI_ARGS_((Display *display, Window window,
				GC gc, int x, int y, int width, int height,
				GC gc_line, int x_type, int y_type,
				int x_scale, int y_scale,
				double xmin, double xmax,
				double ymin, double ymax,
				int dpt,
				double *xdata, double *ydata));

/* in fft.c */
extern int      fft                   _ANSI_ARGS_((double *x, double *ar,
						   double *min, double *max,
						   int n));
/* in init.c */
extern void     init_data             _ANSI_ARGS_((data_type *data));
extern void     init_gc               _ANSI_ARGS_((Widget hw,
						   data_type *data));

/* in list.c */
extern void     add_list              _ANSI_ARGS_((int num));
extern void     del_list              _ANSI_ARGS_((int num));

/* in rdata.c */
extern void     read_data             _ANSI_ARGS_((data_type *data));

/* in scaling.c */
extern void     set_scale             _ANSI_ARGS_((Widget w,
						   int type, int scale));
extern double	scaling               _ANSI_ARGS_((double val));

/***** Utility Functions *****/
/* in wprintf.c */
#ifdef __STDC__
extern void     wprintf               _ANSI_ARGS_((Widget w, char *fmt, ...));
#else
extern void     wprintf               _ANSI_ARGS_((va_decl va_alist));
#endif



#define	ON	1
#define	OFF	0
#define	INTERVAL	50
#define	AMP	1
#define	POWER	2
#define	SCALE_LINEAR	0
#define	SCALE_LOG	1
#define	AUTO_SCALE	0
#define	FIXED_SCALE	1
