#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include <Xm/Xm.h>
#include <Xm/ToggleB.h>

#include "bmon.h"

void
SetAMP(w, data, call_data)
	Widget          w;
	data_type      *data;
	caddr_t         call_data;
{
	int             n;
	Arg             args[10];

	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetValues(w, args, n);

	data->emulation = AMP;
	read_data(data);
	clear_win();
	draw_proc(data);
}

void
SetPOWER(w, data, call_data)
	Widget          w;
	data_type      *data;
	caddr_t         call_data;
{
	int             n;
	Arg             args[10];

	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetValues(w, args, n);

	data->emulation = POWER;
	read_data(data);
	clear_win();
	draw_proc(data);
}

void
ChangeDisplayCallback(w1, w2, call_data)
	Widget          w1;
	Widget          w2;
	XtPointer       call_data;
{
	Arg             args[10];
	int             n;

	n = 0;
	XtSetArg(args[n], XmNset, FALSE); n++;
	XtSetValues(w2, args, n);
}

void
SetAutoCallback(w, scale, call_data)
	Widget          w;
	int            *scale;
	caddr_t         call_data;
{
	int             n;
	Arg             args[10];

	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetValues(w, args, n);

	*scale = AUTO_SCALE;
}


void
SetFixedCallback(w, scale, call_data)
	Widget          w;
	int            *scale;
	caddr_t         call_data;
{
	int             n;
	Arg             args[10];

	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetValues(w, args, n);

	*scale = FIXED_SCALE;
}


void
SetLinerCallback(w, scale, call_data)
	Widget          w;
	int            *scale;
	caddr_t         call_data;
{
	int             n;
	Arg             args[10];

	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetValues(w, args, n);

	*scale = SCALE_LINEAR;
}


void
SetLogCallback(w, scale, call_data)
	Widget          w;
	int            *scale;
	caddr_t         call_data;
{
	int             n;
	Arg             args[10];

	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetValues(w, args, n);

	*scale = SCALE_LOG;
}

void
PauseCallback(w, client_data, call_data)
	Widget          w;
	XtPointer       client_data, call_data;
{
	int             n;
	Arg             args[10];
	Boolean         onoff_flag;

	data_type      *data = (data_type *) client_data;

	n = 0;
	XtSetArg(args[n], XmNset, &onoff_flag); n++;
	XtGetValues(w, args, n);

	if (onoff_flag)
		data->pause = ON;
	else
		data->pause = OFF;
}
