#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <SL_macro.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/Label.h>

#include "bmon.h"

static int      buffer_number;
static int      emulation_mode;

void
PushUpArrowCallback(w, data, call_data)
     Widget          w;
     data_type      *data;
     caddr_t         call_data;
{
  buffer_number = data->rec_num;
  if (buffer_number < data->rec_max-1 )
    buffer_number++;
  data->rec_num = buffer_number;
}


void
PushDownArrowCallback(w, data, call_data)
     Widget          w;
     data_type      *data;
     caddr_t         call_data;
{
  buffer_number = data->rec_num;
  if (buffer_number > 0)
    buffer_number--;
  data->rec_num = buffer_number;
}

void
NumberRedrawCallback(w1, w2, call_data)
     Widget          w1;
     Widget          w2;
     caddr_t         call_data;
{
  set_no(w2, buffer_number);
}


#if 0
void
set_name(w, str)
     Widget          w;
     char	*str;
{
  Arg             args[10];
  int             i;
  XmString        label;

  label = XmStringCreate(str, XmSTRING_DEFAULT_CHARSET);

  i = 0;
  XtSetArg(args[i], XmNlabelString, label); i++;
  XtSetValues(w, args, i);

  XmStringFree(label);
}
#endif

void
set_no(w, no)
     Widget          w;
     int             no;
{
  Arg             args[10];
  char            str[16];
  int             i;
  XmString        label;

  sprintf(str, "%03d", no);

  label = XmStringCreate(str, XmSTRING_DEFAULT_CHARSET);

  i = 0;
  XtSetArg(args[i], XmNlabelString, label); i++;
  XtSetValues(w, args, i);

  XmStringFree(label);
}


void
SetNumberCallback(w, data, call_data)
     Widget          w;
     data_type      *data;
     caddr_t         call_data;
{
  if (buffer_number == 0)
    buffer_number = data->rec_num;
  /*
     if (data->set == OFF) {
     data->rec_num = buffer_number;
     return;
     }
     */
  emulation_mode = data->emulation;
  /*
     del_list(data->buff_no); 
     data->buff_no = buffer_number;
     add_list(data->buff_no);
     */
  data->rec_num = buffer_number;

  /* Read New Data & Draw */
  read_data(data);
  if (data->real_point < 0) {
    clear_win();
    return;
  }
  clear_win();
  draw_proc(data);
}


