#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include "bmon.h"

extern Widget   x_xmin, x_xmax, x_ymin, x_ymax;

void
PopupQuit(w, data, call_data)
     Widget          w;
     data_type      *data;
     XtPointer       call_data;
{
  data->scale = OFF;
  set_info_scale(data);

  if (data->x_scale == FIXED_SCALE) {
    sscanf(XmTextFieldGetString(x_xmax), "%lg", &(data->xmax));
    sscanf(XmTextFieldGetString(x_xmin), "%lg", &(data->xmin));
  } else {
    data->xmin = 1.0;
    if (data->real_point < 0)
      data->xmax = (double) data->point;
    else
      data->xmax = (double) data->real_point;
  }
  set_x_scale(data);

  if (data->y_scale == FIXED_SCALE) {
    sscanf(XmTextFieldGetString(x_ymax), "%lg", &(data->ymax));
    sscanf(XmTextFieldGetString(x_ymin), "%lg", &(data->ymin));
  } else {
    if (data->real_point < 0) {
      data->ymax = 1.0;
      data->ymin = -1.0;
    } else {
      if (data->max_val == 0.0 && data->min_val == 0.0) {
	data->ymax = 1.0;
	data->ymin = -1.0;
      } else {
	data->ymax = data->max_val;
	data->ymin = data->min_val;
      }
    }
  }
  set_y_scale(data);

  if (data->real_point > 0) {
    clear_win();
    draw_proc(data);
  } else {
    clear_win();
  }
}
