#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <math.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "bmon.h"


void
xgraph(display, window, gc, x, y, width, height, gc_line,
       x_type, y_type, x_scale, y_scale, xmin, xmax, ymin, ymax,
       dpt, xdata, ydata)
     Display        *display;
     Window          window;
     GC              gc;
     GC              gc_line;
     int             x, y, width, height, x_type, y_type;
     int             x_scale, y_scale;
     double          xmin, xmax, ymin, ymax;
     int             dpt;
     double          *xdata, *ydata;
     /************************************************
      *                                               *
      *          X-Window Graphic Utility             *
      *                                               *
      *          Real Data X[] & Y[] Plotting         *
      *               ( No Clipping )                 *
      *                                               *
      *          T.Kobayashi   (07/06/1990)           *
      *                                               *
      ************************************************/
{
  XPoint         *point;
  int             i;
  double          xdlt, ydlt;
  int             level;

  if (dpt < 0)
    return;

  if (y_scale == AUTO_SCALE) {
    ymin = scaling(ymin);
    ymax = scaling(ymax);
  }
  if (y_type == SCALE_LOG) {

    if (ymin > 0.0)
      ymin = log10(ymin);
    else
      ymin = 0.0;

    if (ymax > 0.0)
      ymax = log10(ymax);
    else
      ymax = 0.0;

    if (ymin == 0.0 && ymax == 0.0)
      return;
  }
  if (x_type == SCALE_LOG) {

    if (xmin > 0.0)
      xmin = log10(xmin);
    else
      xmin = 0.0;

    if (xmax > 0.0)
      xmax = log10(xmax);
    else
      xmax = 0.0;

    if (xmin == 0.0 && xmax == 0.0)
      return;
  }
  point = (XPoint *) malloc(sizeof(XPoint) * dpt);

  /* Draw Graph */

  xdlt = (xmax - xmin) / (double) width;
  ydlt = (ymax - ymin) / (double) height;

  if ( xdlt == 0 ) xdlt = 0.1;
  if ( ydlt == 0 ) ydlt = 0.5;

  if (x_type == SCALE_LINEAR && y_type == SCALE_LINEAR) {
    for (i = 0; i < dpt; i++) {
      point[i].x = (short) ((xdata[i] - xmin) / xdlt + (double) x);
      point[i].y = (short) ((double) height -
			    (ydata[i] - ymin) / ydlt + (double) y);
    }
  } else if (x_type == SCALE_LINEAR && y_type == SCALE_LOG) {
    for (i = 0; i < dpt; i++) {
      point[i].x = (short) ((xdata[i] - xmin) / xdlt + (double) x);
      if (ydata[i] > 0.0)
	point[i].y = (short) ((double) height -
			      (log10(ydata[i]) - ymin) / ydlt + (double) y);
      else
	point[i].y = (short) height + 1;
    }
  } else if (x_type == SCALE_LOG && y_type == SCALE_LINEAR) {
    for (i = 0; i < dpt; i++) {
      point[i].x = (short) (( log10(xdata[i]) - xmin) / xdlt + (double) x);
      point[i].y = (short) ((double) height - (ydata[i] - ymin) / ydlt
			    + (double) y);
    }
  } else if (x_type == SCALE_LOG && y_type == SCALE_LOG) {
    for (i = 0; i < dpt; i++) {
      point[i].x = (short) ((log10(xdata[i]) - xmin) / xdlt + (double) x);
      if (ydata[i] > 0.0)
	point[i].y = (short) ((double) height
			      - (log10(ydata[i]) - ymin) / ydlt + (double) y);
      else
	point[i].y = (short) height + 1;
    }
  }
  XDrawLines(display, window, gc, point, dpt, CoordModeOrigin);

  free(point);

  if (y_type == SCALE_LINEAR) {
    level = (int) ((double) height - (0.0 - ymin) / ydlt + (double) y);
    XDrawLine(display, window, gc_line, 0, level, width, level);
  }
}
