#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "bmon.h"

#include <math.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#define PAI 3.14159265358979323846


int
fft(x, ar, min, max, n)
     double   *x, *ar, *min, *max;
     int             n;
     /*-----------------------------------------------
       Subroutine FFT (Forward Only)
       
       ar   : Real Data
       n    : Data Point
       -----------------------------------------------*/
{
  int      i, j, it, xp, iter, xp2, k, j1, j2, im1, jm1;
  double  *ai, delta;
  double   w, wr, wi, dr1, dr2, di1, di2, tr, ti, arg;


  if (n < 2)
    return (-1);

  for (iter = 0, i = n; (i /= 2) != 0; iter++);

  for (i = 0, j = 1; i < iter; i++, j *= 2);

  if (n != j) {
    if ((j * 2) <= syscom.buff_leng) {
      j *= 2;
      iter++;
    }
    for (i = n; i < j; ar[i++] = 0.0);
    n = j;
  }
  ai = (double *) malloc(sizeof(double) * n);
  for (i = 0; i < n; ai[i++] = 0.0);

  xp2 = n;
  for (it = 0; it < iter; it++) {
    xp = xp2;
    xp2 = xp / 2;
    w = PAI / (double) xp2;
    for (k = 0; k < xp2; k++) {
      arg = (double) k *w;
      wr = cos(arg);
      wi = -1.0 * sin(arg);
      i = k - xp;
      for (j = xp; j <= n; j += xp) {
	j1 = j + i;
	j2 = j1 + xp2;
	dr1 = ar[j1];
	dr2 = ar[j2];
	di1 = ai[j1];
	di2 = ai[j2];
	tr = dr1 - dr2;
	ti = di1 - di2;
	ar[j1] = dr1 + dr2;
	ai[j1] = di1 + di2;
	ar[j2] = tr * wr - ti * wi;
	ai[j2] = ti * wr + tr * wi;
      }
    }
  }
  j1 = n / 2;
  j2 = n - 1;
  j = 1;
  for (i = 1; i <= j2; i++) {
    if (i < j) {
      im1 = i - 1;
      jm1 = j - 1;
      tr = ar[jm1];
      ti = ai[jm1];
      ar[jm1] = ar[im1];
      ai[jm1] = ai[im1];
      ar[im1] = tr;
      ai[im1] = ti;
    }
    k = j1;
    while (k < j) {
      j -= k;
      k /= 2;
    }
    j += k;
  }

  *min = 0.0;
  *max = 0.0;
  /* delta = syscom.sam_freq / ( (double)( n - 1 ) * 2.0 ) ;	 */
  delta = syscom.sam_freq / ((double) (n - 1));

  for (i = 1; i < n; i++) {
    ar[i] = 2.0 * (ar[i] * ar[i] + ai[i] * ai[i])
      / (syscom.sam_freq * (double) n);
    if (ar[i] == 0.0)
      return (-1);
    ar[i] = 10.0 * (double) log10((double) ar[i]);

    x[i] = (double) log10((double) (delta * (double) i));
    /* if( ar[ i ] < 0.0 )	ar[ i ] = 0.0 ; */
    if (*max < ar[i])
      *max = ar[i];
    if (*min > ar[i])
      *min = ar[i];
  }
  if (*min < -300.0)
    *min = -300.0;

  free(ai);

  return (n / 2 + 1);
}
