#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include "bmon.h"


void
init_data(data)
     data_type      *data;
{
  data->count = 0;
  data->pause = OFF;
  data->set = ON;
  data->emulation = AMP;
  data->scale = OFF;
  data->x_type = SCALE_LINEAR;
  data->y_type = SCALE_LINEAR;
  data->x_scale = AUTO_SCALE;
  data->y_scale = AUTO_SCALE;
}


void
init_gc(hw, data)
     Widget          hw;
     data_type      *data;
{
  XGCValues       gcv;
  Arg             args[10];
  int             fg, bg;
  int             i;


  i = 0;
  XtSetArg(args[i], XtNforeground, &fg); i++;
  XtSetArg(args[i], XtNbackground, &bg); i++;
  XtGetValues(hw, args, i);

  gcv.foreground = fg;
  gcv.background = bg;
  gcv.line_width = 0;
  gcv.cap_style = CapRound;
  data->gc = XtGetGC(hw, GCForeground | GCBackground
		     | GCLineWidth | GCCapStyle, &gcv);

  gcv.foreground = fg;
  gcv.background = bg;
  gcv.line_width = 0;
  gcv.line_style = LineOnOffDash;
  gcv.cap_style = CapRound;
  data->gc_scale = XtGetGC(hw, GCForeground | GCBackground
			   | GCLineWidth | GCLineStyle | GCCapStyle, &gcv);

}
