#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "bmon.h"

static void     get_fname();


void
add_list(num)
     int             num;
{
  char            fname[FILE_LENGTH];
  int             fd, pid;

  get_fname(fname, num);
  pid = getpid();
  if (access(fname, 0) == 0) {
    fd = open(fname, O_WRONLY | O_APPEND, 0644);
  } else {
    fd = open(fname, O_WRONLY | O_CREAT | O_TRUNC, 0644);
  }
  write(fd, (char *) &pid, sizeof(int));
  close(fd);
}


void
del_list(num)
     int             num;
{
  char            fname[FILE_LENGTH];
  int             fd, pid[MAX_BUFF_MON], my_pid, i, j;

  get_fname(fname, num);

  i = 0;
  fd = open(fname, O_RDONLY, 0);
  while (read(fd, (char *) &pid[i], sizeof(int)) == sizeof(int))
    i++;
  close(fd);

  my_pid = getpid();
  fd = open(fname, O_WRONLY | O_CREAT | O_TRUNC, 0644);
  for (j = 0; j < i; j++) {
    if (pid[j] != my_pid)
      write(fd, (char *) &pid[j], sizeof(int));
  }
  close(fd);
}


static void
get_fname(fname, num)
     char           *fname;
     int             num;
{
  static char            c_no[16];

  strcpy(fname, syscom.temp_dir);
  strcat(fname, "BUFFER");
  sprintf(c_no, "%d", num);
  strcat(fname, c_no);
  strcat(fname, "M");

}
