#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "bmon.h"


void
read_data(data)
	data_type      *data;
{
  int   dim, index1[MAX_INDEX], index2[MAX_INDEX];
  int   i;
  double sum;

  read_syscom();

  if ( data->y != NULL )  FreeBuffer( data->y );
  if ( data->x != NULL )  FreeBuffer( data->x );

  dim = GetBufferInfo( data->buff_no, index1 );

  if ( dim < 1 )
    exit(2);


  if ( dim == 1 ) {
    data->point = index1[0];
    data->y = ReadBuffer( data->buff_no, &dim, index1 );
    data->x = AllocBuffer( data->point );
    data->rec_max = 1;
    data->rec_num = 0;
  } else {
    if ( data->set == ON ) {
      data->rec_max = index1[0];
      if ( data->rec_num >= data->rec_max )
	data->rec_num = data->rec_max-1;
      data->y = ReadSubBuffer( data->buff_no, data->rec_num, &dim, index1 );
      data->point = IndexSize( dim, index1 );
      data->x = AllocBuffer( data->point );
    } else {
      data->point = index1[0];
      data->rec_max = IndexSize(dim-1,SubIndex(index1));
      if ( data->rec_num >= data->rec_max )
	data->rec_num = data->rec_max-1;
      rIndex( data->rec_num, index2, dim-1, SubIndex(index1) );
      data->y = ReadTimeSeries( data->buff_no, dim-1, index2, &data->point );
      data->x = AllocBuffer( data->point );
    }
  }
  data->real_point = syscom.buff_leng = data->point;

  set_info_num(data);

  if (data->x_scale == AUTO_SCALE) {
    if (data->emulation == AMP) {
      data->xmin = 1.0;
      if (data->real_point < 0)
	data->xmax = (double) data->point;
      else
	data->xmax = (double) data->real_point;
      set_x_scale(data);
    } else {
      data->xmin = 0.0;
      data->xmax = (double)
	((int) (log10((double) syscom.sam_freq / 2.0) + 0.999));
      set_x_scale(data);
    }
  }
  if (data->real_point < 0 && data->y_scale == AUTO_SCALE) {
    data->ymax = 1.0;
    data->ymin = -1.0;
    set_y_scale(data);
    set_info_data(data);
    return;
  }
  if (data->real_point < 0) {
    set_info_data(data);
    return;
  }
  sum = 0;
  data->max_val = data->y[0];
  data->min_val = data->y[0];
  for (i = 0; i < data->real_point; i++) {
    data->x[i] = (double) (i + 1);
    sum += data->y[i];
    if (data->y[i] > data->max_val)
      data->max_val = data->y[i];
    if (data->y[i] < data->min_val)
      data->min_val = data->y[i];
  }
  data->mean = sum / (double) data->real_point;
  set_info_data(data);
  
  if (data->emulation == POWER) {
    if ( fft(data->x, data->y, &(data->ymin), &(data->ymax),
	     data->real_point) == -1)
      return;
    if (data->ymax == 0.0 && data->ymin == 0.0) {
      data->ymax = 1.0;
      data->ymin = -1.0;
    }
    set_y_scale(data);
    return;
  }
  if (data->y_scale == AUTO_SCALE) {
    data->ymax = data->max_val;
    data->ymin = data->min_val;
    if (data->ymax == 0.0 && data->ymin == 0.0) {
      data->ymax = 1.0;
      data->ymin = -1.0;
    }
    set_y_scale(data);
  }
}

