#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include "bmon.h"


void
set_scale(w, type, scale)
     Widget          w;
     int             type, scale;
{
  char           *mode1, *mode2;

  if (type == SCALE_LINEAR)
    mode1 = "LINEAR";
  else
    mode1 = "LOG";

  if (scale == AUTO_SCALE)
    mode2 = "AUTO";
  else
    mode2 = "FIXED";
  wprintf(w, "%s\n%s", mode1, mode2);
}


double
scaling(val)
     double  val;
{
  char      str2[32], str3[32], str4[32];
  double    real, ind;

  sprintf(str2, "%8.1e", val);

  strncpy(str3, str2, 4);
  str3[4] = '\0';
  sscanf(str3, "%lf", &real);

  strncpy(str4, &str2[5], 3);
  str4[3] = '\0';
  sscanf(str4, "%lf", &ind);

  return (real * pow(10.0, ind));
}
