#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>

void
#ifdef __STDC__
wprintf(Widget w, char *format, ...)
#else
wprintf(va_alist)
     va_dcl
#endif
{
  char            str[1024];
  Arg             wargs[16];
  XmString        label;
  va_list         args;

  /* Init a variable length args list. */
#ifdef __STDC__
  va_start(args, format);
#else
  Widget          w;
  char           *format;

  va_start(args);
  w      = va_arg(args, Widget);
  format = va_arg(args, char *);
#endif

  if (XtClass(w) != xmLabelWidgetClass)
    XtError("wprintf() requires a XmNlabel Widget");

  /*
   * Use vsprintf to format the string to be displayed in the
   * StaticText widget 
   */
  vsprintf(str, format, args);

  label = XmStringCreate(str, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(wargs[0], XmNlabelString, label);
  XtSetValues(w, wargs, 1);
  va_end(args);

  XmStringFree(label);
}
