/*************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *               Ver                             *
 *         coded         in Nov.5  1990          *
 *         last modified in Nov.15 1990          *
 *         coded by      K.Kuroda                *
 *                                               *
 *************************************************
 *                                               *
 *       filename correlat.c			 *
 *                     				 *
 *************************************************/
#include        "BPS.h"

#define	CORRELAT	'C'
#define	DISTANCE	'D'

static char     corr_mode;
static int      start_buff, num_buff;
static int      num_data;
static float  **corre_data, **data;
static Buffer  *dum;

/************************************************
  set_parameters
  ************************************************/
void
set_param()
{
  char *str;

  start_buff = GetBufferID(0);
  str        = GetString(1);
  
  if (start_buff <= 0)
    exit(17);

  corr_mode = toupper(str[0]);
  if ((corr_mode != CORRELAT) && (corr_mode != DISTANCE))
    exit(22);
}


/************************************************
  allocate to array
  ************************************************/
void
alloc_array()
{
  corre_data = (float**)malloc2D(num_buff, num_buff, sizeof(float));
  if (corre_data == NULL)
    exit(23);
}


/************************************************
  read data from buffer to array
  ************************************************/
void
read_data()
{
  int  i, j, k;
  int  dim, idx[MAX_INDEX];
  
  dum = ReadBuffer(start_buff, &dim, idx);
  
  num_data = idx[1];
  num_buff = idx[0];

  data = (float**)malloc2D(num_buff, num_data, sizeof(float));
  if (data == NULL)
    exit(23);

  for(i = 0, k = 0; i < num_buff; i++)
    for(j = 0; j < num_data; j++, k++)
      data[i][j] = (float)dum[k];

  free(dum);
}


/************************************************
  calculate covariance matrix
  ************************************************/
void
cal_covariance()
{
  int   i, j, k;
  float temp, *mean;
  
  mean = (float *)malloc(num_buff * sizeof(float));
  if (mean == NULL)
    exit(23);
  
  /* CALCULATE MEAN */
  for (i = 0; i < num_buff; i++) {
    temp = 0.0;
    for (j = 0; j < num_data; j++)
      temp += data[i][j];
    mean[i] = temp / (float)num_data;
  }
  
  /* CALCULATE COVARIANCE MATRIX */
  for (i = 0; i < num_buff; i++)
    for (j = 0; j < num_buff; j++)
      corre_data[i][j] = 0.0;

  for (i = 0; i < num_buff; i++) {
    for (j = i; j < num_buff; j++) {
      temp = 0.0;
      for (k = 0; k < num_data; k++) {
	temp += data[i][k] * data[j][k];
      }
      corre_data[j][i] = (temp - num_data*mean[i]*mean[j])/(float)(num_data-1);
    }
  }

  free(mean);
}

/************************************************
  calculate correlation matrix
  ************************************************/
void
cal_correlation()
{
  int             i, j;
  float          *stand_div;
  
  stand_div = (float *)malloc(num_buff * sizeof(float));
  if (stand_div == NULL)
    exit(23);
  
  for (i = 0; i < num_buff; i++)
    stand_div[i] = (float) sqrt((double) corre_data[i][i]);
  
  for (i = 0; i < num_buff - 1; i++) {
    for (j = i + 1; j < num_buff; j++) {
      corre_data[i][j] = corre_data[j][i] / (stand_div[i] * stand_div[j]);
    }
  }

  free(stand_div);
}


/************************************************
  calculate distance
  ************************************************/
void
cal_distance()
{
  int    i, j, k;
  float  tmp;
  
  for (i = 0; i < num_buff - 1; i++) {
    for (j = i + 1; j < num_buff; j++) {
      for (k = 0; k < num_data; k++) {
	tmp               = data[i][k] - data[j][k];
	corre_data[i][j] += tmp * tmp;
      }
    }
  }
}


/************************************************
  store data 
  ************************************************/
void
stordata()
{
  int      i,j;
  int	   idx[MAX_BUFF_DIM];
  double  *dum;
  
  idx[0] = num_buff;
  idx[1] = num_buff;
  
  dum = AllocBuffer(IndexSize(2, idx));
  
  printf("  ### Snapshot : 2d_Dimension ");

  for (i = 0; i < 2; i++)
    printf("[%d]", idx[i]);

  printf(" ###\n");
  printf("  ### CORRELATION ==> 2D Snapshot ###\n");
  
  for (i = 0; i < idx[0]; i++) {
    for(j = 0; j < idx[1]; j++) {
      *(dum+j+i*idx[1]) = (double)corre_data[i][j];
    }
    printf("     CORRELATION ==> INDEX[%d] \r", i );
    fflush(stdout);
  }

  printf("\n");

  ReturnSnapshot(dum, 2, idx);
  free(dum);
}

/************************************************
  correlation analysys of weight
  ************************************************/
int
main()
{
  /* GET PARAMETERS */
  read_syscom();
  set_param();
  
  read_data();
  alloc_array();
  
  printf("read_data is OK\n");
  
  cal_covariance();

  switch (corr_mode) {
  case CORRELAT:  cal_correlation(); break;
  case DISTANCE:  cal_distance();    break;
  }

  stordata();
  
  free2D(corre_data);
  free2D(data);

  write_syscom();
  return 0;
}
