/************************************************
*                                               *
*       Back Propergation Simurator(BPS)        *
*             subroutine package                *
*               Ver 				*
*         coded         in Nov.16 1989          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename errfunc.c                      *
*                                               *
************************************************/
#include        "BPS.h"

static int    wgt_hist_no;
static int    lay_no1, unit_from1, unit_to1, dpoint1;
static int    lay_no2, unit_from2, unit_to2, dpoint2;
static float  min_wgt1, max_wgt1;
static float  min_wgt2, max_wgt2;

Buffer       *err_data;


/************************************************
  set parameters
  ************************************************/

void
set_param()
{
  wgt_hist_no =   (int)GetScalar(0);

  lay_no1     =   (int)GetScalar(1);
  unit_from1  =   (int)GetScalar(2);
  unit_to1    =   (int)GetScalar(3);
  min_wgt1    = (float)GetScalar(4);
  max_wgt1    = (float)GetScalar(5);
  dpoint1     =   (int)GetScalar(6);

  lay_no2     =   (int)GetScalar(7);
  unit_from2  =   (int)GetScalar(8);
  unit_to2    =   (int)GetScalar(9);
  min_wgt2    = (float)GetScalar(10);
  max_wgt2    = (float)GetScalar(11);
  dpoint2     =   (int)GetScalar(12);

  if (wgt_hist_no <= 0)
    exit(17);
  if (MaxLearnCount < wgt_hist_no)
    exit(25);

  if ((lay_no1 < 0) || ((NumOfLayer-1) < lay_no1))
    exit(27);
  if ((unit_from1 < 1) || (NumOfCell[lay_no1] < unit_from1))
    exit(21);
  if ((unit_to1 < 1) || (NumOfCell[lay_no1+1] < unit_to1))
    exit(21);
  if (dpoint1 < 1)
    exit(57);

  if ((lay_no2 < 0) || ((NumOfLayer-1) < lay_no2))
    exit(20);
  if ((unit_from2 < 1) || (NumOfCell[lay_no2] < unit_from2))
    exit(21);
  if ((unit_to2 < 1) || (NumOfCell[lay_no2+1] < unit_to2))
    exit(21);
  if (dpoint2 < 1)
    exit(63);
}


/************************************************
  clean OutCellErr
  ************************************************/
void
clean_outcell()
{
  int  unit;
#if 0  
  for (unit = 0; unit < NumOfCell[NumOfLayer - 1]; unit++);
  OutCellErr[unit] = 0.0; /* ??? */
#else /* ʤΤǤ */
  for (unit = 0; unit < NumOfCell[NumOfLayer - 1]; unit++)
    OutCellErr[unit] = 0.0;
#endif
}


/************************************************
  calculate error function and
  store data
  ************************************************/
void
cal_err()
{
  double   weight1, weight2, delta1, delta2;
  int      i, j, ptrn;
  int      idx[10];
  
  idx[0] = dpoint1;
  idx[1] = dpoint2;

  printf("  ### Snapshot : 2d_Dimension ");
  for (i = 0; i < 2; i++)
    printf("[%d]", idx[i]);
  printf(" ###\n");

  printf("  ### ERROR FUNCTION ==> 2D Snapshot ###\n");
  
  err_data = AllocBuffer(IndexSize(2, idx));
  if (err_data == NULL)
    exit(23);

  delta1 = (max_wgt1 - min_wgt1) / (dpoint1 - 1);
  delta2 = (max_wgt2 - min_wgt2) / (dpoint2 - 1);
  weight1 = min_wgt1;
  
  for (i = 0; i < dpoint1; i++) {
    SetWeight(BPNet[lay_no1][unit_from1].CellNode,
	      BPNet[lay_no1+1][unit_to1].CellNode, weight1);
    weight2 = min_wgt2;
    for (j = 0; j < dpoint2; j++) {
      SetWeight(BPNet[lay_no2][unit_from2].CellNode,
		BPNet[lay_no2+1][unit_to2].CellNode, weight2);
      *(err_data+i*dpoint2+j) = (double)0.0;
      for (ptrn = 0; ptrn < NumOfPtrn; ptrn++) {
	*(err_data+i*dpoint2+j) +=
	  (double)forward_learn(InputData[ptrn], TeachData[ptrn]);
      }
      weight2 += delta2;
    }
    weight1 += delta1;
    
    printf("     ERROR FUNCTION ==> INDEX[%d] \r", i);
    fflush(stdout);
  }
  printf("\n");
  ReturnSnapshot(err_data, 2, idx);

  free(err_data);
}


/***********************************************
  error function
  ***********************************************/
int
main()
{
  /* GET PARAMETERS */
  read_syscom();
  rebps();

  GetStructureParameters();
  GetLearningParameters();
  set_param();
  
  /* SYSTEM INITAIALIZE */
  system_initialize();
  MakeNetwork();

  ReadWeight2(WgtHistoryFile, wgt_hist_no);

  clean_outcell();
  workspace_initialize();
  
  /* CALCULATE ERROR FUNCTION */
  cal_err();
  
  /* SYSTEM END */
  BreakNetwork();
  system_end();

  wrbps();
  write_syscom();
  return 0;
}
