/************************************************
* 						*
*	Back Propergation Simurator(BPS)	*
*	      subroutine package		*
*	        Version	        	 	*
*	  coded		in Oct.11 1989		*
*	  coded by 	K.Kuroda	 	*
*						*
*************************************************
*						*
*	filename rvmap.c			*
*	   reverce mapping			*
*						*
************************************************/
#include	"BPS.h"

static int     outlay_num, inlay_num, hist_num, buff_num;


/***********************************************
 * set parameters
 ***********************************************/
void
set_param()
{
  outlay_num = (int)GetScalar(0);
  inlay_num  = (int)GetScalar(1);
  hist_num   = (int)GetScalar(2);
  buff_num   = (int)GetScalar(3);

  if (outlay_num <= inlay_num)                        exit(21);
  if ((outlay_num >= NumOfLayer) || (outlay_num < 0)) exit(22);

  if ((inlay_num < 0) || (inlay_num >= NumOfLayer))   exit(23);
}


/***********************************************
 * calculate weight block size
 ***********************************************/
void
cal_blk_siz()
{
  SetNumOfLink();

  /*  WgtBlockSize = NumOfLink / HBUFSIZE;
      if ((NumOfLink % HBUFSIZE) != 0)
      WgtBlockSize++; */
}


/************************************************
 * main routine
 ************************************************/
int
main()
{
  int      i, j, k, m;
  float   *wdata, sum_wgt;
  float  **rvdata1 = NULL, **rvdata2 = NULL, **rvdata3 = NULL;
  cel_t   *cell_pt;
  ilin_t  *cur_ilin;
  Header   header;
  double  *dum;
  int      idx[10];
  
  /* GET PARAMETERS */
  read_syscom();
  rebps();

  GetStructureParameters();
  GetLearningParameters();
  set_param();
  
  if (access(WgtHistoryFile, 0) == -1) {
    printf("\nERROR. File [ %s ] is not exist.\n", WgtHistoryFile);
    exit(-1);
  }
  cal_blk_siz();
  
  if (LoadHeader(WgtHistoryFile, &header) == -1)
    exit(11);
  
  if ((hist_num < 0) || (hist_num > header.index[0])) {
    printf("ERROR : weight history number error.\n");
    exit(-1);
  }
  if (hist_num == 0)
    hist_num = LastWgtHistory(WgtHistoryFile) + 1;
  
  /* set weight data in BPNet */
  MakeNetwork();
  
  wdata = (float*)LoadData(WgtHistoryFile, hist_num - 1, &header);
  if (wdata == NULL) exit(730);
  
  printf("hist_num   = %d\n", hist_num);
  printf("NumOfLayer = %d\n", NumOfLayer);
  
  k = 0;
  for (i = 1; i < NumOfLayer; i++) {
    for (j = 1; j <= NumOfCell[i]; j++) {
      if (CheckBias(i))
	SetWeight(BPNet[i][0].CellNode, BPNet[i][j].CellNode,
		  (double)wdata[k++]);
      for (m = 1; m <= NumOfCell[i - 1]; m++)
	SetWeight(BPNet[i - 1][m].CellNode, BPNet[i][j].CellNode,
		  (double)wdata[k++]);
    }
  }

  /* set rvdata1 */
  rvdata1 = (float**)malloc2D(NumOfCell[outlay_num],
			      NumOfCell[outlay_num-1]+1, sizeof(float));
  if (rvdata1 == NULL) {
    printf("ERROR: Can't allcate to rvdata1.\n"); exit(1);
  }

  k = (CheckBias(outlay_num)) ? 0 : 1;

  for (i = 0; i < NumOfCell[outlay_num]; i++) {
    cur_ilin = Getintoplist(BPNet[outlay_num][i+1].CellNode);

    m = k;
    while (cur_ilin != NULL) {
      cell_pt       = cur_ilin->InputCell;
      rvdata1[i][m] = (float)(cur_ilin->Weight);
      m++;
      /*
       * printf("rvdata1[%d][%d] = %f ",i,m-1,rvdata1[i][m-1]);
       */
      cur_ilin = Getinfwdlist(cur_ilin);
    }
  }
  
  /* calculate reverse mapping */
  for (i = outlay_num - 1; i > inlay_num; i--) {
    k = (CheckBias(i)) ? 0 : 1;

    /* set rvdata2 */
    if ( rvdata2 != NULL ) free2D((char**)rvdata2);
    rvdata2 = (float**)malloc2D(NumOfCell[i], NumOfCell[i-1]+1, sizeof(float));
    if (rvdata2 == NULL) {
      printf("ERROR: Can't allcate to rvdata2.\n"); exit(1);
    }

    for (j = 0; j < NumOfCell[i]; j++) {
      m = k;
      cur_ilin = Getintoplist(BPNet[i][j + 1].CellNode);
      
      while (cur_ilin != NULL) {
	cell_pt       = cur_ilin->InputCell;
	rvdata2[j][m] = (float)(cur_ilin->Weight);
	m++;
	/*
	 * printf("rvdata2[%d][%d] = %f ",j,m-1,rvdata2[j][m-1]);
	 */
	cur_ilin = Getinfwdlist(cur_ilin);
      }
    }

    
    /* calculate rvdata3 = rvdata1 * rvdata2 */
    if ( rvdata3 != NULL ) free2D((char**)rvdata3);
    rvdata3 = (float**)malloc2D(NumOfCell[outlay_num],
				NumOfCell[i-1]+1, sizeof(float));
    if (rvdata3 == NULL) {
      printf("ERROR: Can't allcate to rvdata3.\n"); exit(1);
    }


    for (j = 0; j < NumOfCell[outlay_num]; j++) {
      for (k = 0; k < NumOfCell[i-1]; k++) {
	sum_wgt = 0.0;
	for (m = 0; m < NumOfCell[i]; m++)
	  sum_wgt += rvdata1[j][m+1] * rvdata2[m][k+1];

	rvdata3[j][k+1] = sum_wgt;

	/*
	 * printf("rvdata3[%d][%d] = %f ",j,k+1,rvdata3[j][k+1]);
	 */
      }
    }


    /* copy rvdata3 -> rvdata1 */
    if ( rvdata1 != NULL ) free2D((char**)rvdata1);
    rvdata1 = (float**) malloc2D(NumOfCell[NumOfLayer-1],
				 NumOfCell[i-1]+1, sizeof(float));
    if (rvdata1 == NULL) {
      printf("ERROR: Can't allcate to rvdata1.\n");
      exit(1);
    }

    for (j = 0; j < NumOfCell[outlay_num]; j++)
      for (k = 0; k < NumOfCell[i-1]; k++)
	rvdata1[j][k+1] = rvdata3[j][k+1];
  }
  /* output buffer */
  
  dum    = AllocBuffer(NumOfCell[outlay_num]*NumOfCell[inlay_num]);
  idx[0] = NumOfCell[outlay_num];
  idx[1] = NumOfCell[inlay_num];
  
  for (i = 0; i < NumOfCell[outlay_num]; i++) {
    for (j = 0; j < NumOfCell[inlay_num]; j++){
      /* 䤷 by take
       dum[(j+i*NumOfCell[outlay_num])] = rvdata1[i][j + 1];
       */
      /* ֤󡤤줬 by take */
      dum[(j+i*NumOfCell[inlay_num])] = rvdata1[i][j + 1];
    }
    printf("  ### REVERCE MAPPING DATA ==> Series:[%d] ###\r", i);
    fflush(stdout);
  }

  ReturnSnapshot(dum, 2, idx);
  printf("\n");
  
  free(wdata);
  free(dum);
  free2D(rvdata1);
  free2D(rvdata2);
  free2D(rvdata3);
  BreakNetwork();
  return 0;
}
