/*************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *         	Version            		 * 
 *	  coded		in Oct.10 1990		 *
 *         coded by 	K.Kuroda                 *
 *                                               *
 *************************************************
 *                                               *
 *       filename wgtset.c                       *
 *               initialize data set             *
 *               main routine                    *
 *                                               *
 ************************************************/
#include	"BPS.h"

/************************************************
  main program
  ************************************************/
int
main()
{
  int     lay_no, unit_from, unit_to;
  float   weight;

  read_syscom();
  rebps();
  GetStructureParameters();
  GetInitializeParameters();

  /* get parameters */
  lay_no    =   (int)GetScalar(0);
  unit_from =   (int)GetScalar(1);
  unit_to   =   (int)GetScalar(2);
  weight    = (float)GetScalar(3);


  /* WgtMaxDataPoint = 0; no use */
  /* CleanHistArray(WgtOutData); no use*/

  SetNumOfLink();
  /* WgtBlockSize = NumOfLink / HBUFSIZE;
  if ((NumOfLink % HBUFSIZE) != 0)
    WgtBlockSize++; */

  MakeNetwork();
	
  ReadWeight2(InitWgtFile, 1);

  SetWeight(BPNet[lay_no][unit_from].CellNode,
	    BPNet[lay_no+1][unit_to].CellNode, weight);
  SetDeltaWgt(BPNet[lay_no][unit_from].CellNode,
	      BPNet[lay_no+1][unit_to].CellNode, 0.0);

  StoreWeight2(InitWgtFile, 1);


  BreakNetwork();
  wrbps();
  write_syscom();
  return 0;
}
