/************************************************
 *                                              *
 *       Back Propergation Simurator(BPS)       *
 *             subroutine package               *
 *         	Version            		* 
 *	   coded	in Aug.25 1989		*
 *         coded by 	Y.Okamura               *
 *         last modified in Nov.15 1990         *
 *         modified by 	K.Kuroda                *
 *                                              *
 ************************************************
 *                                              *
 *       filename inimain.c                     *
 *	BPS WINIT command			*
 *                                              *
 ************************************************/
#include  "BPS.h"

#ifndef  HAVE_LRAND48
long int  lrand48 _ANSI_ARGS_((void));
void      srand48 _ANSI_ARGS_((long int seedval));
#endif


#define	AREA_COEF_A     2.0   /* for jia's */
#define	AREA_COEF_B     3.0   /* for jia's */

/************************************************
  generate randum number
  inputs:
  low  : minimum of randum number
  high : maximum of randum number
  ************************************************/
double 
randm(low, high)
     double          low, high;
{
  double          norm, data;

  norm = 2147483646.0;
  data = low + (high - low) * (double)lrand48()/norm;
  return data;
}

/************************************************
  make initialize file with random data
  ************************************************/
void 
initialize_random()
{
  int      i;
  Buffer  *WgtBuff;

  srand48(Seed);

  WgtBuff = AllocBuffer(NumOfLink);
  if (WgtBuff == NULL) exit(1); /* ###suzu### */

  for (i = 0; i < NumOfLink; i++)
    WgtBuff[i] = randm(MinInitWgt, MaxInitWgt);
  WriteWeight2(InitWgtFile, 0, WgtBuff);

  for (i = 0; i < NumOfLink; i++)
    WgtBuff[i] = 0.0;
  WriteWeight2(InitWgtFile, 1, WgtBuff);

  free(WgtBuff);
}

/************************************************
  make initialize file with JIA's algorithm
  ***********************************************/
void 
initialize_jia()
{
  int      lay, unit_to, unit_from, i, writepoint;
  double   wgt_temp, active_area, cube_size, coeff, *weight;
  double  *WgtBuff;
  int      dpt;
  
  writepoint = 0;

  srand48(Seed);
  
  WgtBuff = AllocBuffer(NumOfLink);
  if (WgtBuff == NULL) exit(1);
  
  dpt = 0; /* by take */
  for (lay = 1; lay < NumOfLayer; lay++) {
    if (CheckBias(lay)) {
      for (unit_to = 1; unit_to <= NumOfCell[lay]; unit_to++) {
	weight = (double *) malloc((NumOfCell[lay-1]+1) * sizeof(double));
	if (weight == NULL) exit(30);

	/* ( 1 ) SET RANDOM DATA */
	for (unit_from = 1; unit_from <= NumOfCell[lay-1]; unit_from++)
	  weight[unit_from] = randm(MinInitWgt, MaxInitWgt);
	weight[0] = 0.0;

	/* ( 2 ) SET THRESHOLD */
	wgt_temp = 0.0;
	for (unit_from = 1; unit_from <= NumOfCell[lay-1]; unit_from++) {
	  weight[0] -= 0.5 * weight[unit_from];

	  wgt_temp += weight[unit_from] * weight[unit_from];
	}

	/* ( 3 ) SET WIDTHS OF ACTIVE AREA */
	active_area = 4.4 / sqrt(wgt_temp);

	/* ( 4 ) ADJUST ACTIVE AREA TO CUBE SIZE */
	cube_size = sqrt((double) NumOfCell[lay]);
	coeff = active_area/(cube_size * randm(AREA_COEF_A, AREA_COEF_B));

	for (unit_from = 0; unit_from <= NumOfCell[lay-1]; unit_from++) {
	  /* weight[unit_from]  *= coeff; by take */
	  WgtBuff[dpt++]      = coeff * weight[unit_from]; /* by take */
	}
	free(weight);
      }
    } else
      exit(31);
  }
  WriteWeight2(InitWgtFile, 0, WgtBuff);
  
  for (i = 0; i < NumOfLink; i++)
    WgtBuff[i] = 0.0;
  WriteWeight2(InitWgtFile, 1, WgtBuff);
  free(WgtBuff);
}


/************************************************
  initialize data maker
  main routine
  ************************************************/
int
main()
{
  read_syscom();
  rebps();

  GetStructureParameters();
  PrintStructureParameters();
  GetInitializeParameters();
  PrintInitializeParameters();

  CreateFile1(InitWgtFile, "initialize wight data"); 

  /* WgtMaxDataPoint = 0; */
  /* CleanHistArray(WgtOutData); nouse */

  SetNumOfLink();
  /* WgtBlockSize = NumOfLink / HBUFSIZE;
  if ((NumOfLink % HBUFSIZE) != 0)
    WgtBlockSize++; */

  switch (InitAlgo) {
    /* INITIALIZE DATA MAKER WITH RANDOM DATA */
  case RANDUM:
    initialize_random();
    break;

    /* INITIALIZE DATA MAKER WITH JIA'S ALGORITHM */
  case JIA:
    initialize_jia();
    break;
  }
  
  return 0;
}

#ifndef HAVE_LRAND48
/*	@(#)drand48.c	2.2	*/
/*
 *	drand48, etc. pseudo-random number generator
 *	This implementation assumes unsigned short integers of at least
 *	16 bits, long integers of at least 32 bits, and ignores
 *	overflows on adding or multiplying two unsigned integers.
 *	Two's-complement representation is assumed in a few places.
 *	Some extra masking is done if unsigneds are exactly 16 bits
 *	or longs are exactly 32 bits, but so what?
 *	An assembly-language implementation would run significantly faster.
 */

#define N	16
#define MASK	((unsigned)(1 << (N - 1)) + (1 << (N - 1)) - 1)
#define LOW(x)	((unsigned)(x) & MASK)
#define HIGH(x)	LOW((x) >> N)
#define MUL(x, y, z)	{ long l = (long)(x) * (long)(y); \
			    (z)[0] = LOW(l); (z)[1] = HIGH(l); }
#define CARRY(x, y)	((long)(x) + (long)(y) > MASK)
#define ADDEQU(x, y, z)	(z = CARRY(x, (y)), x = LOW(x + (y)))

#define X0	0x330E
#define X1	0xABCD
#define X2	0x1234
#define A0	0xE66D
#define A1	0xDEEC
#define A2	0x5
#define C	0xB

#define SET3(x, x0, x1, x2)	((x)[0] = (x0), (x)[1] = (x1), (x)[2] = (x2))
#define SEED(x0, x1, x2) (SET3(x, x0, x1, x2), SET3(a, A0, A1, A2), c = C)

static unsigned x[3] = { X0, X1, X2 }, a[3] = { A0, A1, A2 }, c = C;
static void next();

long int
lrand48()
{
  next();
  return (((long)x[2] << (N - 1)) + (x[1] >> 1));
}

void
srand48(long int seedval)
{
  SEED(X0, LOW(seedval), HIGH(seedval));
}

static void
next()
{
  unsigned p[2], q[2], r[2], carry0, carry1;

  MUL(a[0], x[0], p);
  ADDEQU(p[0], c, carry0);
  ADDEQU(p[1], carry0, carry1);
  MUL(a[0], x[1], q);
  ADDEQU(p[1], q[0], carry0);
  MUL(a[1], x[0], r);
  x[2] = LOW(carry0 + carry1 + CARRY(p[1], r[0]) + q[1] + r[1] +
	     a[0] * x[2] + a[1] * x[1] + a[2] * x[0]);
  x[1] = LOW(p[1] + r[0]);
  x[0] = LOW(p[0]);
}
#endif
