/************************************************
 *						*
 *	Back Propergation Simurator(BPS)	*
 *	      subroutine package		*
 *		Version 4.0			*
 *	  coded		in May.17 1989		*
 *	  last modified in Jul.3  1990		*
 *	  coded by	Y.Okamura		*
 *	  modified by 	K.Kuroda		*
 *						*
 *************************************************
 *						*
 *	filename wgtren.c			*
 *	    weight renew routine		*
 *						*
 ************************************************/
#include 	"BPS.h"
#include        "learn.h"


/**********************************************
** modifeid by higashi for Structure Learning *
**********************************************/
double structlearn(enableLay,enableUnit,enablePoint,tempWeight)
int enableLay;
int enableUnit;
ilin_t *enablePoint;
double *tempWeight;
{
  int lay,unit;
  ilin_t *link_pt; 
  double Var = 0.0;

  switch (bps_sp.StrLrnMode) {
  case 0:
    return Var;
  case PLAUT:
	  Var = - enablePoint->Weight;
    Var = Var * bps_sp.Ramuda;
    return Var;
  case ISHIKAWA:
    if(enablePoint->Weight < 0)
      Var = bps_sp.Ramuda;
    else
      Var = -bps_sp.Ramuda;
    return Var;
  case YASUI:
    lay=enableLay;
    unit = enableUnit;
    link_pt = Getintoplist(BPNet[lay][unit].CellNode);
    while (link_pt != NULL) {
      if(link_pt->Weight >0)
	Var += *tempWeight;
      else
	Var -= *tempWeight;
      link_pt = Getinfwdlist(link_pt);
      tempWeight ++;
    }
    if(enablePoint->Weight <0)
      Var = (Var + enablePoint->Weight)  * bps_sp.Ramuda;
    else     
      Var = -(Var - enablePoint->Weight) * bps_sp.Ramuda;
    return Var;
  }
    return Var;
}

/***********************************************
  make temp for Yasui structure learning
  modified by higashi
  *********************************************/
double *temp_wgt(lay,unit)
int lay;
int unit;
{
  double *startpoint;
  ilin_t *link_pt;
  int    count=0;
  
  link_pt = Getintoplist(BPNet[lay][unit].CellNode);
  while (link_pt != NULL){
    count ++;
    link_pt = Getinfwdlist(link_pt);
  }
  startpoint = (double *)malloc(sizeof(double)*count);
  count = 0;

  link_pt = Getintoplist(BPNet[lay][unit].CellNode);
  while (link_pt != NULL){
    startpoint[count] = link_pt->Weight;
    link_pt = Getinfwdlist(link_pt);
    count ++;
  }
  return startpoint;
}


/************************************************
  steep method
  ************************************************/

void
steep()
{
  int      lay, unit;
  ilin_t  *link_pt;

  for (lay = 0; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      link_pt = Getintoplist(BPNet[lay][unit].CellNode);
      while (link_pt != NULL) {
	link_pt->AdjWgt = LearnRate * link_pt->WgtWork;
	link_pt->Weight += link_pt->AdjWgt;
	link_pt = Getinfwdlist(link_pt);
      }
    }
  }
}


/************************************************
  momentum method
  ************************************************/
void
momentum1()
{
  int      lay, unit;
  ilin_t  *link_pt;
  double  *temp_yasui; /* modified by higashi*/

  for (lay = 0; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      link_pt = Getintoplist(BPNet[lay][unit].CellNode);
      temp_yasui =  temp_wgt(lay,unit);
      while (link_pt != NULL) {
	link_pt->AdjWgt = LearnRate * link_pt->WgtWork + Momentum * link_pt->AdjWgt;
	/*link_pt->Weight += link_pt->AdjWgt;*/

	/*modified by higashi */
	link_pt->Weight += link_pt->AdjWgt 
                + structlearn(lay,unit,link_pt,temp_yasui);

	link_pt = Getinfwdlist(link_pt);
      }
      free(temp_yasui);
    }
  }
}


/************************************************
  momentum rule
  ************************************************/
static void
basis_renew()
{
  int      lay, unit;
  ilin_t  *link_pt;

  for (lay = 0; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      link_pt = Getintoplist(BPNet[lay][unit].CellNode);
      while (link_pt != NULL) {
	link_pt->AdjWgt = LearnRate * link_pt->WgtWork + Momentum * link_pt->AdjWgt;
	link_pt->Weight += link_pt->AdjWgt;
	link_pt = Getinfwdlist(link_pt);
      }
    }
  }
}


/************************************************
  rejection
  ************************************************/
static void
reject()
{

  int      lay, unit;
  ilin_t  *link_pt;

  for (lay = 0; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      link_pt = Getintoplist(BPNet[lay][unit].CellNode);
      while (link_pt != NULL) {
	link_pt->Weight -= link_pt->AdjWgt;
	link_pt = Getinfwdlist(link_pt);
      }
    }
  }
}


/************************************************
  Vogl method
  ************************************************/
void
vogl()
{
  double  err1;

  basis_renew();
  workspace_initialize();
  err1 = set_learn(0);
  if ((err1 - SumOfErr) / SumOfErr > VoglThresh) {
    LearnRate *= ReductFact;
    Momentum = 0;
    reject();
  } else {
    LearnRate += IncreaseFact;
    Momentum = InitMoment;
  }
}

/************************************************
  Jacob's method
************************************************/
void
jacobs()
{
    int      lay, unit;
    double   nxt_adj;
    ilin_t  *link_pt;

    for (lay = 0; lay < NumOfLayer; lay++) {
	for (unit = 1; unit <= NumOfCell[lay]; unit++) {
	    link_pt = Getintoplist(BPNet[lay][unit].CellNode);
	    while (link_pt != NULL) {
		nxt_adj = (1.0 - InitMoment) * link_pt->WgtWork + InitMoment * link_pt->AdjWgt;
		if (nxt_adj * link_pt->AdjWgt > 0)
		    link_pt->CoefLearn += IncreaseFact;
		else {
		    if (nxt_adj * link_pt->AdjWgt < 0)
			link_pt->CoefLearn *= ReductFact;
		}
		link_pt->AdjWgt = nxt_adj;
		link_pt->Weight = link_pt->CoefLearn * link_pt->AdjWgt;
		link_pt = Getinfwdlist(link_pt);
	    }
	}
    }
}


/************************************************
  Vogl's coefficient
  ************************************************/
void
vgl2_coe()
{
  cel_t  *cur_cel;
  int     lay, n_sig_cnt, n_sig;

  n_sig = 0;
  VglCoef[NumOfLayer] = 1;
  for (lay = NumOfLayer - 1; lay >= 0; lay--) {
    cur_cel = BPNet[lay][1].CellNode;
    if (cur_cel->CharFunc == SIGMOID) {
      n_sig++;
      VglCoef[lay] = 1;
      for (n_sig_cnt = 1; n_sig_cnt <= n_sig; n_sig_cnt++) {
	VglCoef[lay] *= n_sig + n_sig_cnt;
	VglCoef[lay] /= n_sig_cnt;
      }
      VglCoef[lay] *= 2 * n_sig + 1;
    } else
      VglCoef[lay] = VglCoef[lay + 1];
  }
}


/************************************************
  momentum Vogl's coefficient method
************************************************/
void
momentum2()
{
    int      lay, unit;
    ilin_t  *link_pt;

    for (lay = 0; lay < NumOfLayer; lay++) {
	for (unit = 1; unit <= NumOfCell[lay]; unit++) {
	    link_pt = Getintoplist(BPNet[lay][unit].CellNode);
	    while (link_pt != NULL) {
		link_pt->AdjWgt = (VglCoef[lay]*LearnRate*(link_pt->WgtWork)
				   + Momentum * (link_pt->AdjWgt));
		link_pt->Weight += link_pt->AdjWgt;
		link_pt = Getinfwdlist(link_pt);
	    }
	}
    }
}


/*********************************************************************
 * Ochiai's method
 *********************************************************************/
void
Ochi()
{
  int      lay, unit;
  double   delta, cof, norm;
  ilin_t  *link_pt;
  double  *temp_yasui;
  for (lay = 0; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      link_pt = Getintoplist(BPNet[lay][unit].CellNode);
      while (link_pt != NULL) {
	if (link_pt->dltold * (-link_pt->WgtWork) > 0.0)
	  link_pt->CoefLearn += IncreaseFact;
	else {
	  if (link_pt->dltold * (-link_pt->WgtWork) < 0.0)
	    link_pt->CoefLearn *= ReductFact;
	}
	link_pt->dltold = (1.0 - Theta) * (-link_pt->WgtWork)
	  + Theta * link_pt->dltold;
	link_pt = Getinfwdlist(link_pt);
      }
    }
  }

  cof = 0.0;
  for (lay = 0; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      /* modified by higashi for Yasui structure learning */
      temp_yasui =  temp_wgt(lay,unit);
      /*   end of modified     oct 1999                   */
      link_pt = Getintoplist(BPNet[lay][unit].CellNode);
      while (link_pt != NULL) {
	link_pt->dltwgtold = link_pt->AdjWgt;

	link_pt->Weight += link_pt->AdjWgt
	  = link_pt->CoefLearn * link_pt->WgtWork
	    + Momentum * link_pt->dltwgtold;
	
	link_pt->Weight += structlearn(lay,unit,link_pt,temp_yasui); /* modified by higshi*/

	link_pt->dltwork = -link_pt->WgtWork - link_pt->wgtworkold;
	link_pt->wgtworkold = -link_pt->WgtWork;
	cof += link_pt->dltworkold * link_pt->dltwork;
	link_pt->dltworkold = link_pt->dltwork;
	link_pt = Getinfwdlist(link_pt);
      }
      free(temp_yasui);
    }
  }

  if (cof < 0.0) {
    cof = norm = 0.0;
    for (lay = 0; lay < NumOfLayer; lay++) {
      for (unit = 1; unit <= NumOfCell[lay]; unit++) {
	link_pt = Getintoplist(BPNet[lay][unit].CellNode);
	while (link_pt != NULL) {
	  cof -= link_pt->dltwork * link_pt->AdjWgt;
	  norm += link_pt->dltwork * link_pt->dltwork;
	  link_pt = Getinfwdlist(link_pt);
	}
      }
    }

    cof = cof / (2.0 * norm);

    for (lay = 0; lay < NumOfLayer; lay++) {
      for (unit = 1; unit <= NumOfCell[lay]; unit++) {
	link_pt = Getintoplist(BPNet[lay][unit].CellNode);
	while (link_pt != NULL) {
	  link_pt->AdjWgt += delta
	    = cof * link_pt->dltwork;
	  link_pt->Weight += delta;
	  link_pt = Getinfwdlist(link_pt);
	}
      }
    }
  }
}
