/************************************************
*						*
*	Back Propergation Simulator(BPS)	*
*	      subroutine package		*
*	  coded 	in Sep.7 1990		*
*	  coded by	K.Kuroda		*
*						*
*************************************************
*						*
*	filename actload.c			*
*	   BPS ACTLOAD command			*
*						*
************************************************/
#include "BPS.h"
#include "loadlib.h"

/************************************************
	load data from result file
************************************************/
int
main()
{
  int           idx[MAX_INDEX];
  int           i, j;

  int           unit_num_int, patt_num_int;
  char          patt_num_char, unit_num_char;

  Header        header;
  float        *dum;
  Buffer       *Data;
  unsigned int  bufsiz;

  read_syscom();
  rebps();

  /* Get Arguments from SATELLITE Language */
  patt_num_char =      *GetString(0);
  patt_num_int  = (int) GetScalar(0);
  unit_num_char =      *GetString(1);
  unit_num_int  = (int) GetScalar(1);
  strcpy(FileName, GetString(2));

  switch (patt_num_char) {
  case 'X': case 'x': 

    if ((unit_num_char == 'y') || (unit_num_char == 'Y')) {
      if (LoadHeader(FileName, &header) == -1) exit(11);

      idx[0] = header.index[1]; /*  data point    */
      idx[1] = header.index[0]; /*  time(record)  */
      bufsiz = IndexSize(2, idx);
      Data = AllocBuffer(bufsiz);

      message_2d_before(idx);
      for (i = 0; i < idx[0]; i++) {
	for (j = 0; j < idx[1]; j++) {
	  dum = (float*)LoadData(FileName, j, &header);
	  if (dum==(float*)NULL) exit(13); /*### suzu ### */
	  *(Data+i*idx[1]+j) = (double)dum[i];
	  free(dum);
	}
	message_2d_after(i, "ACTIVATION");
      }
      printf("\n");
      ReturnSnapshot(Data, 2, idx);
      free(Data);

    } else {

      if (LoadHeader(FileName, &header) == -1) exit(11);
      if (unit_num_int < 1)
	exit(130);
      if (unit_num_int > header.index[1])
	exit(130);

      Data = AllocBuffer(header.index[0]);

      for (i = 0; i < header.index[0]; i++) {
	dum = (float*)LoadData(FileName, i, &header);
	if(dum==(float*)NULL) exit(13);	/*### suzu ### */
	Data[i] = (double)dum[unit_num_int - 1];
	free(dum);
      }
      message_1d_after("ACTIVATION");
      ReturnSnapshot(Data, 1, header.index);
      free(Data);
    }
    break;

  case 'y':
  case 'Y':
    if ((unit_num_char != 'x') && (unit_num_char != 'X'))
      exit(130);
    if (LoadHeader(FileName, &header) == -1) exit(11);
	
    idx[0] = header.index[0];
    idx[1] = header.index[1];
    message_2d_before(idx);

    bufsiz = IndexSize(2, idx);
    Data = AllocBuffer(bufsiz);

    for (i = 0; i < idx[0]; i++){
      dum = (float*)LoadData(FileName, i, &header);
      if(dum==(float*)NULL) exit(13); /*### suzu ### */
      for(j=0; j < idx[1]; j++){
	*(Data+i*idx[1]+j) = (double)dum[j];
      }
      message_2d_after(i, "ACTIVATION");
      free(dum);
    }
    ReturnSnapshot(Data, 2, idx);
    free(Data);
    printf("\n");
    break;

  default:
    if (LoadHeader(FileName, &header) == -1) exit(11);
    if ((patt_num_int < 1) && (patt_num_int > header.index[0]))
      exit(132);

    if ((unit_num_char == 'x') || (unit_num_char == 'X')) {
	    
      idx[0] = header.index[1];
      Data = AllocBuffer((unsigned int)header.index[1]);
      dum = (float*)LoadData(FileName, patt_num_int - 1, &header);
      if(dum==(float*)NULL) exit(13); /*### suzu ### */
      for(i=0; i<header.index[1]; i++){
	Data[i] = (double)dum[i];
      }
      ReturnSnapshot(Data, 1, idx);
      message_1d_after("ACTIVATION");
      free(Data);
      free(dum);
    }

    else {
      if (unit_num_int < 1)
	exit(130);
      if (unit_num_int > header.index[1])
	exit(130);

      idx[0] = 1;
      Data = AllocBuffer((unsigned)1);
      dum = (float*)LoadData(FileName, patt_num_int - 1, &header);
      if(dum==(float*)NULL) exit(13); /*### suzu ### */
      Data[0] = dum[unit_num_int - 1];
      message_1d_after("ACTIVATION");
      ReturnSnapshot(Data, 1, idx);
      free(Data);
      free(dum);
    }
  }

  wrbps();
  write_syscom();
  return 0;
}
