/************************************************
 *						*
 *	Back Propergation Simurator(BPS)	*
 *	      subroutine package		*
 *	  coded		in Aug.27 1990		*
 *	  coded by	K.Kuroda		*
 *						*
 *************************************************
 *						*
 *	filename errload.c			*
 * 	   BPS ERRLOAD command			*
 *						*
 ************************************************/
#include "BPS.h"
#include "loadlib.h"

static int  idx[MAX_INDEX];

/***********************************************
  load data from error file
  ***********************************************/
int
main()
{
  int      i, j, unum, hist_num, num_rec;
  char     iteration, unit_num;
  int      p_unum, p_hist_num;
  Header   header;
  Buffer  *Data;
  float   *dum;
  int      bufsiz;

  read_syscom();
  rebps();

  /* Get Arguments from SATELLITE Language */
  p_hist_num = (int)GetScalar(0);
  p_unum     = (int)GetScalar(1);

  iteration  =     *GetString(0);
  unit_num   =     *GetString(1);
  strcpy(FileName, GetString(2));

  GetStructureParameters();
  GetLearningParameters();

  if (ErrStorDirection == DATAPOINT) {
    if ((iteration == 'x') || (iteration == 'X')) {
      if ((unit_num != 's') && (unit_num != 'S'))
	exit(130);
      if (LoadHeader(FileName, &header) == -1) exit(11);

      dum = (float*)ReadFile(FileName, &header);
      printf("header.index[0] = %d\n",header.index[0]);
      printf("header.index[1] = %d\n",header.index[1]);
      if(header.index[0] != 1) exit(130); /* ### suzu ### ErrNo ?? */
      Data = (Buffer*)AllocBuffer(header.index[1]);
	    
      for(i=0; i<header.index[1]; i++)
	Data[i] = (double)dum[i];
		
      message_1d_after("ERROR");

      idx[0] = header.index[1];
      ReturnSnapshot(Data, 1, idx);
      free(dum);
      free(Data);
    } else {
      hist_num = p_hist_num;
      if ((unit_num != 's') && (unit_num != 'S'))
	exit(130);
      if (LoadHeader(FileName, &header) == -1) exit(11);

      dum = (float*)ReadFile(FileName, &header);
      Data = AllocBuffer(1);
      Data[0] = (double)dum[hist_num - 1];
	    
      idx[0] = 1;
      ReturnSnapshot(Data, 1, idx);
      message_1d_after("ERROR");
      free(dum);
      free(Data);
    }
  } 

  else {			/*  ErrStorDirection ==>  Record    */
    if (ErrStorMode == APPEND) {
      if ((iteration == 'x') || (iteration == 'X')) {
	if ((unit_num == 'y') || (unit_num == 'Y')) {
	  if (LoadHeader(FileName, &header) == -1) exit(11);

	  idx[0] = header.index[1];
	  idx[1] = header.index[0];

	  message_2d_before(idx);
	  dum = (float*)ReadFile(FileName, &header);
	  Data = AllocBuffer(IndexSize(2, idx));

	  for(i=0; i<idx[0]; i++){
	    for(j=0; j<idx[1]; j++){
	      *(Data+i*idx[1]+j) = (double)*(dum+j*idx[0]+i);
	    }
	    message_2d_after(i, "ERROR");
	  }
	  ReturnSnapshot(Data, 2, idx);
	  free(dum);
	  free(Data);
	  printf("\n");
	} 

	else {			/* Record APPEND   iteration == X   */

	  if ((unit_num == 's') || (unit_num == 'S')) {
	    unum = NumOfCell[NumOfLayer - 1] + 1;
	    printf("unit_num = s\n");
			
	  } else {
	    unum = p_unum;
	    if ((unum < 0) || (unum > NumOfCell[NumOfLayer - 1]))
	      exit(130);
	  }

	  if (LoadHeader(FileName, &header) == -1) exit(11);
	  dum = (float*)ReadFile(FileName, &header);
	  idx[0] = header.index[0];
	  Data = AllocBuffer(IndexSize(1, idx));

	  for(i=0; i<header.index[0]; i++){
	    *(Data+i) = *(dum+i*header.index[1]+unum-1);
	  }
	  message_1d_after("ERROR");
	  ReturnSnapshot(Data, 1, idx);
	  free(dum);
	  free(Data);
	}

      } else {			/* APPEND */
	if ((iteration == 'y') || (iteration == 'Y')) {
	  if ((unit_num != 'x') && (unit_num != 'X'))
	    exit(130);
	  if (LoadHeader(FileName, &header) == -1) exit(11);

	  idx[0] = header.index[0];
	  idx[1] = header.index[1];

	  message_2d_before(idx);
	  dum = (float*)ReadFile(FileName, &header);
	  Data = AllocBuffer(IndexSize(2, idx));

	  bufsiz = IndexSize(2, idx);
	  for(i=0; i<bufsiz; i++){
	    Data[i] = (double)dum[i];
	  }
	  message_2d_after(idx[0], "ERROR");
	  printf("\n");
	  ReturnSnapshot(Data, 2, idx);
	  free(dum);
	  free(Data);
	} 
	else {			/* iteration != X or Y */ 
	  hist_num = p_hist_num;
	  if (LoadHeader(FileName, &header) == -1) exit(11);
	  num_rec = header.index[0];

	  if ((hist_num < 1) || (hist_num > num_rec))
	    exit(130);
	  if ((unit_num == 'x') || (unit_num == 'X')) {

	    idx[0] = header.index[0];
	    dum = (float*)LoadData(FileName, hist_num - 1, &header);
	    Data = AllocBuffer(IndexSize(1, idx));
	    for(i=0; i<idx[0]; i++){
	      Data[i] = (double)dum[i];
	    }
	    ReturnSnapshot(Data, 1, idx);
	    free(dum);
	    free(Data);
	    message_1d_after("ERROR");

	  } else {
	    if ((unit_num == 's') || (unit_num == 'S')) {
	      unum = NumOfCell[NumOfLayer - 1] + 1;
	    } else {
	      unum = p_unum;
	      if ((unum < 0) || (unum > NumOfCell[NumOfLayer - 1]))
		exit(130);
	    }
	    idx[0] = 1;
	    if (LoadHeader(FileName, &header) == -1) exit(11);
	    dum = (float*)LoadData(FileName, hist_num - 1, &header);
	    Data = AllocBuffer(IndexSize(1, idx));
	    Data[0] = (double)dum[unum - 1];
	    message_1d_after("ERROR");
	    ReturnSnapshot(Data, 1, idx);
	    free(dum);
	    free(Data);
	  }
	}
      }
    } else {
      if (ErrStorMode == OVERWRITE) {
	hist_num = p_hist_num;
	if (hist_num != 1)
	  exit(131);
	if ((unit_num == 'x') || (unit_num == 'X')) {
	  if (LoadHeader(FileName, &header) == -1) exit(11);

	  idx[0] = header.index[1];
	  dum = (float*)LoadData(FileName, 0, &header);
	  Data = AllocBuffer(IndexSize(1, idx));
		    
	  for(i=0; i<idx[0]; i++){
	    Data[i] = (double)dum[i];
	  }
	  message_1d_after("ERROR");
	  ReturnSnapshot(Data, 1, idx);
	  free(dum);
	  free(Data);

	} else {
	  if ((unit_num == 's') || (unit_num == 'S')) {
	    unum = NumOfCell[NumOfLayer - 1] + 1;
	  } else {
	    unum = p_unum;
	    if ((unum < 0) || (unum > NumOfCell[NumOfLayer - 1]))
	      exit(130);
	  }
	  if (LoadHeader(FileName, &header) == -1) exit(11);

	  idx[0] = 1;
	  dum = (float*)LoadData(FileName, 0, &header);
	  Data = AllocBuffer(IndexSize(1, idx));
	  Data[0] = (double)dum[unum - 1];
	  message_1d_after("ERROR");
	  ReturnSnapshot(Data, 1, idx);
	  free(dum);
	  free(Data);
	}
      } else
	exit(202);
    }
  }

  wrbps();
  write_syscom();
  return 0;
}
