/************************************************
 *						*
 *	Back Propergation Simulator(BPS)	*
 *	      subroutine package		*
 *	  coded 	in Sep.1  1990		*
 *	  last modified	in Nov.15 1990		*
 *	  coded by	K.Kuroda		*
 *						*
 *************************************************
 *						*
 *	filename wgtload.c			*
 *	   BPS WGTLOAD command			*
 *						*
 ************************************************/
#include "BPS.h"
#include "loadlib.h"

int      lay_num;
int      wgt_number[HBUFSIZE];

/************************************************
  bias check
  append : 0
  no append : 1
  ************************************************/
int
isbias_r(laynum)
     int  laynum;
{
  if (CheckBias(laynum))
    return (0);
  else
    return (1);
}


/************************************************
  count weight number
  ************************************************/
int
wnum1(unum)
     int   unum;
{
  int   i, j, k, wgt_cnt;

  wgt_cnt = 0;

  for (i = 1; i < NumOfLayer; i++) {
    for (j = 1; j <= NumOfCell[i]; j++) {
      if ((lay_num == (i - 1)) && (unum == j))
	return (wgt_cnt);
      if (CheckBias(i))
	wgt_cnt++;
      for (k = 1; k <= NumOfCell[i - 1]; k++)
	wgt_cnt++;
    }
  }
  return 0;
}


/************************************************
  count weight number
  ************************************************/
void
wnum2(unum)
     int  unum;
{
  int   i, j, k, l, wgt_cnt;

  l = 0;
  wgt_cnt = 0;

  for (i = 1; i < NumOfLayer; i++) {
    for (j = 1; j <= NumOfCell[i]; j++) {
      if ((lay_num == (i - 1)) && (unum == 0))
	wgt_number[l++] = wgt_cnt;
      if (CheckBias(i))
	wgt_cnt++;
      for (k = 1; k <= NumOfCell[i - 1]; k++) {
	if ((lay_num == (i - 1)) && (unum == k))
	  wgt_number[l++] = wgt_cnt;
	wgt_cnt++;
      }
    }
  }
}


/************************************************
  count weight number
  ************************************************/
int
wnum3(unum1, unum2)
     int unum1, unum2;
{
  int             i, j, k, wgt_cnt;

  wgt_cnt = 0;

  for (i = 1; i < NumOfLayer; i++) {
    for (j = 1; j <= NumOfCell[i]; j++) {
      if ((lay_num == (i - 1)) && (unum1 == 0) && (unum2 == j))
	return (wgt_cnt);
      if (CheckBias(i))
	wgt_cnt++;
      for (k = 1; k <= NumOfCell[i - 1]; k++) {
	if ((lay_num == (i - 1)) && (unum1 == k) && (unum2 == j))
	  return (wgt_cnt);
	wgt_cnt++;
      }
    }
  }
  return 0;
}


/************************************************
  load data from weight file
  ************************************************/
int
main()
{
  int     nargs;
  int     idx[10];
  int     p_int6;
  int     i, j, k, iterat_int, unum1, unum2, wgt_num;
  int     bias_flg1, bias_flg2;
  char    iterat_char, unit_num1, unit_num2;
  float   *dum;
  Buffer  *Data;
  Header  header;

  read_syscom();
  rebps();

  GetStructureParameters();
  GetLearningParameters();
  SetNumOfLink();

  /* Get Arguments from SATELLITE Language */
  nargs       =      GetArgNum();
  iterat_char =     *GetString(0);
  iterat_int  = (int)GetScalar(0);
  lay_num     = (int)GetScalar(1);
  unit_num1   =     *GetString(2);
  unum1       = (int)GetScalar(2);
  unit_num2   =     *GetString(3);
  unum2       = (int)GetScalar(3);
  strcpy(FileName, GetString(4));
  p_int6      = GetScalar(5);

  if (nargs == 6) {
    if (p_int6 == 1) {
      bias_flg1 = 1;
      bias_flg2 = 0;
    } else
      exit(133);
  } else {
    bias_flg1 = 0;
    bias_flg2 = 1;
  }
  if ((lay_num < -1) || (lay_num > (NumOfLayer - 1)))
    exit(134);

  /*    Data = buff_alloc();  */
  /*    block_size();         */

  /*    syscom.buff_leng = HBUFSIZE;  */

  /* may be does not require. take */
  /*  write_syscom(); */

  switch (WgtStorMode) {
  case APPEND:
    switch (iterat_char) {
    case 'x':
    case 'X':
      if ((unit_num1 == 'y') || (unit_num1 == 'Y')) {
	if ((unum2 < 1) || (unum2 > NumOfCell[lay_num + 1]))
	  exit(130);

	if (LoadHeader(FileName, &header) == -1) exit(11);

	idx[0] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	idx[1] = header.index[0] - 1;

	wgt_num = wnum1(unum2) + CheckBias(lay_num + 1) * bias_flg2;
	message_2d_before(idx);

	Data = AllocBuffer(IndexSize(2, idx));
	for (i = 0; i < idx[1]; i++) {
	  dum = (float*)LoadData(FileName, i, &header);
	  for (j = 0; j < idx[0]; j++){
	    *(Data+j*idx[1]+i) = (double)dum[j + wgt_num];
	  }
	  free(dum);
	  message_2d_after(idx[0] - 1 , "WEIGHT");
	}
	ReturnSnapshot(Data, 2, idx);
	free(Data);
	printf("\n");

      } else {	/* iterate = X, APPEND, unix_num1 != Y  */
	if ((unum1 < isbias_r(lay_num + 1)) || (unum1 > NumOfCell[lay_num]))
	  exit(130);
	if ((unit_num2 == 'y') || (unit_num2 == 'Y')) {

	  if (LoadHeader(FileName, &header) == -1) exit(11);

	  idx[0] = NumOfCell[lay_num + 1];
	  idx[1] = header.index[0] - 1;
	  wnum2(unum1);

	  message_2d_before(idx);

	  Data = AllocBuffer(IndexSize(2, idx));
	  for (i = 0; i < idx[1]; i++) {
	    dum = (float*)LoadData(FileName, i, &header);
	    for (j = 0; j < idx[0]; j++){
	      *(Data+j*idx[1]+i) = (double)dum[wgt_number[j]];
	    }
	    free(dum);
	  }
	  message_2d_after(idx[1] - 1 , "WEIGHT");
	  ReturnSnapshot(Data, 2, idx);
	  free(Data);
	  printf("\n");

	} else {/* iterate = X, APPEND, unit_num1 != Y,  unit_num2 != Y */
	  if ((unum2 < 1) || (unum2 > NumOfCell[lay_num + 1]))
	    exit(130);
	  if (LoadHeader(FileName, &header) == -1) exit(11);

	  wgt_num = wnum3(unum1, unum2);
	  idx[0] = header.index[0] - 1;
	  Data = AllocBuffer(IndexSize(1, idx));
	  for (i = 0; i < idx[0]; i++) {
	    dum = (float*)LoadData(FileName, i, &header);

	    Data[i] = (double)dum[wgt_num];
	    free(dum);
	  }
	  ReturnSnapshot(Data, 1, idx);
	  free(Data);
	  message_1d_after("WEIGHT");
	}
      }
      break;

    case 'y':
    case 'Y':
      if ((unit_num1 == 'x') || (unit_num1 == 'X')) {
	if ((unum2 < 1) || (unum2 > NumOfCell[lay_num + 1]))
	  exit(130);
	if (LoadHeader(FileName, &header) == -1) exit(11);

	idx[0] = header.index[0] - 1;
	idx[1] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	wgt_num = wnum1(unum2) + CheckBias(lay_num + 1) * bias_flg2;

	message_2d_before(idx);

	Data = AllocBuffer(IndexSize(2, idx));
	for (i = 0; i < idx[0]; i++) {
	  dum = (float*)LoadData(FileName, i, &header);
	  for (j = 0; j < idx[1]; j++)
	    *(Data+j+i*idx[1]) = (double)dum[j + wgt_num];
	  free(dum);
	  message_2d_after(i, "WEIGHT");
	}
	ReturnSnapshot(Data, 2, idx);
	free(Data);
	printf("\n");

      } else {
	if ((unum1 < isbias_r(lay_num + 1)) || (unum1 > NumOfCell[lay_num]))
	  exit(130);
	if ((unit_num2 != 'x') && (unit_num2 != 'X'))
	  exit(130);
	if (LoadHeader(FileName, &header) == -1) exit(11);

	idx[0] = header.index[0] - 1;
	idx[1] = NumOfCell[lay_num + 1];
	wnum2(unum1);

	Data = AllocBuffer(IndexSize(2, idx));
	message_2d_before(idx);
	for (i = 0; i < idx[0]; i++) {
	  dum = (float*)LoadData(FileName, i, &header);
	  for (j = 0; j < idx[1]; j++)
	    *(Data+j+i*idx[1]) = (double)dum[wgt_number[j]];
	  free(dum);
	  message_2d_after(i, "WEIGHT");
	}
	ReturnSnapshot(Data, 2, idx);
	free(Data);
	printf("\n");
      }
      break;

    default:			/* iterat != Y/N , APPEND */
      if (iterat_int < 0)
	exit(131);
      switch (unit_num1) {
      case 'x':
      case 'X':
	if ((unit_num2 == 'y') || (unit_num2 == 'Y')) {

	  if (LoadHeader(FileName, &header) == -1) exit(11);
	  if (iterat_int == 0)
	    iterat_int = header.index[0] - 1;
	  if (iterat_int > header.index[0])
	    exit(131);

	  idx[0] = NumOfCell[lay_num + 1];
	  idx[1] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	  wgt_num = wnum1(1) + CheckBias(lay_num + 1) * bias_flg2;

	  message_2d_before(idx);

	  dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	  Data = AllocBuffer(IndexSize(2, idx));
	  k = wgt_num;
		    
	  for (i = 0; i < idx[0]; i++) {
	    for (j = 0; j < idx[1]; j++)
	      *(Data+j+i*idx[1]) = (double)dum[k++];
	    k += CheckBias(lay_num + 1) * bias_flg2;
	    message_2d_after(i, "WEIGHT");
	    free(dum);
	  }
	  ReturnSnapshot(Data, 2, idx);
	  free(Data);
	  printf("\n");

	} else {		/* iterat != Y/N , APPEND , unit_num1 = X  */
	  if ((unum2 < 1) || (unum2 > NumOfCell[lay_num + 1]))
	    exit(130);
	  if (LoadHeader(FileName, &header) == -1) exit(11);
	  if (iterat_int == 0)
	    iterat_int = header.index[0] - 1;
	  if (iterat_int > header.index[0])
	    exit(131);

	  wgt_num = wnum1(unum2) + CheckBias(lay_num + 1) * bias_flg2;
		    
	  idx[0] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	  dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	  Data = AllocBuffer(IndexSize(1, idx));
		    
	  for (i = 0; i < idx[0]; i++){
	    Data[i] = (double)dum[i + wgt_num]; 
	  }
	  message_1d_after("WEIGHT");
	  ReturnSnapshot(Data, 1, idx);
	  free(dum);
	  free(Data);
	}
	break;

      case 'y':			/* iterat != Y/N , unit_num1 == Y , APPEND */
      case 'Y':
	if ((unit_num2 != 'x') && (unit_num2 != 'X'))
	  exit(130);
	if (LoadHeader(FileName, &header) == -1) exit(11);
	if (iterat_int == 0)
	  iterat_int = header.index[0] - 1;
	if (iterat_int > header.index[0])
	  exit(131);

	idx[0] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	idx[1] = NumOfCell[lay_num + 1];
	wgt_num = wnum1(1) + CheckBias(lay_num + 1) * bias_flg2;

	message_2d_before(idx);

	Data = AllocBuffer(IndexSize(2, idx));
	k = wgt_num;
	dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	for (i = 0; i < idx[1]; i++) {
	  for (j = 0; j < idx[0]; j++)
	    *(Data+j*idx[1]+i) = dum[k++];
	  k += CheckBias(lay_num + 1) * bias_flg2;
	}
	message_2d_after(idx[0] - 1, "WEIGHT");
	ReturnSnapshot(Data, 2, idx);
	free(dum);
	free(Data);
	printf("\n");
	break;

      default:			/* iterat != Y/N , unit_num1 != X/Y , APPEND */
	if ((unum1 < isbias_r(lay_num + 1)) || (unum1 > NumOfCell[lay_num]))
	  exit(130);
	if ((unit_num2 == 'x') || (unit_num2 == 'X')) {
	  if (LoadHeader(FileName, &header) == -1) exit(11);
	  if (iterat_int == 0)
	    iterat_int = header.index[0] - 1;
	  if (iterat_int > header.index[0])
	    exit(131);

	  idx[0] = NumOfCell[lay_num + 1];
	  wnum2(unum1);

	  Data = AllocBuffer(IndexSize(1, idx));
	  dum = (float*)LoadData(FileName, iterat_int - 1, &header);

	  for (i = 0; i < idx[0]; i++)
	    Data[i] = (double)dum[wgt_number[i]]; 

	  message_1d_after("WEIGHT");
	  ReturnSnapshot(Data, 1, idx);
	  free(Data);
	  free(dum);

	} else {
	  if ((unum2 < 1) || (unum2 > NumOfCell[lay_num + 1]))
	    exit(130);
	  if (LoadHeader(FileName, &header) == -1) exit(11);
	  if (iterat_int == 0)
	    iterat_int = header.index[0] - 1;
	  if (iterat_int > header.index[0])
	    exit(131);

	  wgt_num = wnum3(unum1, unum2);

	  idx[0] = 1;
	  dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	  Data = AllocBuffer(IndexSize(1, idx));

	  Data[0] = (double)dum[wgt_num];
	  ReturnSnapshot(Data, 1, idx);
	  message_1d_after("WEIGHT");
	  free(dum);
	  free(Data);
	}
      }
      break;
    }
    break;

  case OVERWRITE:
    if ((iterat_int != 1) && (iterat_int != 2))
      exit(131);
    switch (unit_num1) {
    case 'x':
    case 'X':
      if ((unit_num2 == 'y') || (unit_num2 == 'Y')) {
	if (LoadHeader(FileName, &header) == -1) exit(11);

	idx[0] = NumOfCell[lay_num + 1];
	idx[1] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	wgt_num = wnum1(1) + CheckBias(lay_num + 1) * bias_flg2;

	message_2d_before(idx);
	k = wgt_num;
	Data = AllocBuffer(IndexSize(2, idx));
	for (i = 0; i < idx[0]; i++) {
	  dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	  for (j = 0; j < idx[1]; j++)
	    *(Data+i*idx[1]+j) = (double)dum[k++];
	  k += CheckBias(lay_num + 1) * bias_flg2;
	  free(dum);
	  message_2d_after(i, "WEIGHT");
	}
	ReturnSnapshot(Data, 2, idx);
	free(Data);
	printf("\n");

      } else {
	if ((unum2 < 1) && (unum2 > NumOfCell[lay_num + 1]))
	  exit(130);
	if (LoadHeader(FileName, &header) == -1) exit(11);

	wgt_num = wnum1(unum2) + CheckBias(lay_num + 1) * bias_flg2;

	dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	idx[0] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
	Data = AllocBuffer(IndexSize(1, idx));
	for (i = 0; i < idx[0]; i++)
	  Data[i] = (double)dum[i + wgt_num];

	message_1d_after("WEIGHT");
	ReturnSnapshot(Data, 1, idx);
	free(dum);
	free(Data);
      }
      break;

    case 'y':
    case 'Y':			/* unit_num1 == Y , Overwrite */
      if ((unit_num2 != 'x') && (unit_num2 != 'X'))
	exit(130);
      if (LoadHeader(FileName, &header) == -1) exit(11);

      idx[0] = NumOfCell[lay_num] + CheckBias(lay_num + 1) * bias_flg1;
      idx[1] = NumOfCell[lay_num + 1];
      wgt_num = wnum1(1) + CheckBias(lay_num + 1) * bias_flg2;

      message_2d_before(idx);

      dum = (float*)LoadData(FileName, iterat_int - 1, &header);
      Data = AllocBuffer(IndexSize(2, idx));
      k = wgt_num;
      for (i = 0; i < idx[1]; i++) {
	for (j = 0; j < idx[0]; j++)
	  *(Data+j*idx[1]+i) = (double)dum[k++];
	k += CheckBias(lay_num + 1) * bias_flg2;
      }
      message_2d_after(idx[0] - 1 , "WEIGHT");

      ReturnSnapshot(Data, 2, idx);
      free(Data);
      free(dum);
      printf("\n");
      break;

    default:			/* unit_num1 != X/Y , Overwrite  */
      if ((unum1 < isbias_r(lay_num + 1)) || (unum1 > NumOfCell[lay_num]))
	exit(130);
      if ((unit_num2 == 'x') || (unit_num2 == 'X')) {
	if (LoadHeader(FileName, &header) == -1) exit(11);

	idx[0] = NumOfCell[lay_num + 1];

	wnum2(unum1);

	dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	Data = AllocBuffer(IndexSize(1, idx));
	for (i = 0; i < idx[0]; i++)
	  Data[i] = (double)dum[wgt_number[i]];

	message_1d_after("WEIGHT");
	ReturnSnapshot(Data, 1, idx);
	free(dum);
	free(Data);
      } else {
	if ((unum2 < 1) || (unum2 > NumOfCell[lay_num + 1]))
	  exit(130);

	if (LoadHeader(FileName, &header) == -1) exit(11);
	wgt_num = wnum3(unum1, unum2);

	dum = (float*)LoadData(FileName, iterat_int - 1, &header);
	idx[0] = 1;
	Data = AllocBuffer(IndexSize(1, idx));
	Data[0] = (double)dum[wgt_num];

	message_1d_after("WEIGHT");
	ReturnSnapshot(Data, 1, idx);
	free(dum);
	free(Data);
      }
    }
    break;

  default:
    exit(202);
  }

  wrbps();
  write_syscom();
  return 0;
}
