/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename bpload.c                       *
*           BPS BPLOAD command                  *
*                                               *
************************************************/

#include  "BPS.h"

#define	MAX	100

void
check_exten(str)
     register char  *str;
{
  for (; *str != 0; str++) {
    if (*str == '.')
      return;
  }
  strcat(str, ".prm");
}


/***********************************************
  load parameters
  ************************************************/
int
main()
{
  register int    i;
  char            filename[FILE_LENGTH], rem[MAX], func_bias[MAX_LAYER][5];
  char            init_algo, stor_mode, stor_dir, learn_mode, *str;
  int             lay_no;
  FILE           *fp;

  read_syscom();
  rebps();

  str = GetString(0);
  strcpy(filename, str);
  check_exten(filename);
  if ((fp = fopen(filename, "r")) == NULL)
    exit(203);

  /* FOR NETWORK STRUCTURE */
  fscanf(fp, "%d", &bps_sp.NumOfLayer);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.NumOfCell[0]);
  for (lay_no = 1; lay_no < bps_sp.NumOfLayer; lay_no++)
    fscanf(fp, ",%d", &bps_sp.NumOfCell[lay_no]);
  fgets(rem, MAX, fp);

  fscanf(fp, "%2s", func_bias[0]);
  for (lay_no = 1; lay_no < bps_sp.NumOfLayer; lay_no++)
    fscanf(fp, ",%2s", func_bias[lay_no]);
  for (lay_no = 0; lay_no < bps_sp.NumOfLayer; lay_no++) {
    for (i = 0; i < 2; i++)
      func_bias[lay_no][i] = toupper(func_bias[lay_no][i]);
    if ((strcmp("LN", func_bias[lay_no]) && strcmp("LA", func_bias[lay_no]) &&
	 strcmp("SN", func_bias[lay_no]) && strcmp("SA", func_bias[lay_no])) != 0)
      exit(208);
    strcpy(bps_sp.FuncBias[lay_no], func_bias[lay_no]);
  }
  fgets(rem, MAX, fp);


  /* FOR INITIALIZE */
  fscanf(fp, "%c", &init_algo);
  init_algo = toupper(init_algo);
  if ((init_algo != JIA) && (init_algo != RANDUM))
    exit(210);
  bps_sp.InitAlgo = init_algo;
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_sp.InitWgtFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.Seed);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.MaxInitWgt);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.MinInitWgt);
  fgets(rem, MAX, fp);


  /* FOR LEARNING */
  fscanf(fp, "%s", bps_sp.LrnInitWgtFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_sp.WgtHistoryFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.WgtStorInterval);
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &stor_mode);
  stor_mode = toupper(stor_mode);
  if ((stor_mode != APPEND) && (stor_mode != OVERWRITE))
    exit(202);
  bps_sp.WgtStorMode = stor_mode;
  fgets(rem, MAX, fp);

  fscanf(fp, "%s", bps_sp.ErrHistoryFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.ErrStorInterval);
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &stor_dir);
  stor_dir = toupper(stor_dir);
  if ((stor_dir != RECORD) && (stor_dir != DATAPOINT))
    exit(201);
  bps_sp.ErrStorDirection = stor_dir;
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &stor_mode);
  stor_mode = toupper(stor_mode);
  if ((stor_mode != APPEND) && (stor_mode != OVERWRITE))
    exit(202);
  bps_sp.ErrStorMode = stor_mode;
  fgets(rem, MAX, fp);

  fscanf(fp, "%s", bps_sp.InputFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_sp.TeachFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.LrnFirstPtrn);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.LrnLastPtrn);
  fgets(rem, MAX, fp);

  fscanf(fp, "%c", &learn_mode);
  learn_mode = toupper(learn_mode);
  if ((learn_mode != SET_LEARN) && (learn_mode != PATTERN_LEARN))
    exit(202);
  bps_sp.LearnMode = learn_mode;
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &bps_sp.LearnAlgo);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.LearnRate);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.Momentum);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.IncreaseFact);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.ReductFact);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.VoglThresh);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.Theta);
  fgets(rem, MAX, fp);

  fscanf(fp, "%lf", &bps_sp.MinError);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.MaxLearnCount);
  fgets(rem, MAX, fp);

  fscanf(fp, "%d", &bps_sp.DisplayInterval);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_sp.Comment);
  fgets(rem, MAX, fp);

  /* FOR TEST */
  fscanf(fp, "%s", bps_sp.TestWgtFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.WgtHistoryNo);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_sp.TestFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.TestFirstPtrn);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.TestLastPtrn);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.InputLayer);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_sp.OutputLayer);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_sp.ActFile);
  fgets(rem, MAX, fp);

/*            modified by higashi       */
  fscanf(fp, "%d", &bps_sp.StrLrnMode);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_sp.Ramuda);
  fgets(rem, MAX, fp);
/*----------- end of modified   --------*/
  fclose(fp);

  wrbps();
  write_syscom();
  return 0;
}

