/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename bpsave.c                       *
*           BPS BPSAVE command                  *
*                                               *
************************************************/
#include        "BPS.h"

void
check_exten(str)
     register char  *str;
{
  for (; *str != 0; str++) {
    if (*str == '.')
      return;
  }
  strcat(str, ".prm");
}

/***********************************************
	save parameters
***********************************************/
int
main()
{
  char            filename[FILE_LENGTH];
  int             lay_no;
  FILE           *fp;

  read_syscom();
  rebps();

  /* FOR NETWORK STRUCTURE */
  strcpy(filename, GetString(0));
  check_exten(filename);
  if ((fp = fopen(filename, "w")) == NULL)
    exit(203);

  fprintf(fp, "%d\t\t%s\n", bps_sp.NumOfLayer, ": number of layer");

  fprintf(fp, "%d", bps_sp.NumOfCell[0]);
  for (lay_no = 1; lay_no < bps_sp.NumOfLayer; lay_no++)
    fprintf(fp, ",%d", bps_sp.NumOfCell[lay_no]);

  fprintf(fp, "\t\t%s\n", ": number of each layer's cell");
  fprintf(fp, "%s", bps_sp.FuncBias[0]);
  for (lay_no = 1; lay_no < bps_sp.NumOfLayer; lay_no++)
    fprintf(fp, ",%s", bps_sp.FuncBias[lay_no]);

  fprintf(fp, "\t%s\n", ": status of char.func and bias");

  /* FOR LEARNING */
  fprintf(fp, "%c\t\t%s\n", bps_sp.InitAlgo,
	  ": init algorithm");
  fprintf(fp, "%s\t%s\n",   bps_sp.InitWgtFile,
	  ": init data file name made by init command");
  fprintf(fp, "%d\t\t%s\n", bps_sp.Seed,
	  ": seed");
  fprintf(fp, "%g\t\t%s\n", bps_sp.MaxInitWgt,
	  ": maximum of init data");
  fprintf(fp, "%g\t\t%s\n", bps_sp.MinInitWgt,
	  ": minimum of init data");
  fprintf(fp, "%s\t%s\n",   bps_sp.LrnInitWgtFile,
	  ": init weight file for learn command");
  fprintf(fp, "%s\t%s\n",   bps_sp.WgtHistoryFile,
	  ": weight history file name");
  fprintf(fp, "%d\t\t%s\n", bps_sp.WgtStorInterval,
	  ": weight store interval");
  fprintf(fp, "%c\t\t%s\n", bps_sp.WgtStorMode,
	  ": weight history store mode");
  fprintf(fp, "%s\t%s\n",   bps_sp.ErrHistoryFile,
	  ": error history file name");
  fprintf(fp, "%d\t\t%s\n", bps_sp.ErrStorInterval,
	  ": error store interval");
  fprintf(fp, "%c\t\t%s\n", bps_sp.ErrStorDirection,
	  ": store direction for error");
  fprintf(fp, "%c\t\t%s\n", bps_sp.ErrStorMode,
	  ": store mode for error");
  fprintf(fp, "%s\t%s\n",   bps_sp.InputFile,
	  ": input data file name for learning");
  fprintf(fp, "%s\t%s\n",   bps_sp.TeachFile,
	  ": teach data file name for learning");
  fprintf(fp, "%d\t\t%s\n", bps_sp.LrnFirstPtrn,
	  ": first pattern No. for learning");
  fprintf(fp, "%d\t\t%s\n", bps_sp.LrnLastPtrn,
	  ": last pattern No.");
  fprintf(fp, "%c\t\t%s\n", bps_sp.LearnMode,
	  ": learning mode");
  fprintf(fp, "%c\t\t%s\n", bps_sp.LearnAlgo,
	  ": learning algorithm");
  fprintf(fp, "%g\t%s\n",   bps_sp.LearnRate,
	  ": learning rate");
  fprintf(fp, "%g\t%s\n",   bps_sp.Momentum,
	  ": momentum");
  fprintf(fp, "%g\t%s\n",   bps_sp.IncreaseFact,
	  ": increasing factor for learn. rate");
  fprintf(fp, "%g\t%s\n",   bps_sp.ReductFact,
	  ": reduction factor for learn. rate");
  fprintf(fp, "%g\t%s\n",   bps_sp.VoglThresh,
	  ": threshold for Vogl method");
  fprintf(fp, "%g\t%s\n",   bps_sp.Theta,
	  ": factor for Ochiai's method");
  fprintf(fp, "%g\t%s\n",   bps_sp.MinError,
	  ": min. error for end");
  fprintf(fp, "%d\t\t%s\n", bps_sp.MaxLearnCount,
	  ": max. learn count for end");
  fprintf(fp, "%d\t\t%s\n", bps_sp.DisplayInterval,
	  ": display interval (console)");
  fprintf(fp, "%s\t%s\n",   bps_sp.Comment,
	  ": comment");

  /* FOR TEST */
  fprintf(fp, "%s\t%s\n",   bps_sp.TestWgtFile,
	  ": weight file name for test");
  fprintf(fp, "%d\t\t%s\n", bps_sp.WgtHistoryNo,
	  ": weight history number");
  fprintf(fp, "%s\t%s\n",   bps_sp.TestFile,
	  ": test data file name");
  fprintf(fp, "%d\t\t%s\n", bps_sp.TestFirstPtrn,
	  ": first pattern No. for test");
  fprintf(fp, "%d\t\t%s\n", bps_sp.TestLastPtrn,
	  ": last pattern No. for test");
  fprintf(fp, "%d\t\t%s\n", bps_sp.InputLayer,
	  ": input layer No.");
  fprintf(fp, "%d\t\t%s\n", bps_sp.OutputLayer,
	  ": output layer No.");
  fprintf(fp, "%s\t%s\n",   bps_sp.ActFile,
	  ": result file name");

 /* modified by higashi */
 /* Structure Learning Params */
  fprintf(fp, "%d\t%s\n",   bps_sp.StrLrnMode,
	  ": structure learning mode . structure learning");
  fprintf(fp, "%g\t%s\n",   bps_sp.Ramuda,
	  ": param of structure learning . Structure learning");
 /* end of modified */
  fclose(fp);
  wrbps();
  write_syscom();
  return 0;
}
