/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.2  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename bpinit.c                       *
*           BPS FUNCTION command                *
*                                               *
************************************************/
#include        "BPS.h"

int
check_bias_type( func_bias )
     char *func_bias;
{
  int  i;
  
  func_bias[3] = '\0';
  for (i = 0; i < 2; i++)
    func_bias[i] = toupper(func_bias[i]);

  if (strcmp("LN", func_bias) == 0 ||
      strcmp("LA", func_bias) == 0 ||
      strcmp("SN", func_bias) == 0 ||
      strcmp("SA", func_bias) == 0 ) return 0;
  
  return -1;
}


/***********************************************
	get function and bias parameters
***********************************************/
int
main()
{
  char    rem[100], func_bias[5];
  int     lay_no;
  int     nargs;

  read_syscom();
  rebps();

  nargs = GetArgNum();

  if (bps_sp.NumOfLayer <= 0) exit(209);

  for (lay_no = 0; lay_no < nargs; lay_no++) {
    strncpy(func_bias, GetString(lay_no), 4);

    if (check_bias_type( func_bias ) != 0)
      exit(208); /* exit if does not match LN, LA, SN or SA */

    strcpy(bps_sp.FuncBias[lay_no], func_bias);
  }

  if (nargs < bps_sp.NumOfLayer) {
    for (lay_no = nargs; lay_no < bps_sp.NumOfLayer; lay_no++) {
      printf("\tLayer%2d = %2s\t", lay_no, bps_sp.FuncBias[lay_no]);

      if ((fgets(rem, 100, stdin) != NULL) && (strlen(rem) >= 2)) {
	sscanf(rem, "%2s", func_bias);

	if (check_bias_type( func_bias ) != 0)
	  exit(208); /* exit if does not match LN, LA, SN or SA */

	strcpy(bps_sp.FuncBias[lay_no], func_bias);
      }
    }
  }

  wrbps();
  write_syscom();
  return 0;
}
