/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.2  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename lalgo.c                        *
*           BPS LALGO command                   *
*                                               *
************************************************/
#include "BPS.h"

/***********************************************
	get learning algorithm and
	    learning rate parameters 
***********************************************/
int
main()
{
  int    nargs;
  char  *str1, *str2;
  char   rem[100];
  char   learn_mode;

  read_syscom();
  rebps();

  nargs = GetArgNum();
  str1  = GetString(0);
  str2  = GetString(1);

  learn_mode = toupper(str1[0]);
  if ((learn_mode != SET_LEARN) && (learn_mode != PATTERN_LEARN))
    exit(202);
  bps_sp.LearnMode = learn_mode;

  if ((str2[0] < STEEP) || (str2[0] > OCHI))
    exit(210);
  bps_sp.LearnAlgo = str2[0];


  bps_sp.LearnRate = GetScalar(2);

  if ((bps_sp.LearnAlgo >= MOMENTUM) &&
      (bps_sp.LearnAlgo <= OCHI)) {
    if (nargs < 4) {
      printf("\tmonentum = %g\t", bps_sp.Momentum);
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%lf", &bps_sp.Momentum);
    } else
      bps_sp.Momentum = GetScalar(3);
  }
  /* modified by higashi */
  if (nargs >= 4 && bps_sp.LearnAlgo == MOMENTUM){
       bps_sp.StrLrnMode = GetScalar(4);
    if (nargs < 6 && bps_sp.StrLrnMode !=0){
      printf("\tRamuda(for Struct Learning Param) = %f\t", bps_sp.Ramuda);
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%lf", &bps_sp.Ramuda);
    }else
      bps_sp.Ramuda = GetScalar(5);
  }
  /* end of modified */
  if (bps_sp.LearnAlgo == VOGL  ||
      bps_sp.LearnAlgo == JACOB ||
      bps_sp.LearnAlgo == OCHI) {

    if (nargs < 5) {
      printf("\tincreasing factor = %g\t", bps_sp.IncreaseFact);
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%lf", &bps_sp.IncreaseFact);
    } else
      bps_sp.IncreaseFact = GetScalar(4);

    if (nargs < 6) {
      printf("\treduction factor = %g\t", bps_sp.ReductFact);
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%lf", &bps_sp.ReductFact);
    } else /* nargs > 5 */
      bps_sp.ReductFact = GetScalar(5);
  }

  switch (bps_sp.LearnAlgo) {
  case VOGL:
    if (nargs < 7) {
      printf("\tthreshold for Vogl method = %f\t", bps_sp.VoglThresh);
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%lf", &bps_sp.VoglThresh);
    } else
      bps_sp.VoglThresh = GetScalar(6);
    break;

  case OCHI:
    if (nargs < 7) {
      printf("\tTheta(for Ochiai's method) = %f\t", bps_sp.Theta);
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%lf", &bps_sp.Theta);
    } else
      bps_sp.Theta = GetScalar(6);
/* modified by higashi             */
    if (nargs > 7){
      bps_sp.StrLrnMode = GetScalar(7);
      if (nargs == 8 && bps_sp.StrLrnMode !=0){
	printf("\tRamuda(for Struct Learning Param) = %f\t", bps_sp.Ramuda);
	if (fgets(rem, 100, stdin) != NULL)
	  sscanf(rem, "%lf", &bps_sp.Ramuda);
      }else
	bps_sp.Ramuda = GetScalar(8);
      break;
    }
  }
/* ----------- end of modified ------------ */
  wrbps();
  write_syscom();
  return 0;
}
