/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename pdisp.c                        *
*           BPS DISP command                    *
*                                               *
************************************************/
#include "BPS.h"

/***********************************************
  display parameters  
  ***********************************************/

int
main()
{
  int  lay_no;

  read_syscom();
  rebps();

  printf("\n\n<<  structure of network  >>\n");
  printf("### Number of layer = %d\n", bps_sp.NumOfLayer);
  printf("    layer     num of cells        condition\n");

  for (lay_no = 0; lay_no < bps_sp.NumOfLayer; lay_no++) {
    printf("       %2d        %5d", lay_no, bps_sp.NumOfCell[lay_no]);

    switch (bps_sp.FuncBias[lay_no][0]) {
    case SIGMOID:   printf("         sigmoid,"); break;
    case LINEAR:    printf("         linear ,"); break;
    default:                                     break;
    }
    switch (bps_sp.FuncBias[lay_no][1]) {
    case APPEND:    printf(" append bias\n");    break;
    case NO_APPEND: printf(" non bias\n");       break;
    default:        printf("\n");
    }
  }

  printf("\n\n<<  Initialize condition  >>\n");
  printf("### Initialize algorithm      = ");

  switch (bps_sp.InitAlgo) {
  case RANDUM:      printf("randum\n");          break;
  case JIA:         printf("Jia's algorithm\n"); break;
  default:          printf("\n");
  }

  printf("### Initialize data file name = %s\n", bps_sp.InitWgtFile);
  printf("    Seed     Max Weight     Min Weight\n");
  printf("  %6d          %g             %g\n",
	 bps_sp.Seed, bps_sp.MaxInitWgt, bps_sp.MinInitWgt);

  printf("\n\n<<  Learning condition  >>\n");
  printf("### Initialize data file name = %s\n", bps_sp.LrnInitWgtFile);
  printf("### Weight history file name  = %s\n", bps_sp.WgtHistoryFile);
  printf("    Store   Interval     Mode\n");
  printf("             %5d      ", bps_sp.WgtStorInterval);
  switch (bps_sp.WgtStorMode) {
  case APPEND:
    printf("append\n");
    break;
  case OVERWRITE:
    printf("overwrite\n");
    break;
  default:
    printf("\n");
  }

  printf("### Error history file name = %s\n", bps_sp.ErrHistoryFile);
  printf("    Store   Interval   Direction");
  if (bps_sp.ErrStorDirection == RECORD) printf("     mode\n");
  else                                   printf("\n");

  printf("             %5d     ", bps_sp.ErrStorInterval);
  switch (bps_sp.ErrStorDirection) {
  case RECORD:
    printf(" record      ");
    switch (bps_sp.ErrStorMode) {
    case APPEND:     printf("append\n");    break;
    case OVERWRITE:  printf("ovarwrite\n"); break;
    default:         printf("\n");
    }
    break;
  case DATAPOINT:
    printf("data point\n");
    break;
  default:
    printf("\n");
  }

  printf("### Input data file name = %s\n", bps_sp.InputFile);
  printf("### Teach data file name = %s\n", bps_sp.TeachFile);
  printf("    Input pattern number = ");
  if (bps_sp.LrnFirstPtrn == 0)
    printf("all\n");
  else
    printf("%d -> %d\n", bps_sp.LrnFirstPtrn, bps_sp.LrnLastPtrn);

  printf("### Learning mode 	 = ");
  switch (bps_sp.LearnMode){
  case SET_LEARN:      printf("set learning\n");     break;
  case PATTERN_LEARN:  printf("pattern learning\n"); break;
  default:             printf("\n");
  }

  printf("### Learning algorithm  = ");
  switch (bps_sp.LearnAlgo) {
  case STEEP:      printf("Steep method\n");     break;
  case MOMENTUM:   printf("Momentum method\n");  break;
  case VOGL:       printf("Vogl method\n");      break;
  case JACOB:      printf("Jacob's method\n");   break;
  case MOMENTUM2:  printf("Momentum Vogl's coefficient method\n"); break;
  case OCHI:       printf("Ochiai's method\n");  break;
  default:         printf("\n");
  }

  if ((bps_sp.LearnAlgo >= STEEP) && (bps_sp.LearnAlgo <= OCHI))
    printf("    Learning rate = %g\n", bps_sp.LearnRate);

  if ((bps_sp.LearnAlgo >= MOMENTUM) && (bps_sp.LearnAlgo <= OCHI))
    printf("    Momentum      = %g\n", bps_sp.Momentum);

  if (bps_sp.LearnAlgo == VOGL  ||
      bps_sp.LearnAlgo == JACOB ||
      bps_sp.LearnAlgo == OCHI) {
    printf("    Increasing factor rate = %g\n", bps_sp.IncreaseFact);
    printf("    Reduction factor rate  = %g\n", bps_sp.ReductFact);
  }

  if (bps_sp.LearnAlgo == VOGL)
    printf("    Threshold for Vogl method = %g\n", bps_sp.VoglThresh);

  if (bps_sp.LearnAlgo == OCHI)
    printf("    Theta(for Ochiai's method) = %g\n", bps_sp.Theta);

  printf("### Minimum error for end     = %g\n", bps_sp.MinError);
  printf("### Maximum iteration for end = %d\n", bps_sp.MaxLearnCount);

  printf("### Display interval = %d\n", bps_sp.DisplayInterval);
  printf("### Comment = %s\n", bps_sp.Comment);

  printf("\n\n<<  Testing condition  >>\n");
  printf("### Weight file for test = %s\n", bps_sp.TestWgtFile);
  printf("### Weight history number = %d\n", bps_sp.WgtHistoryNo);
  printf("### Input data file for test = %s\n", bps_sp.TestFile);
  printf("    Input pattern number     = ");

  if (bps_sp.TestFirstPtrn == 0) {
    printf("all\n");
  } else
    printf("%d -> %d\n", bps_sp.TestFirstPtrn, bps_sp.TestLastPtrn);

  printf("### Input layer  = %d\n", bps_sp.InputLayer);
  printf("### Output layer = %d\n", bps_sp.OutputLayer);
  printf("### Result file for test     = %s\n", bps_sp.ActFile);
 /* appending StuctureLearning param */
 /* modified  by higashi */
  printf("### Checking New Param ### \n");
  printf("### StrLrnMode = %d\n",bps_sp.StrLrnMode);
  printf("### PruRamuda  = %g\n",bps_sp.Ramuda);
 /*-------end of modified -----------*/
  
  return 0;
}









