/************************************************
 *                                               *
 *       Back Propergation Simurator             *
 *             subroutine packege                *
 *               Version 			*
 *         coded         in May.9  1990          *
 *         coded by      M.Kai                   *
 *         last modified in Jul.3  1990          *
 *         modified by   K.Kuroda                *
 *                                               *
 *************************************************
 *                                               *
 *       filename bpinit.c                       *
 *           BPS PINIT command                   *
 *                                               *
 ************************************************/
#include "BPS.h"

/***********************************************
  initialize parameters 
  ***********************************************/
int
main()
{
  int  lay_no;

  read_syscom();

  /* FOR NETWORK STRUCTURE */
  bps_sp.NumOfLayer = 0;
  for (lay_no = 0; lay_no < MAX_LAYER; lay_no++) {
    bps_sp.NumOfCell[lay_no]   = 0;
    bps_sp.FuncBias[lay_no][0] = EOS;
  }

  /* FOR INTIALIZE WEIGHT */
  bps_sp.InitAlgo              = RANDUM;
  bps_sp.InitWgtFile[0]        = EOS;
  bps_sp.Seed                  = 1;
  bps_sp.MaxInitWgt            = 1.0;
  bps_sp.MinInitWgt            = -1.0;

  /* FOR LEARNING */
  bps_sp.LrnInitWgtFile[0]     = EOS;
  bps_sp.WgtHistoryFile[0]     = EOS;
  bps_sp.WgtStorInterval       = 1;
  bps_sp.WgtStorMode           = APPEND;
  bps_sp.ErrHistoryFile[0]     = EOS;
  bps_sp.ErrStorInterval       = 1;
  bps_sp.ErrStorDirection      = RECORD;
  bps_sp.ErrStorMode           = APPEND;
  bps_sp.InputFile[0]          = EOS;
  bps_sp.TeachFile[0]          = EOS;
  bps_sp.LrnFirstPtrn          = 0;
  bps_sp.LrnLastPtrn           = 0;
  bps_sp.LearnMode             = SET_LEARN;
  bps_sp.LearnAlgo             = MOMENTUM;
  bps_sp.LearnRate             = 0.0;
  bps_sp.Momentum              = 0.0;
  bps_sp.IncreaseFact          = 0.0;
  bps_sp.ReductFact            = 0.0;
  bps_sp.VoglThresh            = 0.0;
  bps_sp.Theta                 = 0.0;
  bps_sp.MinError              = 0.0;
  bps_sp.MaxLearnCount         = 0;
  bps_sp.DisplayInterval       = 0;
  bps_sp.Comment[0]            = EOS;

  /* FOR TEST */
  bps_sp.TestWgtFile[0]        = EOS;
  bps_sp.WgtHistoryNo          = 0;
  bps_sp.TestFile[0]           = EOS;
  bps_sp.TestFirstPtrn         = 0;
  bps_sp.TestLastPtrn          = 0;
  bps_sp.InputLayer            = 0;
  bps_sp.OutputLayer           = 0;
  bps_sp.ActFile[0]            = EOS;

  wrbps();
  write_syscom();
  return 0;
}
