/************************************************
*						*
*	Back Propergation Simurator(BPS)	*
*	      subroutine package		*
*	  	Ver 4.0 			*
*	  coded		in May.17 1989		*
*	  last modified in Jul.3  1990		*
*	  coded by 	Y.Okamura		*
*	  modified by   K.Kuroda		*
*						*
*************************************************
*						*
*	filename tstmain.c 			*
*	    BP testing controler		*
*						*
************************************************/

#include "BPS.h"
#include "BPStrace.h"

/************************************************
  testing main routine
  ************************************************/
int
main()
{
  char     rem[100], teach_file[FILE_LENGTH], err_file[FILE_LENGTH];
  char    *str;
  int      nargs;
  int      ptrn_no, unit_no;
  int      disp_flag, teach_flag, file_out_flag, err_flag;
  float    err, error = 0.0;
  cel_t   *cell_pt;

  read_syscom();
  rebps();

  /* GET PARAMETERS */

  nargs         = GetArgNum();
  file_out_flag = (int)GetScalar(0);
  disp_flag     = (int)GetScalar(1);

  if ((file_out_flag != 0) && (file_out_flag != 1))
    exit(43);
  if ((disp_flag != 0) && (disp_flag != 1))
    exit(44);

  teach_flag = 0;
  err_flag   = 0;

  if (disp_flag) {
    if (nargs == 2) {
      printf("\tdisplay mode( 1 - 4 ) = ");
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%c", &DisplayMode);
    } else {
      str = GetString(2);
      DisplayMode = str[0];
    }

    if ((DisplayMode == COLOR) ||
	(DisplayMode == SIZE)) {
      switch (nargs) {
      case 2:
      case 3:
	printf("\tminimum value = ");
	if (fgets(rem, 100, stdin) != NULL)
	  sscanf(rem, "%f", &MinScale);
	/* through */
      case 4:
	printf("\tmaximum value = ");
	if (fgets(rem, 100, stdin) != NULL)
	  sscanf(rem, "%f", &MaxScale);
	break;
      }

      switch (nargs) {
      case 7:
	err_flag = 1;
	strcpy(err_file,   GetString(6));
	/* through */
      case 6:
	teach_flag = 1;
	strcpy(teach_file, GetString(5));
	/* through */
      case 5:
	MaxScale    = (float)GetScalar(4);
	/* through */
      case 4:
	MinScale    = (float)GetScalar(3);
	break;
      }
    }
    if ((DisplayMode != COLOR) &&
	(DisplayMode != SIZE) &&
	(DisplayMode != NETWORK_FUNCTION) &&
	(DisplayMode != NETWORK_ONLY))
      exit(45);
  }
  GetStructureParameters();
  PrintStructureParameters();
  GetTestingParameters();
  PrintTestingParameters();

  if (disp_flag) {
    regpm();
    
    if (checktodvi())
      writegpm();
    gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, GpmCont.winNum);
    gnewpen(GpmCont.fColor);
    gpen(GpmCont.fLineWidth,GpmCont.fLineType, 0);
    gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
    gfactor(GpmCont.factor);
  } else
    DisplayMode = (file_out_flag) ? COLOR : 5;

  /* CONSTANT DEFINE */
  switch (DisplayMode) {
  case NETWORK_FUNCTION:
  case NETWORK_ONLY:
    /* DRAW NETWORK STRUCTURE */
    DrawNetwork(DisplayMode);
    if (!file_out_flag) break;
    disp_flag = 0;

    /* through */
  case COLOR:
  case SIZE:
    /* TEST( RECOGNIZE ) AND DRAW NETWORK STRUCTURE */
    rec_system_initialize();
    MakeNetwork();
    ReadWeight2(TestWgtFile, WgtHistoryNo);

    if (file_out_flag) CreateFile1(ActFile,  "activation data");
    if (err_flag)      CreateFile1(err_file, "error data");

    if (disp_flag) {
      DrawNetwork(DisplayMode);

      if (teach_flag) {
	TeachData = (float**)malloc2D(NumOfPtrn, NumOfCell[NumOfLayer-1],
				      sizeof(float));
	if (TeachData == NULL)  exit(42);

	ReadData(teach_file, TeachData, TestFirstPtrn, TestLastPtrn,
		 NumOfCell[NumOfLayer-1]);
	DrawTeachData();
      }
    }

    for (ptrn_no = 0; ptrn_no < NumOfPtrn; ptrn_no++) {
      test_network(InputData[ptrn_no]);

      if ((file_out_flag) || (err_flag)) {
	error = 0.0;
	for (unit_no = 1; unit_no <= NumOfCell[OutputLayer]; unit_no++) {
	  cell_pt = BPNet[OutputLayer][unit_no].CellNode;
	  if (file_out_flag){
	    act_buf[unit_no - 1] = cell_pt->Active;
	  }
	  if (err_flag) {
	    err = TeachData[ptrn_no][unit_no-1] - (float) cell_pt->Active;
	    err = err * err;	/* May 31th, 1992 Kuroda Ga
				 * Rewrite Shimashita.  */
	    error += err;
	    ErrBuffer[unit_no-1] = err;
	  }
	}
	if (file_out_flag){
	  WriteActivation(ptrn_no); /* suzu */
	}
      }
      if (err_flag){
	ErrBuffer[NumOfCell[OutputLayer]] = error;
	WriteErrRecord(err_file, ptrn_no);
      }
      if (disp_flag)
	DrawBox(ptrn_no, teach_flag, InputLayer, OutputLayer);
    } /* END OF NETWORK TEST */

    BreakNetwork();
    rec_system_end();
    break;
  } /* END OF SWITCH */

  if (disp_flag) {
    glimit(0.0, 0.0, 0.0, 0.0);
    gflush();
    gclose();
  }
  wrbps();
  write_syscom();
  return 0;
}
