/************************************************
*                                               *
*	BP simulator Header File 		* 
*		Version 			*
* 	  coded 	in May.17 1989          *
*         coded by 	Y.Okamura  		* 
*         last modified in Nov.15 1990		*
*         modified by	K.Kuroda		*
*                          			*
************************************************/
#ifndef _BPS_H_
#define _BPS_H_

/* INCLUDE FILE	*/
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include <ctype.h>
#include <math.h>


/* CONSTANT DEFINE & SYSTEM PARAMETERS */
#include "BPSdefs.h"

/* EXTERNAL FUNCTION DEFINE */
#include "BPSproto.h"

#ifndef _BPS_GETPARAM_
/* GLOBAL VALUABLE */
extern bpspr_t   bps_sp;
extern lay_t    *BPNet[MAX_LAYER];

/* GLOBAL VARIABLES */
extern int       NumOfLayer;              /* number of layer */
extern int       NumOfCell[MAX_LAYER];    /* number of each layer's cell    */
extern char      FuncBias[MAX_LAYER][5];  /* status of char.func and bias */
extern int       NumOfPtrn;               /* number of pattern */

/* GLOBAL VARIABLES FOR HISTORY FILE HANDLE */
extern float     WgtInData[HBUFSIZE];     /* weight history input work */
extern float     WgtOutData[HBUFSIZE];    /* weight history output work */
extern float     ErrOutData[HBUFSIZE];    /* error history output work */
extern float    *ErrBuffer;               /* error history output work */
extern double   *buff_err;                /* error history (buffer)    */
extern float   **InputData;               /* input data for learning */
extern float   **TeachData;               /* teach data for learning */

extern int       NumOfLink;             /* num. of all link */
extern int       WgtMaxDataPoint;       /* maximum data point of weight */
extern int       ErrMaxDataPoint;       /* maximum data point of error */
extern int       WgtBlockSize;          /* weight history block size(record) */
extern int       ErrBlockSize;          /* error history block size(record) */

/* GLOBAL VARIABLES FOR INITIALIZE */
extern char      InitAlgo;                 /* initialize algorithm */
extern char      InitWgtFile[FILE_LENGTH]; /* initialize weight file name
					      for initialize */
extern int       Seed;                     /* seed */
extern double    MaxInitWgt;               /* maximum of initialize data */
extern double    MinInitWgt;               /* minimum of initialize data */

/* GLOBAL VARIABLES FOR LEARN */
extern char      LrnInitWgtFile[FILE_LENGTH];  /* initialize weight
						  for learning */
extern char      WgtHistoryFile[FILE_LENGTH];  /* weight history file name */
extern int       WgtStorInterval;              /* weight store interval */
extern char      WgtStorMode;                  /* store mode for weight */

extern char      ErrHistoryFile[FILE_LENGTH];  /* error histoy file name */
extern int       ErrStorInterval;              /* error store interval */
extern char      ErrStorDirection;             /* store direction for error */
extern char      ErrStorMode;                  /* store mode for error */

extern char      InputFile[FILE_LENGTH];/* input data file name for learning */
extern char      TeachFile[FILE_LENGTH];/* teach data file name for learning */
extern int       LrnFirstPtrn;          /* first pattern number of learning
					   (0:all) */
extern int       LrnLastPtrn;           /* last pattern */

extern char      LearnMode;            /* learning mode */
extern char      LearnAlgo;            /* learning algorithm */
extern double    LearnRate;            /* learning rate */
extern double    Momentum;             /* momentum */
extern double    ReductFact;           /* reduction factor for learn. rate */
extern double    IncreaseFact;         /* increasing factor for learn.  rate */
extern int       VglCoef[FILE_LENGTH]; /* Vogl coefficient for moment2 */ 
extern double    InitMoment;           /* initial momentum */
extern double    VoglThresh;           /* threshold for Vogl method */
extern double    Theta;                /* for Ochiai's method */

extern double    SumOfErr;             /* sum of learning error */
extern double   *OutCellErr;           /* error for output cell */

extern double    MinError;             /* min. error for end */
extern int       MaxLearnCount;        /* max. learn count for end */

extern int       DisplayInterval;      /* display interval (console) */
extern char      Comment[FILE_LENGTH]; /* comment */

/* GLOBAL VARIABLES FOR TEST */
extern char      TestWgtFile[FILE_LENGTH]; /* weight file name for test */
extern int       WgtHistoryNo;             /* weight history number */
extern char      TestFile[FILE_LENGTH];    /* test data file name */
extern int       TestFirstPtrn;            /* first pattern number of test */
extern int       TestLastPtrn;             /* last pattern number of test */
extern int       InputLayer;               /* input layer No. */
extern int       OutputLayer;              /* output layer No. */
extern char      ActFile[FILE_LENGTH];     /* result file name */

extern float     ActOutData[HBUFSIZE];     /* test result work */
extern int       ActBlockSize;             /* result file block size(record) */
extern int       ActMaxDataPoint;          /* maximum datapoint for result */

extern float    *act_buf;                  /* activation buffer */

/* GLOBAL VARIALBLES FOR LOAD ǤʤȥʤΤ */
extern float    *Data;
extern int       BufferNo;
extern int       FileNo;
#define Index  _Index           /* addition by tom */
#define Index2 _Index2          /* addition by tom */
extern int       Index[MAX_BUFF_DIM];
extern int       Index2[MAX_BUFF_DIM];
extern char      FileName[FILE_LENGTH];
extern char      FileType;

#endif /* _BPS_GETPARAM_ */
#endif /* _BPS_H_ */
