#include "BPS.h"

char **malloc2D  _ANSI_ARGS_((int n, int m, size_t sz));
void   _free2D   _ANSI_ARGS_((char **data));

char **
malloc2D( n, m, sz )
     int    n, m;
     size_t sz;
{
  char **data;
  int    j, k;

  if ( n <= 0 || m <= 0 ) return NULL;

  if ((data = (char**)malloc(n*sizeof(char*)+1)) == NULL) return NULL;
  
  data[n] = NULL;

  for (j = 0; j < n; j++)
    if ((data[j] = (char*)calloc(m, sz)) == NULL ) {
      for (k = 0; k <= j && data[k] != NULL; k++ ) free(data[k]);
      free(data);
      data = NULL;
      break;
    }

  return data;
}

void
_free2D(data)
     char **data;
{
  int j;

  if ( data == NULL ) return;

  for (j = 0; data[j] != NULL; j++ )
    free(data[j]);

  free(data);
}
