/************************************************
 *						*
 *	Back Propergation Simurator(BPS)	*
 *	      subroutine package		*
 *	  	Version 			*	
 *    	  coded		in Jul.29 1989		*
 *	  coded by 	Y.Okamura		*	
 *	  last modified	in Nov.15 1990		*
 *	  modified by	K.Kuroda 		*
 *						*
 *************************************************
 *                                               *
 *       filename charfunc.c                     *
 *            characteristic functions           *
 *                                               *
 *************************************************/

#include	"BPS.h"

/************************************************
  calculate sigmoid function
  input :	
  x : argument of sigmoid function
  ************************************************/
double
Sigmoid(x)
     double x;
{
  double  y;

  if ( x > 300.0 )
    y = 1.0;
  else 
    y = ( x < -300.0 ) ? 0.0 : 1.0/(1.0+exp(-x));

  return y;
}

/************************************************
  calculate sigmoid's differential
  input :
  x : argument of sigmoid diff.
  ************************************************/
double
d_sig(x)
     double x;
{
  double  y, z;

  z = Sigmoid(x);
  y = z*(1.0-z);

  return y;
}

/************************************************
  calculate linear function
  input :
  x : argument of linear func.
  ************************************************/
double
Linear(x)
     double x;
{
  return x;
}

/************************************************
  calculate linear differential
  input :
  x : argument of liner diff.
  ************************************************/
double
d_lin()
{
  return (double)1.0;
}

/************************************************
  character function selector
  iputs:
  function : character function
  S : sigmoid
  L : linear
  in_data  : argument of character function
  return:
  result of character funciton
  ************************************************/
double
FuncSelect(function, in_data)
     int     function;
     double  in_data;
{
  double   result;

  switch(function){
  case SIGMOID:  result = Sigmoid(in_data); break;
  case LINEAR:   result = Linear(in_data);  break;
  default:       exit(110);
  }
  return result;
}

/************************************************
  differential of character function selector
  iputs:
  function : character function
  S : sigmoid
  L : linear
  in_data  : argument of character function
  return:
  result of character funciton
  ************************************************/
double
DiffSelect(function, in_data)
     int    function;
     double in_data;
{
  double  result;

  switch(function){
  case SIGMOID:   result = d_sig( in_data );  break;
  case LINEAR:    result = 1.0;               break;
  default:        exit(110);
  }
  return result;
}
