/************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *               Version 			*
 *         coded    	in Aug.25 1989          *
 *         coded by 	Y.Okamura 		*
 *	  last modified in Nov.15 1990 		*
 *	  modified by   K.Kuroda		*
 *                                               *
 *************************************************
 *                                               *
 *       filename fhndl.c                        *
 *          history file handler                 *
 *                                               *
 ************************************************/
#include "BPS.h"


/************************************************
  set NumOfLink
  ************************************************/
void
SetNumOfLink()
{
  int  laynum;

  NumOfLink = 0;
  for (laynum = 0; laynum < NumOfLayer-1; laynum++) {
    if (CheckBias(laynum+1))
      NumOfLink += (NumOfCell[laynum]+1)*NumOfCell[laynum+1];
    else
      NumOfLink += NumOfCell[laynum]*NumOfCell[laynum+1];
  }
}


/*********************************************************
  get record number.
  input 	: filename
  *********************************************************/
int
GetNumOfRecord(filename)
     char  filename[];
{

  Header          head;

  if(LoadHeader(filename, &head) != -1)
    return (head.index[0]);
  else 
    return 0;
}


/***********************************************
  adjust last block of weight history
  inputs:
  filename : weight history file name
  return:
  last history number
  ***********************************************/
int
LastWgtHistory(filename)
     char filename[];
{
  Header  head;

  if (LoadHeader(filename, &head) != -1)
    return (head.index[0]-1);
  else
    return 0;
}


/***********************************************
  adjust last block of weight history
  inputs:
  filename : weight history file name
  return:
  next history number
  ***********************************************/
int
NextWgtHistory(filename)
     char  filename[];
{
  Header   head;

  if(LoadHeader(filename, &head) != -1)
    return (head.index[0]);
  else 
    return 0;
}


/***********************************************
  adjust last block of weight history
  inputs:
  filename : error history file name
  return:
  next history number
  ***********************************************/
int
NextErrHistory(filename)
     char  filename[];
{
  Header   head;

  if(LoadHeader(filename, &head) != -1)
    return (head.index[0] + 1);
  else
    return 0;
}


/***********************************************
  clean history array
  input :
  hist_arry : history array
  ***********************************************/
#if 0 /* no use */
void
CleanHistArray(hist_arry)
     float  *hist_arry;
{
  int  i;

  for (i = 0; i < HBUFSIZE; hist_arry[i++] = 0.0);
}
#endif


/************************************************
  read test data
  ************************************************/
void
ReadData(filename, data, first_ptrn, last_ptrn, num_cell)
     char    filename[];
     float **data;
     int     first_ptrn;
     int     last_ptrn;
     int     num_cell;
{
  int      ptrn, pt_no, unit;
  float   *tmparea;
  Header   header;

  for (ptrn = first_ptrn; ptrn <= last_ptrn; ptrn++) {
    tmparea = (float*)LoadData(filename, ptrn - 1, &header);
    if (tmparea == (float*)NULL) exit(13);
    if (header.index[1] != num_cell)
      exit(100);

    pt_no = ptrn - first_ptrn;
    for (unit = 0; unit < num_cell; unit++) {
      data[pt_no][unit] = tmparea[unit];
    }
    free(tmparea);
  }
}


/************************************************
  write weight history
  inputs:
  filename : weight history file name
  hist_no  : weight history number( form 1 )
  data     : weight data
  ************************************************/
void
WriteWeight2(filename, hist_no, data)
     char    *filename;
     int      hist_no;
     double  *data;
{
  int     index[5], i;
  float  *buf;

  buf = (float *)malloc(sizeof(float)*NumOfLink);

  for (i = 0; i < NumOfLink; i++)
    buf[i] = (float) data[i];

  index[0] = NumOfLink;
  StoreData(filename, hist_no , 1, index, (char*)buf);
}


/************************************************
  get and write weight history
  inputs:
  filename : weight history file name
  wgt_stor_cnt : count of history
  ************************************************/
void
StoreWeight2(filename, wgt_stor_cnt)
     char  filename[];
     int   wgt_stor_cnt;
{
  int      laynum, unit_to, unit_from, position_cnt;
  ilin_t  *in_link;
  double  *WgtBuff;

  WgtBuff = (double*)malloc(sizeof(double)*NumOfLink);

  /* WRITE WEIGHT DATA */
  position_cnt = 0;
  for (laynum = 1; laynum < NumOfLayer; laynum++) {
    for (unit_to = 1; unit_to <= NumOfCell[laynum]; unit_to++) {
      if (CheckBias(laynum)) {
	in_link = inter_ilin(BPNet[laynum][0].CellNode,
			     BPNet[laynum][unit_to].CellNode);
	WgtBuff[position_cnt++] = in_link->Weight;
      }
      for (unit_from = 1; unit_from <= NumOfCell[laynum-1]; unit_from++) {
	in_link = inter_ilin(BPNet[laynum-1][unit_from].CellNode,
			     BPNet[laynum][unit_to].CellNode);
	WgtBuff[position_cnt++] = in_link->Weight;
      }
    }
  }
  WriteWeight2(filename, wgt_stor_cnt, WgtBuff);

  /* WRITE DELTA WEIGHT DATA */
  position_cnt = 0;
  for (laynum = 1; laynum < NumOfLayer; laynum++) {
    for (unit_to = 1; unit_to <= NumOfCell[laynum]; unit_to++) {
      if (CheckBias(laynum)) {
	in_link = inter_ilin(BPNet[laynum][0].CellNode,
			     BPNet[laynum][unit_to].CellNode);
	WgtBuff[position_cnt++] = in_link->AdjWgt;

      }
      for (unit_from = 1; unit_from <= NumOfCell[laynum-1]; unit_from++) {
	in_link = inter_ilin(BPNet[laynum-1][unit_from].CellNode,
			     BPNet[laynum][unit_to].CellNode);
	WgtBuff[position_cnt++] = in_link->AdjWgt;
      }
    }
  }
  WriteWeight2(filename, wgt_stor_cnt+1, WgtBuff);

  free(WgtBuff);
}


/************************************************
  write error history(direction is data point)
  inputs:
  filename : error history file name
  hist_no  : error history number( from 1 )
  position : store position( from 0 )
  data     : error data
  ************************************************/
void
WriteErrDataPoint(filename, hist_no, position, data)
     char    filename[];
     int     hist_no;
     int     position;
     double  data;
{
  Header  head;

  ErrBuffer[position] = data;
  head.index[0]       = 1;
  head.index[1]       = position+1;
  WriteFile(filename, 2, head.index, (char*)ErrBuffer);
}


/************************************************
  write error history( direction is record )
  inputs:
  hist_no : Error history number.
  ************************************************/
void
WriteErrRecord( filename, hist_no )
     char    *filename;
     int     hist_no;
{

  int      index[10];

  index[0] = NumOfCell[OutputLayer]+1;

  StoreData(filename, hist_no-1, 1, index, (char*)ErrBuffer);
}



/************************************************
  get and sotre error history( for dir1 )
  inputs:
  filename : error history file name
  err_stor_cnt : history count
  ************************************************/
void
StoreErrRecord(filename, err_stor_cnt)
     char  filename[];
     int   err_stor_cnt;
{
  int     unit, position_cnt;
  float  *dum;
  int     index[10];

  position_cnt = 0;
  dum = (float*)calloc((NumOfCell[NumOfLayer-1]+1), sizeof(float));

  for (unit = 0; unit < NumOfCell[NumOfLayer-1]; unit++)
    dum[position_cnt++] = OutCellErr[unit];

  dum[position_cnt++] = (float)SumOfErr;
    
  index[0] = position_cnt;
  StoreData(filename, err_stor_cnt-1, 1, index, (char*)dum);

  free(dum);
}


/************************************************
  write activation history
  inputs:
  hist_no  : activation history number( from 0 )
  ************************************************/
void
WriteActivation(hist_no)
     int             hist_no;
{
  int      index[10];

  index[0] = NumOfCell[OutputLayer];
  StoreData(ActFile, hist_no, 1, index, (char*)act_buf);
}


/************************************************
  read and store old history err
  inputs:
  filename : error history file name
  hist_no	 : last history number
  return:
  number of store error( last record )
  ************************************************/
int
StoreOldError(filename, hist_no)
     char  filename[];
     int   hist_no;
{
  int     i;
  float  *dum;
  Header  head;
  int     num_data = 0;

  if (( dum = (float*)ReadFile(filename, &head)) == NULL )
    num_data = 0;
  else {
    if ( head.index[0] != 1 || head.index[1] <= 0 )
      num_data = 0;
    else
      num_data = head.index[1];
    if ( num_data > MaxLearnCount )
      num_data = 0; /* ʤȤ̵Ȼפ */

    for ( i = 0; i < num_data; i++ )
      ErrBuffer[i] = dum[i];

    free(dum);
  }
  return (num_data);
}


/*************************************************
  create file
  inputs:
  filename : file name
  temp 	 :
  *************************************************/
void
CreateFile1(filename, temp)
     char filename[], temp[];
{
  char    answer = 'n', rem[100];
  Header  head;

  if (access(filename, 0) == -1) {
    InitHeader(&head);
    StoreHeader(filename, &head);
    printf("\n*** File [ %s ] is created. ***\n", filename);
  } else {
    printf("\n*** File [ %s ] is already exist. ***\n", filename);
    printf("    Overwrite ? ( y/n ) : ");
    if (fgets(rem, 100, stdin) != NULL)
      sscanf(rem, "%c", &answer);
    answer = tolower(answer);
    if (answer == 'y') {
      printf("    File [ %s ] is overwrited.\n", filename);
      InitHeader(&head);
      StoreHeader(filename, &head);
    } else
      exit(101);
  }
}

/**************************************************
  create file
  inputs:
  filename  : file name
  temp      :
  stor_mode : store mode
  **************************************************/
void
CreateFile2(filename, temp, stor_mode)
     char  filename[];
     char  temp[];
     int   stor_mode;
{
  char  answer = 'n', rem[100];

  if (access(filename, 0) == -1) {
    printf("\n*** File [ %s ] is created. ***\n", filename);
  } else {
    printf("\n*** File [ %s ] is already exist. ***\n", filename);
    if (stor_mode == OVERWRITE) {
      printf("    Overwrite ? ( y/n ) : ");
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%c", &answer);
      answer = tolower(answer);
      if (answer == 'y') {
	printf("    File [ %s ] is overwrited.\n", filename);
      } else
	exit(101);
    } else {
      printf("    Append ? ( y/n ) : ");
      if (fgets(rem, 100, stdin) != NULL)
	sscanf(rem, "%c", &answer);
      answer = tolower(answer);
      if (answer != 'y') {
	printf("    File [ %s ] is overwrited.\n", filename);
      }
    }
  }
}


/**************************************************
  create file
  inputs:
  filename  : file name
  temp      :
  stor_mode : store mode
  Not  stop
  **************************************************/
void
CreateFile3(filename, temp, stor_mode)
     char filename[];
     char temp[];
     int  stor_mode;
{
  if (access(filename, 0) == -1) {
    printf("\n*** File [ %s ] is created. ***\n", filename);
  } else {
    printf("\n*** File [ %s ] is already exist. ***\n", filename);
    if (stor_mode == OVERWRITE) {
      printf("    File [ %s ] is overwrited.\n", filename);
    } else {
      printf("    File [ %s ] is appended.\n", filename);
    }
  }
}
