/************************************************
 *         					*
 *	Back Propergation Simurator(BPS)	*
 *	      subroutine package		*	
 *		Version 4.0			*
 *	  coded		in May.17 1989		*
 * 	  coded by	Y.Okamura		*	
 *	  last modified in Nov.15 1990		*
 *	  modified by	K.Kuroda		*
 * 	   					*
 *************************************************
 *						*
 *	filename getparam.c			*		
 *  	parameter file handling functions 	*
 *						*
 ************************************************/
#define  _BPS_GETPARAM_
#include "BPS.h"

bpspr_t    bps_sp;
lay_t     *BPNet[MAX_LAYER];

/* GLOBAL VARIABLES */
int        NumOfLayer = 0;              /* number of layer */
int        NumOfCell[MAX_LAYER];        /* number of each layer's cell    */
char       FuncBias[MAX_LAYER][5];      /* status of char.func and bias */
int        NumOfPtrn  = 0;              /* number of pattern */

/* GLOBAL VARIABLES FOR HISTORY FILE HANDLE */
float     *ErrBuffer = NULL;            /* error history output buffer */
double    *buff_err  = NULL;            /* error history (buffer),
					   used only in learn and learn lib */
float    **InputData;                   /* input data for learning */
float    **TeachData;                   /* teach data for learning */

int        NumOfLink;                   /* num. of all link */

/* GLOBAL VARIABLES FOR INITIALIZE */
char       InitAlgo;                    /* initialize algorithm */
char       InitWgtFile[FILE_LENGTH];    /* initialize weight file name
					   for initialize */
int        Seed;                        /* seed */
double     MaxInitWgt;                  /* maximum of initialize data */
double     MinInitWgt;                  /* minimum of initialize data */

/* GLOBAL VARIABLES FOR LEARN */
char       LrnInitWgtFile[FILE_LENGTH]; /* initialize weight for learning */
char       WgtHistoryFile[FILE_LENGTH]; /* weight history file name */
int        WgtStorInterval;             /* weight store interval */
char       WgtStorMode;                 /* store mode for weight */

char       ErrHistoryFile[FILE_LENGTH]; /* error histoy file name */
int        ErrStorInterval;             /* error store interval */
char       ErrStorDirection;            /* store direction for error */
char       ErrStorMode;                 /* store mode for error */

char       InputFile[FILE_LENGTH];      /* input data file name for learning */
char       TeachFile[FILE_LENGTH];      /* teach data file name for learning */
int        LrnFirstPtrn;                /* first pattern number of learning
					   (0:all) */
int        LrnLastPtrn;                 /* last pattern */

char       LearnMode;                   /* learning mode */
char       LearnAlgo;                   /* learning algorithm */
double     LearnRate;                   /* learning rate */
double     Momentum;                    /* momentum */
double     ReductFact;                  /* reduction factor for learn. rate */
double     IncreaseFact;                /* increasing factor for learn. rate */
int        VglCoef[FILE_LENGTH];        /* Vogl coefficient for moment2 */ 
double     InitMoment;                  /* initial momentum */
double     VoglThresh;                  /* threshold for Vogl method */
double     Theta;                       /* for Ochiai's method */

double     SumOfErr;                    /* sum of learning error */
double    *OutCellErr;                  /* error for output cell */

double     MinError;                    /* min. error for end */
int        MaxLearnCount;               /* max. learn count for end */

int        DisplayInterval;             /* display interval (console) */
char       Comment[FILE_LENGTH];        /* comment */

/* GLOBAL VARIABLES FOR TEST */
char       TestWgtFile[FILE_LENGTH];    /* weight file name for test */
int        WgtHistoryNo;                /* weight history number */
char       TestFile[FILE_LENGTH];       /* test data file name */
int        TestFirstPtrn;               /* first pattern number of test */
int        TestLastPtrn;                /* last pattern number of test */
int        InputLayer;                  /* input layer No. */
int        OutputLayer;                 /* output layer No. */
char       ActFile[FILE_LENGTH];        /* result file name */
float     *act_buf;                     /* activation buffer */



/* ϤĤäƤʤ take  */

/* float  *Data; */
/* int     BufferNo; */
/* int     FileNo; */
/* char    FileName[FILE_LENGTH]; */ /* move to loadlib.c */
/* char    FileType; */

/* float   WgtInData[HBUFSIZE]; */      /* weight history input work */
/* float   WgtOutData[HBUFSIZE];  */    /* weight history output work */
/* float   ErrOutData[HBUFSIZE]; */     /* error history output work */
/* int     WgtMaxDataPoint; */          /* maximum data point of weight */
/* int     ErrMaxDataPoint; */          /* maximum data point of error */
/* int     WgtBlockSize;    */          /* weight history block size(record) */
/* int     ErrBlockSize;    */          /* error history block size(record) */
/* float   ActOutData[HBUFSIZE];     */ /* test result work */
/* int     ActBlockSize;             */ /* result file block size(record) */
/* int     ActMaxDataPoint;          */ /* maximum datapoint for result */


/************************************************
  get structure of network parameters
  ************************************************/
void
GetStructureParameters()
{
  int    lay, i;

  rebps();
    
  NumOfLayer = bps_sp.NumOfLayer;
  for (lay=0; lay<NumOfLayer; lay++) {
    for (i=0; i<2; i++)
      FuncBias[lay][i] = bps_sp.FuncBias[lay][i];
    NumOfCell[lay] = bps_sp.NumOfCell[lay];
  }
}

/************************************************
  print parameter of structure of network
  ************************************************/
void
PrintStructureParameters()
{
  int    lay;

  printf("\n\n<<  structure of network  >>\n");
  printf("### Number of layer =%d\n", NumOfLayer);
  printf("    layer     num of cells        condition\n");
  for (lay=0; lay<NumOfLayer; lay++) {
    printf("       %2d        %5d", lay, NumOfCell[lay]);

    switch (FuncBias[lay][0]) {
    case SIGMOID:  printf("         sigmoid,"); break;
    case LINEAR:   printf("         linear,"); break;
    default:       printf("\n"); exit(110);
    }
    switch (FuncBias[lay][1]) {
    case 'A':      printf(" append bias\n");    break;
    case 'N':      printf(" non bias\n");       break;
    default:       printf("\n"); exit(111);
    } 
  }
}

/************************************************
  get initialize parameters
  ************************************************/
void
GetInitializeParameters()
{
  rebps();
    
  InitAlgo = bps_sp.InitAlgo;
  strcpy(InitWgtFile, bps_sp.InitWgtFile);
  Seed = bps_sp.Seed;
  MaxInitWgt = bps_sp.MaxInitWgt;
  MinInitWgt = bps_sp.MinInitWgt;
}

/************************************************
  print initialize parameters
  ************************************************/
void    PrintInitializeParameters()
{
  printf("\n\n<<  Initialize condition  >>\n");
  printf("### Init algorithm      = ");
  switch (InitAlgo) {
  case RANDUM: printf("random\n");          break;
  case JIA:    printf("Jia's algorithm\n"); break;
  default:     printf("\n");exit(210);
  }
  printf("### Initialize data file name = %s\n", InitWgtFile);
  printf("    Seed     Max Weight     Min Weighdt\n");
  printf("  %6d         %6g         %6g\n", Seed, MaxInitWgt, MinInitWgt);
}

/************************************************
  get learning parameters
  ************************************************/
void
GetLearningParameters()
{
  rebps();

  strcpy(LrnInitWgtFile, bps_sp.LrnInitWgtFile);
  strcpy(WgtHistoryFile, bps_sp.WgtHistoryFile);
  WgtStorInterval = bps_sp.WgtStorInterval;
  switch (bps_sp.WgtStorMode) {
  case APPEND:    WgtStorMode = APPEND;    break;
  case OVERWRITE: WgtStorMode = OVERWRITE; break;
  default:        exit(202);
  }

  strcpy(ErrHistoryFile, bps_sp.ErrHistoryFile);
  ErrStorInterval = bps_sp.ErrStorInterval;
  switch (bps_sp.ErrStorDirection) {
  case RECORD:
    ErrStorDirection = RECORD;
    switch (bps_sp.ErrStorMode) {
    case APPEND:     ErrStorMode = APPEND;    break;
    case OVERWRITE:  ErrStorMode = OVERWRITE; break;
    default:         exit(202);
    }
    break;
  case DATAPOINT:
    ErrStorDirection = DATAPOINT;
    switch (bps_sp.ErrStorMode) {
    case APPEND:     ErrStorMode = APPEND;    break;
    case OVERWRITE:  ErrStorMode = OVERWRITE; break;
    default:         exit(202);
    }
    break;
/*
    ErrStorMode      = APPEND;
*/
  default:
    exit(201);
  }

  strcpy(InputFile, bps_sp.InputFile);
  strcpy(TeachFile, bps_sp.TeachFile);

  LrnFirstPtrn = bps_sp.LrnFirstPtrn;
  LrnLastPtrn = bps_sp.LrnLastPtrn;
  if (LrnFirstPtrn > LrnLastPtrn) exit(205);

  switch (bps_sp.LearnMode) {
  case SET_LEARN:      LearnMode = SET_LEARN;     break;
  case PATTERN_LEARN:  LearnMode = PATTERN_LEARN; break;
  default:             exit(202);
  }    

  LearnAlgo = bps_sp.LearnAlgo;
  if ((LearnAlgo >= STEEP) && (LearnAlgo <= OCHI))
    LearnRate = bps_sp.LearnRate;

  if ((LearnAlgo >= MOMENTUM) && (LearnAlgo <= OCHI))
    Momentum = bps_sp.Momentum;

  if (LearnAlgo == VOGL || LearnAlgo == JACOB || LearnAlgo == OCHI) {
    IncreaseFact = bps_sp.IncreaseFact;
    ReductFact = bps_sp.ReductFact;
    InitMoment = Momentum;
  }
  if (LearnAlgo == VOGL)
    VoglThresh = bps_sp.VoglThresh;    
  if (LearnAlgo == OCHI)
    Theta = bps_sp.Theta;
    
  MinError = bps_sp.MinError;
  MaxLearnCount = bps_sp.MaxLearnCount;
        
  DisplayInterval = bps_sp.DisplayInterval;
  strcpy(Comment, bps_sp.Comment);
}

/************************************************
  print learning parameters
  ************************************************/
void
PrintLearningParameters()
{
  printf("\n\n<<  Learning condition  >>\n");
  printf("### Initialize data file name = %s\n", LrnInitWgtFile);
  printf("### Weight history file name  = %s\n", WgtHistoryFile);
  printf("    Store   Interval     Mode\n");
  printf("             %5d      ", WgtStorInterval);

  switch (WgtStorMode) {
  case APPEND:    printf("append\n");    break;
  case OVERWRITE: printf("overwrite\n"); break;
  default:        printf("\n"); exit(202);
  }

  printf("### Error history file name = %s\n", ErrHistoryFile);
  printf("    Store   interval   direction");
  if (ErrStorDirection == RECORD) printf("     mode\n");
  else printf("\n");
  printf("             %5d     ", ErrStorInterval);
  switch (ErrStorDirection) {
  case RECORD:
    printf(" record      ");
    switch (ErrStorMode) {
    case APPEND:     printf("append\n");     break;
    case OVERWRITE:  printf("ovarwrite\n");  break;
    default:         printf("\n"); exit(202);
    }
    break;
  case DATAPOINT:
    printf("data point\n");
    break;
  default:
    printf("\n"); exit(201);
  }

  printf("### Input data file name = %s\n", InputFile);
  printf("### Teach data file name = %s\n", TeachFile);

  if (LrnFirstPtrn > LrnLastPtrn) exit(205);

  printf("    Input pattern number = ");

  if (LrnFirstPtrn == 0)
    printf("all\n");
  else
    printf("%d -> %d\n", LrnFirstPtrn, LrnLastPtrn);

  printf("### Learning mode     = ");
  switch (LearnMode) {
  case SET_LEARN:     printf("set learning\n");     break;
  case PATTERN_LEARN: printf("pattern learning\n"); break;
  default:            printf("\n"); exit(202);
  }    

  printf("### Learning algorithm  = ");
  switch (LearnAlgo) {
  case STEEP:     printf("steep\n");    break;
  case MOMENTUM:  printf("momentum\n"); break;
  case VOGL:      printf("Vogl\n");     break;
  case JACOB:     printf("Jacob's\n");  break;
  case MOMENTUM2: printf("momentum Vogl's coefficient\n"); break;
  case OCHI:      printf("Ochiai's method\n"); break;
  default:        printf("\n"); exit(210);
  }

  if ((LearnAlgo >= STEEP) && (LearnAlgo <= OCHI))
    printf("    Learning rate = %g\n", LearnRate);

  if ((LearnAlgo >= MOMENTUM) && (LearnAlgo <= OCHI))
    printf("    Momentum      = %g\n", Momentum);

  if (LearnAlgo == VOGL  ||
      LearnAlgo == JACOB ||
      LearnAlgo == OCHI) {
    printf("    Increasing factor rate = %g\n", IncreaseFact);
    printf("    Reduction factor rate  = %g\n", ReductFact);
  }
  if (LearnAlgo == VOGL)
    printf("    Threshold for Vogl method = %g\n", VoglThresh);

  if (LearnAlgo == OCHI)
    printf("    Theta for Ochiai's method = %g\n", Theta);

  printf("### Minimum error for end     = %g\n", MinError);
  printf("### Maximum iteration for end = %d\n", MaxLearnCount);
        
  printf("### Display interval = %d\n", DisplayInterval);
  printf("### Comment = %s\n", Comment);
}

/************************************************
  get testing parameters
  ************************************************/
void
GetTestingParameters()
{
  rebps();

  strcpy(TestWgtFile, bps_sp.TestWgtFile);
  strcpy(TestFile, bps_sp.TestFile);
  WgtHistoryNo = bps_sp.WgtHistoryNo;

  TestFirstPtrn = bps_sp.TestFirstPtrn;
  TestLastPtrn = bps_sp.TestLastPtrn;

  if (TestFirstPtrn > TestLastPtrn) exit(205);

  InputLayer = bps_sp.InputLayer;
  OutputLayer = bps_sp.OutputLayer;

  strcpy(ActFile, bps_sp.ActFile);
}

/************************************************
  print testing parameters
  ************************************************/
void
PrintTestingParameters()
{
  printf("\n\n<<  Testing condition  >>\n");
  printf("### Weight file for test = %s\n", TestWgtFile);
  printf("### Weight history number = %d\n", WgtHistoryNo);

  printf("### Input data file for test = %s\n", TestFile);
  if (TestFirstPtrn > TestLastPtrn) exit(205);

  printf("    Input pattern number     = ");

  if (TestFirstPtrn == 0) {
    printf("all\n");
  } else
    printf("%d -> %d\n", TestFirstPtrn, TestLastPtrn);

  printf("### Input layer  = %d\n", InputLayer);
  printf("### Output layer = %d\n", OutputLayer);

  printf("### Result file for test     = %s\n", ActFile);
}
