/*************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *               Ver                             *
 *         coded         in Nov.16 1989          *
 *         modified by   K.Kuroda                *
 *                                               *
 *************************************************
 *                                               *
 *       filename learnlib.c                     *
 *                                               *
 *************************************************/
#include	"BPS.h"

/************************************************
  workspace initialize
  ************************************************/
void
workspace_initialize()
{
  int      lay, unit;
  ilin_t  *linkpoint;

  for (lay = 0; lay < NumOfLayer; lay++)
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      linkpoint = Getintoplist(BPNet[lay][unit].CellNode);
      while (linkpoint != NULL) {
	linkpoint->WgtWork = 0.0;
	linkpoint          = Getinfwdlist(linkpoint);
      }
    }
}

/************************************************
  system initialize
  ************************************************/
void
system_initialize()
{
  /* PARAMETER INITIALIZE */
  if (ErrStorInterval == 0)  ErrStorInterval = 1;
  if (WgtStorInterval == 0)  WgtStorInterval = 1;
  if (DisplayInterval == 0)  DisplayInterval = 1;

  /*  CleanHistArray(ErrOutData); no use */
  /*  CleanHistArray(WgtOutData); no use */

  /*  ErrMaxDataPoint = 0; */
  /*  WgtMaxDataPoint = 0; */

  /*    syscom.buff_leng = HBUFSIZE;  */   /* not used  */
  write_syscom();

  /* SET NumOfLink, WgtBlockSize AND  ErrBlockSize */
  SetNumOfLink();

  /*  WgtBlockSize = NumOfLink / HBUFSIZE;
      if ((NumOfLink % HBUFSIZE) != 0)
      WgtBlockSize++; */

  /* ErrBlockSize = (NumOfCell[NumOfLayer-1] + 1) / HBUFSIZE;
     if (((NumOfCell[NumOfLayer-1] + 1) % HBUFSIZE) != 0)
     ErrBlockSize++; */

  /* SET PATTERN No. */
  if ((LrnFirstPtrn == 0) || (LrnLastPtrn == 0)) {
    LrnFirstPtrn = 1;
    LrnLastPtrn  = GetNumOfRecord(InputFile);
  }

  NumOfPtrn = LrnLastPtrn-LrnFirstPtrn + 1;

  /* SET INPUT DATA AND TEACH DATA */
  if (access(InputFile, 0) == -1) exit(35);
  if (access(TeachFile, 0) == -1) exit(36);

  InputData = (float**)malloc2D(NumOfPtrn, NumOfCell[0], sizeof(float));
  if (InputData == NULL) exit(41);

  TeachData = (float**)malloc2D(NumOfPtrn, NumOfCell[NumOfLayer-1],
				sizeof(float));
  if (TeachData == NULL) exit(42);

  printf("before ReadData routine\n");
  printf("InputFile = %s\n", InputFile);
  printf("TeachFile = %s\n", TeachFile);

  printf("LrnFirstPtrn = %d\n",LrnFirstPtrn);
  printf("LenLastPtrn  = %d\n",LrnLastPtrn);

  ReadData(InputFile, InputData, LrnFirstPtrn, LrnLastPtrn, NumOfCell[0]);
  ReadData(TeachFile, TeachData, LrnFirstPtrn, LrnLastPtrn,
	   NumOfCell[NumOfLayer-1]);

  /* ALLOCATE TO OutCellErr */
  OutCellErr = (double*)malloc((NumOfCell[NumOfLayer-1]+1)*sizeof(double));
  if (OutCellErr == NULL) exit(37);

  /* ALLOCATE TO ErrBuffer  */
  ErrBuffer = (float*)calloc(MaxLearnCount+1, sizeof(float));
  if(ErrBuffer == NULL)   exit(37);

  buff_err = (double*)calloc(MaxLearnCount+1, sizeof(double));
  if(buff_err == NULL)    exit(37);
}

/************************************************
  system end
  ************************************************/
void
system_end()
{
  free(OutCellErr);
  free(InputData);
  free(TeachData);
}

/************************************************
  forward larning routine
  inputs:
  inputdata : input data
  teachdata : teach data
  ************************************************/
double
forward_learn(inputdata, teachdata)
     float          *inputdata, *teachdata;
{

  int       lay, unit;
  double    net, err_tmp;
  cel_t    *cellpoint, *cur_cel;
  ilin_t   *cur_ilin;

  for (unit = 1; unit <= NumOfCell[0]; unit++) {
    cur_cel         = BPNet[0][unit].CellNode;
    cur_cel->Net    = (double) inputdata[unit-1];
    cur_cel->Active = FuncSelect(cur_cel->CharFunc, cur_cel->Net);
  }
  for (lay = 1; lay < NumOfLayer; lay++) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      net = 0.0;
      cur_cel  = BPNet[lay][unit].CellNode;
      cur_ilin = Getintoplist(cur_cel);
      while (cur_ilin != NULL) {
	cellpoint  = cur_ilin->InputCell;
	net       += cur_ilin->Weight * cellpoint->Active;
	cur_ilin   = Getinfwdlist(cur_ilin);
      }
      cur_cel->Net    = net;
      cur_cel->Active = FuncSelect(cur_cel->CharFunc, net);
    }
  }

  err_tmp = 0.0;
  for (unit = 1; unit <= NumOfCell[NumOfLayer-1]; unit++) {
    cellpoint           = BPNet[NumOfLayer-1][unit].CellNode;
    cellpoint->Delta    = (double)(teachdata[unit-1]) - cellpoint->Active;

    OutCellErr[unit-1] += cellpoint->Delta * cellpoint->Delta;
    err_tmp            += cellpoint->Delta * cellpoint->Delta;
  }
  return (err_tmp);
}

/************************************************
  backward larning routine
  ************************************************/
void
backward_learn()
{
  int      lay, unit;
  double   delta_tmp;
  cel_t   *cellpoint, *cur_cel;
  ilin_t  *cur_ilin;
  olin_t  *cur_olin;

  for (unit = 1; unit <= NumOfCell[NumOfLayer-1]; unit++) {
    cur_cel        = BPNet[NumOfLayer-1][unit].CellNode;
    cur_cel->Delta = (cur_cel->Delta
		      * DiffSelect(cur_cel->CharFunc, cur_cel->Net));
    cur_ilin       = Getintoplist(cur_cel);
    while (cur_ilin != NULL) {
      cellpoint          = cur_ilin->InputCell;
      cur_ilin->WgtWork += cur_cel->Delta * cellpoint->Active;
      cur_ilin           = Getinfwdlist(cur_ilin);
    }
  }

  for (lay = NumOfLayer-2; lay > -1; lay--) {
    for (unit = 1; unit <= NumOfCell[lay]; unit++) {
      delta_tmp = 0.0;
      cur_cel   = BPNet[lay][unit].CellNode;
      cur_olin  = Getouttoplist(cur_cel);
      while (cur_olin != NULL) {
	cur_ilin   = Getouttolist(cur_olin);
	cellpoint  = cur_ilin->NodeCell;
	delta_tmp += cellpoint->Delta * cur_ilin->Weight;
	cur_olin   = Getoutfwdlist(cur_olin);
      }
      cur_cel->Delta = (delta_tmp
			* DiffSelect(cur_cel->CharFunc, cur_cel->Net));
      cur_ilin       = Getintoplist(cur_cel);
      while (cur_ilin != NULL) {
	cellpoint          = cur_ilin->InputCell;
	cur_ilin->WgtWork += cur_cel->Delta * cellpoint->Active;
	cur_ilin           = Getinfwdlist(cur_ilin);
      }
    }
  }
}
