/************************************************
 * 						*
 *	Back Propergation Simurator(BPS)	*
 *	      subroutine package		*
 *	        Version 4.0         	 	*
 *	  coded		in Aug.25 1989		*	
 *	  coded by 	Y.Okamura		*	
 *	  last modified in Nov.15 1990		*	
 *	  modified by	K.Kuroda		*	
 *						*
 ************************************************
 *						*
 *	filename nethndl.c			*
 *	    network hander			*
 *						*
 ************************************************/
#include  "BPS.h"

/************************************************
  get link between two cells
  inputs:
  from_cell : link from
  to_cell   : link to
  return:
  element of input link list
  ***********************************************/
ilin_t	*
inter_ilin(from_cell, to_cell)
     cel_t  *from_cell , *to_cell;
{
  ilin_t  *link_pt;

  link_pt = Getintoplist(to_cell);
  for (;;) {
    if (link_pt == NULL) exit(120);
    if (from_cell == link_pt->InputCell) break;
    link_pt = Getinfwdlist(link_pt);
  }
  return(link_pt);
}

/************************************************
  get link between two cells
  inputs:
  from_cell : link from
  to_cell   : link to
  return:
  element of output link list
  ***********************************************/
olin_t	*
inter_olin(from_cell , to_cell)
     cel_t *from_cell , *to_cell;
{
  olin_t  *link_pt;
  ilin_t  *out_ilink;

  link_pt = Getouttoplist(from_cell);
  for (;;) {
    if (link_pt == NULL) exit(120);
    out_ilink = Getouttolist(link_pt);
    if (to_cell == out_ilink->NodeCell) break;
    link_pt = Getoutfwdlist(link_pt);
  }
  return(link_pt);
}

/************************************************
  set weight between two cells
  inputs:
  from_cell : link from
  to_cell   : link to
  weight	  : weight
  ***********************************************/
void
SetWeight(from_cell , to_cell , weight)
     cel_t  *from_cell, *to_cell;
     double  weight;
{
  ilin_t  *link_pt;
	
  link_pt = inter_ilin(from_cell , to_cell);
  link_pt->Weight = weight;
}

/************************************************
  get weight between two cells
  inputs:
  from_cell : link from
  to_cell   : link to
  ***********************************************/
double
GetWeight(from_cell , to_cell)
     cel_t  *from_cell, *to_cell;
{
  ilin_t  *link_pt;
	
  link_pt = inter_ilin(from_cell , to_cell);
  return(link_pt->Weight);
}

/************************************************
  set deltaw between two cells
  inputs:
  from_cell : link from
  to_cell   : link to
  deltaw    : delta weight
  ***********************************************/
void
SetDeltaWgt(from_cell , to_cell , deltaw)
     cel_t  *from_cell, *to_cell;
     double  deltaw;
{
  ilin_t  *link_pt;
	
  link_pt = inter_ilin(from_cell , to_cell);
  link_pt->AdjWgt = deltaw;
}

/************************************************
  make cell node
  return:
  cell node pointer
  **********************************************/
cel_t *
make_cell()
{
  cel_t  *cellpoint;
	
  cellpoint = (cel_t*)malloc(sizeof(cel_t));
  if (cellpoint == NULL) exit(121);

  cellpoint->InTopList  = NULL;
  cellpoint->OutTopList = NULL;
  cellpoint->Active    	= 0.0;
  cellpoint->CharFunc 	= EOS;
  cellpoint->Delta     	= 0.0;
  cellpoint->Net        = 0.0;
  cellpoint->SelFlg   	= 0;

  return(cellpoint);
}

/************************************************
  connect between two cells
  inputs:
  from_cell : link from
  to_cell   : link to
  **********************************************/
void
Connect(from_cell, to_cell)
     cel_t  *from_cell, *to_cell;
{
  ilin_t  *cur_ilin , *nxt_ilin;
  olin_t  *cur_olin , *nxt_olin;
	
  nxt_ilin = Getintoplist(to_cell);
  if (nxt_ilin == NULL) {
    to_cell->InTopList = (ilin_t*)malloc(sizeof(ilin_t));
    if (to_cell->InTopList == NULL) exit(122);
    nxt_ilin = Getintoplist(to_cell);
    cur_ilin = NULL;
  }
  else{
    while (nxt_ilin != NULL) {
      cur_ilin = nxt_ilin;
      nxt_ilin = Getinfwdlist(nxt_ilin);
    }
    cur_ilin->InFwdList = (ilin_t*)malloc(sizeof(ilin_t));
    if (cur_ilin->InFwdList == NULL) exit(122);
    nxt_ilin = Getinfwdlist(cur_ilin);
  }
	
  nxt_ilin->InFwdList  = NULL;
  nxt_ilin->InBwdList  = cur_ilin;
  nxt_ilin->InputCell  = from_cell;
  nxt_ilin->NodeCell   = to_cell;
  nxt_ilin->Weight     = 0.0;
  nxt_ilin->AdjWgt     = 0.0;
  nxt_ilin->WgtWork    = 0.0;
  nxt_ilin->CoefLearn  = 0.0;
  nxt_ilin->dltold     = 0.0;
  nxt_ilin->dltwgtold  = 0.0;
  nxt_ilin->wgtworkold = 0.0;
  nxt_ilin->dltwork    = 0.0;
  nxt_ilin->dltworkold = 0.0;

  nxt_olin = Getouttoplist(from_cell);
  if (nxt_olin == NULL) {
    from_cell->OutTopList = (olin_t*)malloc(sizeof(olin_t));
    if (from_cell->OutTopList == NULL) exit(123);
    nxt_olin = Getouttoplist(from_cell);
    cur_olin = NULL;
  }
  else{
    while (nxt_olin != NULL) {
      cur_olin = nxt_olin;
      nxt_olin = Getoutfwdlist(nxt_olin);
    }
    cur_olin->OutFwdList = (olin_t*)malloc(sizeof(olin_t));
    if (cur_olin->OutFwdList == NULL) exit(123);
    nxt_olin = Getoutfwdlist(cur_olin);
  }
  nxt_olin->OutFwdList = NULL;
  nxt_olin->OutBwdList = cur_olin;
  nxt_olin->OutToList  = nxt_ilin;
}

/************************************************
  make normal BP network
  **********************************************/
void
MakeNetwork()
{
  int	lay, unit, unit_to, unit_from, cell_cnt;
  int	num;

  cell_cnt = 0;
	
  for (lay=0; lay<NumOfLayer; lay++) {

    num = (NumOfCell[lay]+1) * sizeof(lay_t);

    BPNet[lay] = (lay_t*)malloc(num);
    if (BPNet[lay] == NULL) exit(124);

    for (unit=0; unit<=NumOfCell[lay]; unit++) {
      BPNet[lay][unit].CellNode = make_cell();
      BPNet[lay][unit].CellNo = cell_cnt++;
    }
  }

  for (unit=0; unit<=NumOfCell[0]; unit++)
    (BPNet[0][unit].CellNode)->CharFunc = FuncBias[0][0]; 

  for (lay=1; lay<NumOfLayer; lay++) {
    for (unit_to=1; unit_to<=NumOfCell[lay]; unit_to++) {
      if (CheckBias(lay)) {
	Connect(BPNet[lay][0].CellNode, BPNet[lay][unit_to].CellNode);
	(BPNet[lay][0].CellNode)->Active = 1.0;
      }
      for (unit_from=1; unit_from<=NumOfCell[lay-1]; unit_from++) 
	Connect(BPNet[lay-1][unit_from].CellNode,
		BPNet[lay][unit_to].CellNode);
    }
    for (unit=0; unit<=NumOfCell[lay]; unit++)
      (BPNet[lay][unit].CellNode)->CharFunc = FuncBias[lay][0]; 
  }
}

/************************************************
  break normal BP network
  **********************************************/
void
BreakNetwork()
{
  int	   lay, unit;
  ilin_t  *cur_ilin, *nxt_ilin;
  olin_t  *cur_olin, *nxt_olin;

  for (lay=0; lay<NumOfLayer; lay++) {
    for (unit=0; unit<=NumOfCell[lay]; unit++) {
      nxt_ilin = Getintoplist(BPNet[lay][unit].CellNode);
      while (nxt_ilin != NULL) {
	cur_ilin = nxt_ilin;
	nxt_ilin = Getinfwdlist(cur_ilin);
	free(cur_ilin);
      }

      nxt_olin = Getouttoplist(BPNet[lay][unit].CellNode);
      while (nxt_olin != NULL) {
	cur_olin = nxt_olin;
	nxt_olin = Getoutfwdlist(cur_olin);
	free(cur_olin);
      }
      free(BPNet[lay][unit].CellNode);
    }
    free(BPNet[lay]);
  }
}


/***********************************************
  read and set weight history
  inputs:
  filename   : file name
  hist_no : weight history number
  **********************************************/
void
ReadWeight2(filename, hist_no)
     char    filename[];
     int	hist_no;
{
  int	 last_hist_no, lay, unit_to, unit_from, link_cnt;
  float	*wgt_data;
  /*  Header  *head; replaced by HAGI 1993.10.17 */
  Header  head;

  if (access(filename, 0) == -1) exit(125);

  last_hist_no = LastWgtHistory(filename);

  if ((hist_no < 0) || (hist_no > last_hist_no)) exit(126);
  if (hist_no == 0) hist_no = last_hist_no;

  wgt_data = (float*)LoadData(filename, hist_no - 1 , &head); 
  hist_no++;

  /* SET WEIGHT TO BP NETWORK */
  link_cnt = 0;
  for (lay=1; lay<NumOfLayer; lay++) {
    for (unit_to=1; unit_to<=NumOfCell[lay]; unit_to++) {
      if (CheckBias(lay))
	SetWeight(BPNet[lay][0].CellNode , BPNet[lay][unit_to].CellNode ,
		  wgt_data[link_cnt++]);
      for (unit_from=1; unit_from<=NumOfCell[lay-1]; unit_from++)
	SetWeight(BPNet[lay-1][unit_from].CellNode,
		  BPNet[lay][unit_to].CellNode , wgt_data[link_cnt++]);
    }
  }
  free(wgt_data);

  wgt_data = (float*)LoadData(filename, hist_no - 1, &head);
  hist_no++;
	
  /* SET DELTA WEIGHT TO BP NETWORK */
  link_cnt = 0;
  for (lay=1; lay<NumOfLayer; lay++) {
    for (unit_to=1; unit_to<=NumOfCell[lay]; unit_to++) {
      if (CheckBias(lay))
	SetDeltaWgt(BPNet[lay][0].CellNode,
		    BPNet[lay][unit_to].CellNode, wgt_data[link_cnt++]);
      for (unit_from=1; unit_from<=NumOfCell[lay-1]; unit_from++)
	SetDeltaWgt(BPNet[lay-1][unit_from].CellNode,
		    BPNet[lay][unit_to].CellNode, wgt_data[link_cnt++]);
    }
  }
  free(wgt_data);
}

/************************************************
  display network information
  ***********************************************/
void
netdump()
{
  int	   lay , unit;
  cel_t   *cellpoint;
  ilin_t  *ilin_pt;
  olin_t  *olin_pt;

  printf("\n\n\n**** cell dump utility ****\n");
	
  for (lay=0; lay<NumOfLayer; lay++) {
    printf("###   layer No.%d   ###\n", lay);
    for (unit=0; unit<=NumOfCell[lay]; unit++) {
      printf("<<< cell No.%d >>>\n", unit);
      cellpoint = BPNet[lay][unit].CellNode;
      printf("   address = %lx\n", (unsigned long)cellpoint);
      printf("   activation = %12e  CharFunc = %d",
	     cellpoint->Active, cellpoint->CharFunc);
      printf("  delta = %12e   net_pj = %12e\n",
	     cellpoint->Delta, cellpoint->Net);
      ilin_pt = Getintoplist(cellpoint);
      while (ilin_pt != NULL) {
	printf("   link_from =%lx   node is =%lx\n",
	       (unsigned long)ilin_pt->InputCell,
	       (unsigned long)ilin_pt->NodeCell);
	printf("   weight = %12e   adj_wgt = %12e",
	       ilin_pt->Weight, ilin_pt->AdjWgt);
	printf("   wgt_work = %12e   coe_learn = %12e\n",
	       ilin_pt->WgtWork, ilin_pt->CoefLearn);

	ilin_pt = Getinfwdlist(ilin_pt);
      }
      olin_pt = Getouttoplist(cellpoint);
      while (olin_pt != NULL) {
	ilin_pt = Getouttolist(olin_pt);
	printf("   link to =%lx \n", (unsigned long)ilin_pt->NodeCell);
	olin_pt = Getoutfwdlist(olin_pt);
      }
    }
  }
}

/************************************************
  cut between to cells
  inputs:
  from_cell : link from
  to_cell   : link to
  ***********************************************/
void
cut(from_cell, to_cell)
     cel_t  *from_cell, *to_cell;
{
  ilin_t  *fwd_ilin , *cur_ilin , *bwd_ilin;
  olin_t  *fwd_olin , *cur_olin , *bwd_olin;

  cur_ilin = inter_ilin(from_cell, to_cell);
  fwd_ilin = Getinfwdlist(cur_ilin);
  bwd_ilin = Getinbwdlist(cur_ilin);
  fwd_ilin->InBwdList = bwd_ilin;
  if (bwd_ilin == NULL) to_cell->InTopList = fwd_ilin;
  else bwd_ilin->InFwdList = fwd_ilin;
  free(cur_ilin);
	
  cur_olin = inter_olin(from_cell , to_cell);
  fwd_olin = Getoutfwdlist(cur_olin);
  bwd_olin = Getoutbwdlist(cur_olin);
  fwd_olin->OutBwdList = bwd_olin;
  if (bwd_olin == NULL) from_cell->OutTopList = fwd_olin;
  else bwd_olin->OutFwdList = fwd_olin;
  free(cur_olin);
}
