/************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *               Ver				*
 *         coded         in Nov.15 1990          *
 *         coded by      K.Kuroda                *
 *                                               *
 *************************************************
 *                                               *
 *       filename testlib.c                      *
 *           BP testing subroutine               *
 *                                               *
 ************************************************/
#include "BPS.h"

/************************************************
 * system initialize
 ************************************************/
void
rec_system_initialize()
{
  /* ActMaxDataPoint = 0; */
  /* CleanHistArray(ActOutData); */

  write_syscom();

  if (access(TestFile, 0) == -1) exit(40);

  /* CALCULATE WgtBlockSize, ErrBlockSize AND ActBlockSize */
  SetNumOfLink();

  /* WgtBlockSize = NumOfLink / HBUFSIZE;
  if ((NumOfLink % HBUFSIZE) != 0)
    WgtBlockSize++; */

  /* ErrBlockSize = (NumOfCell[OutputLayer] + 1) / HBUFSIZE;
  if (((NumOfCell[NumOfLayer - 1] + 1) % HBUFSIZE) != 0)
    ErrBlockSize++; */


  /*   ActBlockSize = NumOfCell[OutputLayer] / HBUFSIZE; */
  /*   if ((NumOfCell[OutputLayer] % HBUFSIZE) != 0)
       ActBlockSize++; */

  if ((TestFirstPtrn == 0) || (TestLastPtrn == 0)) {
    TestFirstPtrn = 1;
    TestLastPtrn = GetNumOfRecord(TestFile);
  }
  NumOfPtrn = TestLastPtrn - TestFirstPtrn + 1;

  InputData = (float **)malloc2D(NumOfPtrn, NumOfCell[InputLayer],
				  sizeof(float));
  if (InputData == NULL) exit(41);

  ReadData(TestFile, InputData, TestFirstPtrn, TestLastPtrn,
	   NumOfCell[InputLayer]);

#if 0 
  {
    int  ptrn;
    for (ptrn = 0; ptrn < NumOfPtrn; ptrn++) {
      printf("%f %f\n",InputData[ptrn][0],InputData[ptrn][1]);
    }
  }
#endif

  /* ALLOCATE for activation buffer */
  act_buf = (float*)malloc(sizeof(float)*(NumOfCell[OutputLayer]+1));
  if (act_buf == NULL)   exit(48);

  /* ALLOCATE for error buffer */
  ErrBuffer = (float*)malloc(sizeof(float)*(NumOfCell[OutputLayer]+1));
  if (ErrBuffer == NULL) exit(49);

}


/************************************************
  system end
  ************************************************/
void
rec_system_end()
{
  free(InputData);
}


/************************************************
  test routine
  input:
  in_data  : input data
  ************************************************/
void
test_network(in_data)
     float  in_data[];
{
  int       laynum, unit;
  double    net;

  cel_t    *cell_pt, *cur_cel;
  ilin_t   *cur_ilin;

  for (unit = 1; unit <= NumOfCell[InputLayer]; unit++) {
    cur_cel = BPNet[InputLayer][unit].CellNode;
    cur_cel->Net = (double)in_data[unit-1];
    cur_cel->Active = FuncSelect(cur_cel->CharFunc, cur_cel->Net);
  }
  for (laynum = InputLayer + 1; laynum <= OutputLayer; laynum++) {
    for (unit = 1; unit <= NumOfCell[laynum]; unit++) {
      net = 0.0;

      cur_cel = BPNet[laynum][unit].CellNode;
      cur_ilin = Getintoplist(cur_cel);

      while (cur_ilin != NULL) {
	cell_pt = cur_ilin->InputCell;
	net += cur_ilin->Weight * cell_pt->Active;
	cur_ilin = Getinfwdlist(cur_ilin);
      }

      cur_cel->Net = net;
      cur_cel->Active = FuncSelect(cur_cel->CharFunc, net);
    }
  }
}
